/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.Datum;
import mediathek.tool.Log;

public class DatumZeit {
    private static SimpleDateFormat sdf_datum_zeit = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
    private static SimpleDateFormat sdf_datum = new SimpleDateFormat("dd.MM.yyyy");

    public static String getJetzt_ddMMyyyy_HHmm() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HH_MM_SS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HHMMSS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getHeute_yyyyMMdd() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getHeute_dd_MM_yyyy() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getGestern_dd_MM_yyyy() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        Date today = new Date(new Date().getTime() - 86400000L);
        String output = formatter.format(today);
        return output;
    }

    public static String convertDatum(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(649600299, 0, "DatumDatum.convertDatum", ex);
        }
        return datum;
    }

    public static String convertTime(String zeit) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(zeit);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            zeit = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(663259004, 0, "DatumZeit.convertTime", ex);
        }
        return zeit;
    }

    public static Datum getDatumForObject(String datum) {
        Datum tmp = new Datum(0L);
        if (!datum.equals("")) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                tmp.setTime(sdf.parse(datum).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }

    public static Datum getDatumForObject(DatenFilm film) {
        Datum tmp = new Datum(0L);
        if (!film.arr[4].equals("")) {
            try {
                if (!film.arr[5].equals("")) {
                    tmp.setTime(sdf_datum_zeit.parse(film.arr[4] + film.arr[5]).getTime());
                } else {
                    tmp.setTime(sdf_datum.parse(film.arr[4]).getTime());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }

    public static Datum getDatumForObject(DatenDownload datenDownload) {
        Datum tmp = new Datum(0L);
        if (!datenDownload.arr[7].equals("")) {
            try {
                if (!datenDownload.arr[8].equals("")) {
                    tmp.setTime(sdf_datum_zeit.parse(datenDownload.arr[7] + datenDownload.arr[8]).getTime());
                } else {
                    tmp.setTime(sdf_datum.parse(datenDownload.arr[7]).getTime());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }
}

