/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.daten.Daten;
import mediathek.tool.DatumZeit;
import mediathek.tool.Funktionen;
import mediathek.tool.ListenerMediathekView;

public class Log {
    public static StringBuffer textSystem = new StringBuffer(10000);
    public static StringBuffer textProgramm = new StringBuffer(10000);
    public static StringBuffer textFehler = new StringBuffer();
    public static boolean playerMeldungenAus = false;
    public static final int LOG_FEHLER = 15;
    public static final int LOG_SYSTEM = 16;
    public static final int LOG_PLAYER = 17;
    public static final int FEHLER_ART_PROG = 0;
    public static final String FEHLER_ART_PROG_TEXT = "   Prog: ";
    public static final int FEHLER_ART_GETURL = 1;
    public static final String FEHLER_ART_GETURL_TEXT = " GetUrl: ";
    public static final int FEHLER_ART_MREADER = 2;
    public static final String FEHLER_ART_MREADER_TEXT = "MReader: ";
    public static final int FEHLER_ART_FILME_SUCHEN = 3;
    public static final String FEHLER_ART_FILME_SUCHEN_TEXT = "  Filme: ";
    public static final int FEHLER_ART_AUTO = 4;
    public static final String FEHLER_ART_AUTO_TEXT = "   Auto: ";
    public static final int FEHLER_ART_NOGUI = 5;
    public static final String FEHLER_ART_NOGUI_TEXT = "  NoGui: ";
    public static final int FEHLER_ART_MAX = 6;
    private static final int MAX_LAENGE_1 = 50000;
    private static final int MAX_LAENGE_2 = 30000;
    private static int zeilenNrSystem = 0;
    private static int zeilenNrProgramm = 0;
    private static int zeilenNrFehler = 0;
    private static LinkedList<Integer[]> fehlerListe = new LinkedList();
    private static boolean progress = false;
    private static String progressText = "";
    private static Date startZeit = new Date(System.currentTimeMillis());
    private static Date stopZeit = null;
    private static File logfile = null;

    public void resetFehlerListe() {
        fehlerListe.clear();
    }

    public static void setLogFile(File log) {
        logfile = log;
    }

    public static synchronized void versionsMeldungen(String classname) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Log.systemMeldung("");
        Log.systemMeldung("");
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("Programmstart: " + sdf.format(startZeit));
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("###########################################################");
        long totalMem = Runtime.getRuntime().totalMemory();
        Log.systemMeldung("totalMemory: " + totalMem / 0x100000L + " MB");
        long maxMem = Runtime.getRuntime().maxMemory();
        Log.systemMeldung("maxMemory: " + maxMem / 0x100000L + " MB");
        long freeMem = Runtime.getRuntime().freeMemory();
        Log.systemMeldung("freeMemory: " + freeMem / 0x100000L + " MB");
        Log.systemMeldung("###########################################################");
        Log.systemMeldung(Funktionen.getProgVersionString());
        Log.systemMeldung("Compiled: " + Funktionen.getCompileDate());
        Log.systemMeldung("Klassenname: " + classname);
        Log.systemMeldung("###########################################################");
    }

    public static synchronized void startMeldungen(String classname) {
        Log.versionsMeldungen(classname);
        Log.systemMeldung("Programmpfad: " + Funktionen.getPathJar());
        Log.systemMeldung("Verzeichnis Einstellungen: " + Daten.getBasisVerzeichnis());
        Log.systemMeldung("Useragent: " + Daten.getUserAgent());
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("");
        Log.systemMeldung("");
    }

    public static synchronized void debugMeldung(String text) {
        if (Daten.debug) {
            Log.debugmeldung(text);
        }
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, int art, String klasse, Exception ex) {
        Log.fehlermeldung_(fehlerNummer, art, klasse, ex, new String[0]);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, int art, String klasse, Exception ex, String text) {
        Log.fehlermeldung_(fehlerNummer, art, klasse, ex, new String[]{text});
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, int art, String klasse, Exception ex, String[] text) {
        Log.fehlermeldung_(fehlerNummer, art, klasse, ex, text);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, int art, String klasse, String text) {
        Log.fehlermeldung_(fehlerNummer, art, klasse, null, new String[]{text});
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, int art, String klasse, String[] text) {
        Log.fehlermeldung_(fehlerNummer, art, klasse, null, text);
    }

    public static synchronized void systemMeldung(String[] text) {
        Log.systemmeldung(text);
    }

    public static synchronized void systemMeldung(String text) {
        Log.systemmeldung(new String[]{text});
    }

    public static synchronized void playerMeldung(String text) {
        if (!playerMeldungenAus) {
            Log.playermeldung(new String[]{text});
        }
    }

    public static synchronized void progress(String texte) {
        progress = true;
        progressText = texte = texte + "\r";
        System.out.print(texte);
    }

    public static synchronized void progressEnde() {
        progress = false;
        progressText = "";
        System.out.print("                                                                            \r");
        System.out.println();
        System.out.println();
    }

    public static void printEndeMeldung() {
        int minuten;
        Log.systemMeldung("");
        Log.systemMeldung("");
        Log.systemMeldung("");
        Log.systemMeldung("");
        Log.systemMeldung("###########################################################");
        if (fehlerListe.size() == 0) {
            Log.systemMeldung(" Keine Fehler :)");
        } else {
            for (int i = 1; i < fehlerListe.size(); ++i) {
                int i_2;
                int i_1;
                for (int k = i; k > 0 && (i_1 = fehlerListe.get(k - 1)[1].intValue()) < (i_2 = fehlerListe.get(k)[1].intValue()); --k) {
                    fehlerListe.add(k - 1, fehlerListe.remove(k));
                }
            }
            for (Integer[] integers : fehlerListe) {
                String z;
                switch (integers[0]) {
                    case 2: {
                        z = FEHLER_ART_MREADER_TEXT;
                        break;
                    }
                    case 3: {
                        z = FEHLER_ART_FILME_SUCHEN_TEXT;
                        break;
                    }
                    case 1: {
                        z = FEHLER_ART_GETURL_TEXT;
                        break;
                    }
                    case 0: {
                        z = FEHLER_ART_PROG_TEXT;
                        break;
                    }
                    case 5: {
                        z = FEHLER_ART_NOGUI_TEXT;
                        break;
                    }
                    case 4: {
                        z = FEHLER_ART_AUTO_TEXT;
                        break;
                    }
                    default: {
                        z = "";
                    }
                }
                boolean ex = integers[3] == 1;
                String strEx = ex ? "Ex! " : "    ";
                if (integers[1] < 0) {
                    Log.systemMeldung(strEx + z + " Fehlernummer: " + integers[1] + " Anzahl: " + integers[2]);
                    continue;
                }
                Log.systemMeldung(strEx + z + " Fehlernummer:  " + integers[1] + " Anzahl: " + integers[2]);
            }
        }
        Log.systemMeldung("###########################################################");
        stopZeit = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        try {
            minuten = Math.round((stopZeit.getTime() - startZeit.getTime()) / 60000L);
        }
        catch (Exception ex) {
            minuten = -1;
        }
        Log.systemMeldung("");
        Log.systemMeldung("");
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("   --> Beginn: " + sdf.format(startZeit));
        Log.systemMeldung("   --> Fertig: " + sdf.format(stopZeit));
        Log.systemMeldung("   --> Dauer[Min]: " + (minuten == 0 ? "<1" : Integer.valueOf(minuten)));
        Log.systemMeldung("###########################################################");
        Log.systemMeldung("");
        Log.systemMeldung("   und Tschuess");
        Log.systemMeldung("");
        Log.systemMeldung("");
        Log.systemMeldung("###########################################################");
    }

    private static void addFehlerNummer(int nr, int art, boolean exception) {
        int ex;
        Iterator it = fehlerListe.iterator();
        int n = ex = exception ? (ex = 1) : (ex = 2);
        while (it.hasNext()) {
            Integer[] i = (Integer[])it.next();
            if (i[1] != nr) continue;
            i[0] = art;
            Integer[] integerArray = i;
            Integer n2 = integerArray[2];
            Integer n3 = integerArray[2] = Integer.valueOf(integerArray[2] + 1);
            i[3] = ex;
            return;
        }
        fehlerListe.add(new Integer[]{new Integer(art), new Integer(nr), new Integer(1), new Integer(ex)});
    }

    private static void fehlermeldung_(int fehlerNummer, int art, String klasse, Exception ex, String[] texte) {
        Log.addFehlerNummer(fehlerNummer, art, ex != null);
        if (ex != null || Daten.debug) {
            String z;
            if (progress) {
                System.out.print("                                                                            \r");
            }
            String FEHLER = "Fehler(MediathekView): ";
            String x = ex != null ? "!" : "=";
            switch (art) {
                case 2: {
                    z = "  ==>";
                    break;
                }
                case 3: {
                    z = "   >>";
                    break;
                }
                case 1: {
                    z = "  ++>";
                    break;
                }
                default: {
                    z = "*";
                }
            }
            System.out.println(x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x);
            System.out.println(z + " Fehlernr: " + fehlerNummer);
            System.out.println(z + " " + "Fehler(MediathekView): " + klasse);
            Log.notifyMediathekListener(15, "Fehler(MediathekView): " + klasse);
            for (int i = 0; i < texte.length; ++i) {
                System.out.println(z + "           " + texte[i]);
                Log.notifyMediathekListener(15, texte[i]);
            }
            System.out.println("");
            if (progress) {
                System.out.print(progressText);
            }
        }
    }

    private static void debugmeldung(String texte) {
        if (progress) {
            System.out.print("                                                                            \r");
        }
        System.out.println("|||| " + texte);
        if (progress) {
            System.out.print(progressText);
        }
    }

    private static void systemmeldung(String[] texte) {
        if (progress) {
            System.out.print("                                                                            \r");
        }
        String z = ". ";
        if (texte.length <= 1) {
            System.out.println(".  " + texte[0]);
            Log.notifyMediathekListener(16, texte[0]);
        } else {
            String zeile = "---------------------------------------";
            System.out.println(". " + zeile);
            Log.notifyMediathekListener(16, zeile);
            for (int i = 0; i < texte.length; ++i) {
                String txt = "| " + texte[i];
                System.out.println(". " + txt);
                if (i == 0) {
                    Log.notifyMediathekListener(16, texte[i]);
                    continue;
                }
                Log.notifyMediathekListener(16, "    " + texte[i]);
            }
            Log.notifyMediathekListener(16, " ");
            System.out.println(". " + zeile);
        }
        if (progress) {
            System.out.print(progressText);
        }
        Log.logFileSchreiben(texte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void logFileSchreiben(String[] texte) {
        if (logfile != null) {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(new FileOutputStream(logfile, true));
                for (int i = 0; i < texte.length; ++i) {
                    String s = texte[i];
                    if (s.equals("")) {
                        writer.write("\n");
                        continue;
                    }
                    writer.write(DatumZeit.getJetzt_ddMMyyyy_HHmm() + "     " + s);
                    writer.write("\n");
                }
                writer.close();
            }
            catch (Exception ex) {
                System.out.println("Fehler beim Logfile schreiben: " + ex.getMessage());
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void playermeldung(String[] texte) {
        if (progress) {
            System.out.print("                                                                            \r");
        }
        String z = "  >>";
        System.out.println("  >> " + texte[0]);
        Log.notifyMediathekListener(17, texte[0]);
        for (int i = 1; i < texte.length; ++i) {
            System.out.println("  >> " + texte[i]);
            Log.notifyMediathekListener(17, texte[i]);
        }
        if (progress) {
            System.out.print(progressText);
        }
    }

    public static void clearText(int art) {
        if (art == 15) {
            zeilenNrFehler = 0;
            textFehler.setLength(0);
        } else if (art == 16) {
            zeilenNrSystem = 0;
            textSystem.setLength(0);
        } else if (art == 17) {
            zeilenNrProgramm = 0;
            textProgramm.setLength(0);
        }
        ListenerMediathekView.notify(art, Log.class.getName());
    }

    private static void notifyMediathekListener(int art, String zeile) {
        if (art == 15) {
            Log.addText(textFehler, "[" + Log.getNr(zeilenNrFehler++) + "]   " + zeile);
        } else if (art == 16) {
            Log.addText(textSystem, "[" + Log.getNr(zeilenNrSystem++) + "]   " + zeile);
        } else if (art == 17) {
            Log.addText(textProgramm, "[" + Log.getNr(zeilenNrProgramm++) + "]   " + zeile);
        }
        ListenerMediathekView.notify(art, Log.class.getName());
    }

    private static String getNr(int nr) {
        int MAX_STELLEN = 5;
        String FUELL_ZEICHEN = "0";
        String str = String.valueOf(nr);
        while (str.length() < 5) {
            str = "0" + str;
        }
        return str;
    }

    private static void addText(StringBuffer text, String texte) {
        Log.cut(text);
        text.append(texte);
        text.append(System.getProperty("line.separator"));
    }

    private static void cut(StringBuffer buffer) {
        if (buffer.length() > 50000) {
            buffer.delete(0, 30000);
        }
    }
}

