/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.io.MediathekReader;

public class GuiEinstellungenSender
extends PanelVorlage {
    private BeobCheckboxSender[] beobCheck;
    private JCheckBox jCheckBoxRtmp;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel6;
    private JSpinner jSpinnerDownload;
    private JSpinner jSpinnerWarten;
    private JPanel panelSender;

    public GuiEinstellungenSender(Daten d) {
        super(d);
        this.initComponents();
        this.daten = d;
        this.beobCheck = new BeobCheckboxSender[this.daten.mediathekListe.size()];
        for (int i = 0; i < this.daten.mediathekListe.size(); ++i) {
            this.beobCheck[i] = new BeobCheckboxSender(i);
        }
        this.init();
        this.jSpinnerDownload.addChangeListener(new BeobSpinnerDownload());
        this.jCheckBoxRtmp.addActionListener(new BeobRtmp());
        this.jSpinnerWarten.addChangeListener(new BeobSpinnerWarten());
    }

    @Override
    public void neuLaden() {
        this.init();
    }

    private void init() {
        if (this.daten.system[42].equals("")) {
            this.jSpinnerWarten.setValue(1);
            this.daten.system[42] = "1";
        } else {
            this.jSpinnerWarten.setValue(Integer.parseInt(this.daten.system[42]));
        }
        if (this.daten.system[17].equals("")) {
            this.jSpinnerDownload.setValue(1);
            this.daten.system[17] = "1";
        } else {
            this.jSpinnerDownload.setValue(Integer.parseInt(this.daten.system[17]));
        }
        this.jCheckBoxRtmp.setSelected(Boolean.parseBoolean(this.daten.system[20]));
        this.addSender();
    }

    private void addSender() {
        this.panelSender.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        this.panelSender.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        Iterator it = this.daten.mediathekListe.iterator();
        int nr = 0;
        int y = 0;
        while (it.hasNext()) {
            c.gridx = 0;
            c.gridy = y;
            MediathekReader reader = (MediathekReader)it.next();
            this.addPanel(gridbag, c, reader, nr);
            ++nr;
            if (it.hasNext()) {
                c.gridx = 2;
                reader = (MediathekReader)it.next();
                this.addPanel(gridbag, c, reader, nr);
                ++nr;
            }
            ++y;
        }
        JLabel label = new JLabel();
        c.gridx = 4;
        c.weightx = 2.0;
        gridbag.setConstraints(label, c);
        this.panelSender.add(label);
        this.panelSender.updateUI();
    }

    private void addPanel(GridBagLayout gridbag, GridBagConstraints c, MediathekReader reader, int nr) {
        JCheckBox box = new JCheckBox(reader.text);
        box.setSelected(reader.senderOn);
        box.addActionListener(this.beobCheck[nr]);
        c.insets = new Insets(2, 10, 2, 2);
        gridbag.setConstraints(box, c);
        this.panelSender.add(box);
        ++c.gridx;
        if (reader.panelEinstellungen != null) {
            JButton button = new JButton("Einst.");
            button.addActionListener(new BeobEinstellungenSender(nr));
            c.insets = new Insets(2, 10, 2, 20);
            gridbag.setConstraints(button, c);
            this.panelSender.add(button);
        }
    }

    private void initComponents() {
        this.panelSender = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinnerDownload = new JSpinner();
        this.jPanel1 = new JPanel();
        this.jCheckBoxRtmp = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jSpinnerWarten = new JSpinner();
        this.jLabel7 = new JLabel();
        this.panelSender.setBorder(BorderFactory.createTitledBorder("Sender laden"));
        GroupLayout panelSenderLayout = new GroupLayout(this.panelSender);
        this.panelSender.setLayout(panelSenderLayout);
        panelSenderLayout.setHorizontalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 674, Short.MAX_VALUE));
        panelSenderLayout.setVerticalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel3.setText("max. parallele Downloads beim Laden der Abos ( empf: 2 ):");
        this.jSpinnerDownload.setModel(new SpinnerNumberModel(2, 1, 9, 1));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerDownload, -2, -1, -2).addContainerGap(209, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jSpinnerDownload, -2, -1, -2)).addContainerGap(6, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Flash-Filme"));
        this.jCheckBoxRtmp.setText("RTMP-Protokoll: Url f\u00fcr flvstreamer vorbereiten");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxRtmp).addContainerGap(309, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxRtmp).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel6.setText("Das Laden der Filmliste um den Faktor ");
        this.jSpinnerWarten.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jLabel7.setText("bremsen");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerWarten, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(268, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jSpinnerWarten, -2, -1, -2).addComponent(this.jLabel7)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.panelSender, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel6, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(190, Short.MAX_VALUE)));
    }

    private class BeobSpinnerWarten
    implements ChangeListener {
        private BeobSpinnerWarten() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            GuiEinstellungenSender.this.daten.system[42] = String.valueOf(((Number)GuiEinstellungenSender.this.jSpinnerWarten.getModel().getValue()).intValue());
            GuiEinstellungenSender.this.daten.setGeaendertOhnePanel();
        }
    }

    private class BeobRtmp
    implements ActionListener {
        private BeobRtmp() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungenSender.this.daten.system[20] = Boolean.toString(GuiEinstellungenSender.this.jCheckBoxRtmp.isSelected());
            GuiEinstellungenSender.this.daten.listeFilme.rtmpAendern();
            GuiEinstellungenSender.this.daten.setGeaendert();
        }
    }

    private class BeobEinstellungenSender
    implements ActionListener {
        private int nr;

        public BeobEinstellungenSender(int nnr) {
            this.nr = nnr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediathekReader reader = GuiEinstellungenSender.this.daten.mediathekListe.get(this.nr);
            if (reader.panelEinstellungen != null) {
                reader.panelEinstellungen.setVisible(true);
            }
        }
    }

    private class BeobCheckboxSender
    implements ActionListener {
        private int nr;

        public BeobCheckboxSender(int nnr) {
            this.nr = nnr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungenSender.this.daten.mediathekListe.get((int)this.nr).senderOn = ((JCheckBox)e.getSource()).isSelected();
            GuiEinstellungenSender.this.daten.setGeaendert();
        }
    }

    private class BeobSpinnerDownload
    implements ChangeListener {
        private BeobSpinnerDownload() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            GuiEinstellungenSender.this.daten.system[17] = String.valueOf(((Number)GuiEinstellungenSender.this.jSpinnerDownload.getModel().getValue()).intValue());
            GuiEinstellungenSender.this.daten.setGeaendertOhnePanel();
        }
    }
}

