/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.gui.GuiAbo;
import mediathek.gui.GuiDebug;
import mediathek.gui.GuiEinstellungen;
import mediathek.gui.GuiEinstellungenNetz;
import mediathek.gui.GuiEinstellungenSender;
import mediathek.gui.GuiFilme;
import mediathek.gui.GuiInfo;
import mediathek.gui.GuiPodder;
import mediathek.gui.GuiUpdate;
import mediathek.gui.OSXAdapter;
import mediathek.io.UpdateSuchen;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;

public class GuiMediathek
extends JFrame {
    private Daten daten;
    private GuiFilme guiFilme;
    private GuiDebug guiDebug;
    private GuiAbo guiAbo;
    private GuiPodder guiPodder;
    private GuiEinstellungen guiEinstellungen;
    private GuiUpdate guiUpdate;
    private GuiEinstellungenSender guiEinstellungenSender;
    private GuiEinstellungenNetz guiEinstellungenNetz;
    private GuiInfo guiInfo;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private boolean debug = false;
    private JButton jButtonStop;
    private JButton jButtonStopNachFilm;
    private JLabel jLabel2;
    private JLabel jLabelDownload;
    private JProgressBar jProgressBar1;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldDownloads;
    private JPanel statusPanel;

    public GuiMediathek(String[] ar) {
        String pfad = "";
        boolean max = false;
        this.initComponents();
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-D")) {
                    this.debug = true;
                }
                if (!ar[i].equals("-M")) continue;
                max = true;
            }
        }
        this.setStatusPanel(false);
        this.jProgressBar1.setForeground(new Color(102, 153, 255));
        this.daten = new Daten(pfad, this.debug, this, false);
        this.titelSetzen();
        Funktionen.setLook(this.daten, this);
        this.initTabs();
        this.initListener();
        this.setSize(max);
        if (this.debug && this.daten.dialogFehler != null) {
            this.daten.dialogFehler.setVisible(true);
        }
        this.registerForMacOSXEvents();
        this.checkUpdate();
    }

    public void setSize(boolean max) {
        this.pack();
        if (max || Boolean.parseBoolean(this.daten.system[2])) {
            this.setExtendedState(6);
        } else {
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(this.daten.system[5]);
                y = Integer.parseInt(this.daten.system[6]);
            }
            catch (Exception ex) {
                x = 0;
                y = 0;
            }
            if (x > 0 && y > 0) {
                this.setSize(new Dimension(x, y));
            }
        }
    }

    public void setTabs() {
        this.jTabbedPane.removeAll();
        this.jTabbedPane.addTab("Filme", this.guiFilme);
        if (this.daten.system[7].equals(Boolean.toString(true))) {
            this.jTabbedPane.addTab("Abonnements", this.guiAbo);
        }
        if (this.daten.system[10].equals(Boolean.toString(true))) {
            this.jTabbedPane.addTab("Podcasts", this.guiPodder);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.jTabbedPane.addTab("Einstellungen", panel);
        JTabbedPane pane = new JTabbedPane();
        panel.add((Component)pane, "Center");
        pane.addTab("Einstellungen", this.guiEinstellungen);
        pane.addTab("Einstellungen Sender", this.guiEinstellungenSender);
        pane.addTab("Update", this.guiUpdate);
        pane.addTab("Netzwerk", this.guiEinstellungenNetz);
        pane.addTab("Infos", this.guiInfo);
        Color farbe = Color.WHITE;
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setForeground(farbe);
        this.guiEinstellungen.setBorder(new LineBorder(farbe, 2, true));
        this.guiEinstellungen.setForeground(farbe);
        this.guiEinstellungenNetz.setBorder(new LineBorder(farbe, 2, true));
        this.guiEinstellungenNetz.setForeground(farbe);
        this.guiUpdate.setBorder(new LineBorder(farbe, 2, true));
        this.guiUpdate.setForeground(farbe);
        this.guiInfo.setBorder(new LineBorder(farbe, 2, true));
        this.guiInfo.setForeground(farbe);
        this.guiEinstellungenSender.setBorder(new LineBorder(farbe, 2, true));
        this.guiEinstellungenSender.setForeground(farbe);
        if (this.debug) {
            this.jTabbedPane.addTab("Debug", this.guiDebug);
        }
        this.pack();
    }

    private void checkUpdate() {
        if (this.daten.system[44].equals("")) {
            int answer = JOptionPane.showConfirmDialog(null, "Online nach neuen Programmversionen suchen?", "Update suchen", 0);
            this.daten.system[44] = answer == 0 ? Boolean.toString(true) : Boolean.toString(false);
            this.daten.setGeaendert();
        }
        if (Boolean.parseBoolean(this.daten.system[44])) {
            if (Boolean.parseBoolean(this.daten.system[45])) {
                if (!this.daten.system[46].equals(Funktionen.getHeute())) {
                    new UpdateSuchen(this.daten).suchen(true, Boolean.parseBoolean(this.daten.system[47]));
                }
            } else {
                int tage = 99;
                try {
                    Date today = new Date(System.currentTimeMillis());
                    String date = this.daten.system[46];
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Date d = sdf.parse(date);
                    tage = Math.round((today.getTime() - d.getTime()) / 86400000L);
                }
                catch (ParseException ex) {
                    System.out.println("Fehler diff in Tagen");
                }
                if (tage >= 7) {
                    new UpdateSuchen(this.daten).suchen(true, Boolean.parseBoolean(this.daten.system[47]));
                }
            }
        }
    }

    private void titelSetzen() {
        if (this.daten.debug) {
            this.setTitle("Mediathek 2.2.1  ** DEBUG **       [ " + this.daten.getBasisVerzeichnis() + " ]     Seiten: " + this.daten.seitenZaehler);
        } else {
            this.setTitle("Mediathek 2.2.1");
        }
    }

    private void initListener() {
        this.daten.starterClass.addListener(new BeobachterStart());
        this.jButtonStop.addActionListener(new AlleAbbrechen());
        this.jButtonStopNachFilm.addActionListener(new AlleAbbrechenNachFilm());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GuiMediathek.this.beenden();
            }
        });
    }

    private void initTabs() {
        this.guiFilme = new GuiFilme(this.daten);
        this.guiAbo = new GuiAbo(this.daten);
        this.guiPodder = new GuiPodder(this.daten);
        this.guiEinstellungen = new GuiEinstellungen(this.daten);
        this.guiUpdate = new GuiUpdate(this.daten);
        this.guiEinstellungenSender = new GuiEinstellungenSender(this.daten);
        this.guiEinstellungenNetz = new GuiEinstellungenNetz(this.daten);
        this.guiInfo = new GuiInfo(this.daten);
        this.guiDebug = new GuiDebug(this.daten);
        this.setTabs();
    }

    private void setProgressBar(StartEvent ev) {
        this.titelSetzen();
        if (ev.nixTun()) {
            this.setStatusPanel(false);
            this.jLabelDownload.setText("Downloads:");
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setStringPainted(false);
        } else {
            this.setStatusPanel(true);
            this.jLabelDownload.setText("Downloads (" + ev.getMax() + "):");
            this.jProgressBar1.setMaximum(ev.getMax());
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(ev.getProgress());
            this.jProgressBar1.setStringPainted(true);
        }
        if (ev.getDown() == 0) {
            this.jTextFieldDownloads.setText(String.valueOf(""));
            this.jTextFieldDownloads.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        } else {
            this.jTextFieldDownloads.setText(String.valueOf(ev.getDown()));
            this.jTextFieldDownloads.setBackground(Konstanten.DOWNLOAD_FARBE_RUN);
        }
        this.statusPanel.repaint();
    }

    private void setStatusPanel(boolean bool) {
        for (int i = 0; i < this.statusPanel.getComponentCount(); ++i) {
            this.statusPanel.getComponent(i).setVisible(bool);
        }
    }

    private void beenden() {
        this.daten.allesAbbrechen();
        String x = String.valueOf(this.getSize().width);
        String y = String.valueOf(this.getSize().height);
        if (!x.equals(this.daten.system[5]) || !y.equals(this.daten.system[6])) {
            this.daten.system[5] = x;
            this.daten.system[6] = y;
            this.daten.setGeaendertOhnePanel();
        }
        if (this.daten.isGeaendert()) {
            this.daten.speichern();
        }
    }

    private void alleDownloadsAbbrechen() {
        this.daten.allesAbbrechen();
    }

    private void alleDownloadsAbbrechenNachFilm() {
        this.daten.allesAbbrechenNachFilm();
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jTextFieldDownloads = new JTextField();
        this.jLabelDownload = new JLabel();
        this.jButtonStop = new JButton();
        this.jButtonStopNachFilm = new JButton();
        this.jTabbedPane = new JTabbedPane();
        this.setDefaultCloseOperation(3);
        this.statusPanel.setBorder(new SoftBevelBorder(0));
        this.jLabel2.setText("laufende Downloads:");
        this.jTextFieldDownloads.setEditable(false);
        this.jTextFieldDownloads.setHorizontalAlignment(0);
        this.jLabelDownload.setText("Downloads:");
        this.jButtonStop.setText("sofort stoppen");
        this.jButtonStop.setToolTipText("Downloads sofort abbrechen");
        this.jButtonStopNachFilm.setText("nach Film stoppen");
        this.jButtonStopNachFilm.setToolTipText("Downloads nach dem Film abbrechen");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelDownload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -1, 330, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStopNachFilm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(6, 6, 6).addComponent(this.jTextFieldDownloads, -2, 38, -2).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelDownload).addComponent(this.jProgressBar1, -2, 23, -2).addComponent(this.jButtonStop, -2, 19, -2).addComponent(this.jLabel2).addComponent(this.jTextFieldDownloads, -2, -1, -2).addComponent(this.jButtonStopNachFilm, -2, 19, -2)));
        statusPanelLayout.linkSize(1, this.jButtonStop, this.jButtonStopNachFilm, this.jProgressBar1, this.jTextFieldDownloads);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jTabbedPane, -1, 954, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 359, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPanel, -2, -1, -2)));
        this.pack();
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quitForMac", null));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public void quitForMac() {
        this.beenden();
    }

    private class BeobachterStart
    implements StartListener {
        private BeobachterStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            GuiMediathek.this.setProgressBar(ev);
        }
    }

    private class AlleAbbrechenNachFilm
    implements ActionListener {
        private AlleAbbrechenNachFilm() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.alleDownloadsAbbrechenNachFilm();
        }
    }

    private class AlleAbbrechen
    implements ActionListener {
        private AlleAbbrechen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.alleDownloadsAbbrechen();
        }
    }
}

