/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;

public class DialogEditAbo
extends JDialog {
    private Daten daten;
    private DatenAbo aktAbo;
    private JTextField[] textfeldListe;
    private JComboBox comboboxProgramm = new JComboBox();
    private JComboBox comboboxSender = new JComboBox();
    private JCheckBox checkBoxExakt = new JCheckBox();
    public boolean ok = false;
    private JButton jButtonAbbrechen;
    private JButton jButtonBeenden;
    private JPanel jPanel1;
    private JPanel jPanelExtra;

    public DialogEditAbo(Frame parent, boolean modal, Daten d, DatenAbo aktA) {
        super(parent, modal);
        this.initComponents();
        this.daten = d;
        this.aktAbo = aktA;
        this.comboboxProgramm.setModel(new DefaultComboBoxModel<String>(this.daten.listePgruppeAbo.getObjectDataCombo()));
        this.comboboxSender.setModel(new DefaultComboBoxModel<String>(Funktionen.addLeerListe(Konstanten.SENDER_LISTE)));
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditAbo.this.check();
                DialogEditAbo.this.beenden();
            }
        });
        this.jButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditAbo.this.beenden();
            }
        });
        this.setExtra();
        this.pack();
    }

    private void setExtra() {
        this.textfeldListe = new JTextField[9];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < 9; ++i) {
            this.addExtraFeld(i, gridbag, c, this.jPanelExtra, this.aktAbo.arr);
            c.gridy = ++zeile;
        }
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c, JPanel panel, String[] item) {
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel label = new JLabel(Konstanten.ABO_COLUMN_NAMES[i] + ": ");
        if (i == 5 || i == 3 || i == 4 || i == 2) {
            label = new JLabel("  " + Konstanten.ABO_COLUMN_NAMES[i] + ": ");
            label.setForeground(Color.BLUE);
        } else {
            label = new JLabel(Konstanten.ABO_COLUMN_NAMES[i] + ": ");
        }
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridx = 1;
        c.weightx = 10.0;
        if (i == 8) {
            this.comboboxProgramm.setSelectedItem(item[i]);
            this.aktAbo.arr[8] = (String)this.comboboxProgramm.getSelectedItem();
            this.comboboxProgramm.addActionListener(new BeobComboProgramm());
            gridbag.setConstraints(this.comboboxProgramm, c);
            panel.add(this.comboboxProgramm);
        } else if (i == 2) {
            this.comboboxSender.setSelectedItem(item[i]);
            this.aktAbo.arr[2] = (String)this.comboboxSender.getSelectedItem();
            this.comboboxSender.addActionListener(new BeobComboSender());
            gridbag.setConstraints(this.comboboxSender, c);
            panel.add(this.comboboxSender);
        } else if (i == 4) {
            this.checkBoxExakt.setSelected(Boolean.parseBoolean(item[i]));
            this.checkBoxExakt.addActionListener(new BeobExakt());
            gridbag.setConstraints(this.checkBoxExakt, c);
            panel.add(this.checkBoxExakt);
        } else {
            JTextField textfeld;
            this.textfeldListe[i] = textfeld = new JTextField();
            if (i == 0 || i == 7) {
                textfeld.setEditable(false);
            }
            textfeld.setText(item[i]);
            textfeld.getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
            gridbag.setConstraints(textfeld, c);
            panel.add(textfeld);
        }
    }

    private void check() {
        this.aktAbo.arr[6] = Funktionen.replaceLeerDateiname(this.aktAbo.arr[6], false);
        this.ok = true;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanelExtra = new JPanel();
        this.jButtonBeenden = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 0));
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.jPanelExtra.setBorder(new SoftBevelBorder(1));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 541, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 249, Short.MAX_VALUE));
        this.jButtonBeenden.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonBeenden, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen)).addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAbbrechen, this.jButtonBeenden);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBeenden).addComponent(this.jButtonAbbrechen)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private class BeobExakt
    implements ActionListener {
        private BeobExakt() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditAbo.this.daten.setGeaendert();
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[4] = Boolean.toString(DialogEditAbo.this.checkBoxExakt.isSelected());
        }
    }

    private class BeobComboSender
    implements ActionListener {
        private BeobComboSender() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditAbo.this.daten.setGeaendert();
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[2] = (String)DialogEditAbo.this.comboboxSender.getSelectedItem();
        }
    }

    private class BeobComboProgramm
    implements ActionListener {
        private BeobComboProgramm() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogEditAbo.this.daten.setGeaendert();
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[8] = (String)DialogEditAbo.this.comboboxProgramm.getSelectedItem();
        }
    }

    private class BeobachterDocumentTextfeld
    implements DocumentListener {
        int nr;

        public BeobachterDocumentTextfeld(int n) {
            this.nr = n;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            DialogEditAbo.this.daten.setGeaendert();
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[this.nr] = DialogEditAbo.this.textfeldListe[this.nr].getText().trim();
        }
    }
}

