/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import mediathek.Fehler;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPod;
import mediathek.daten.ListeFilme;
import mediathek.io.FilmListener;

public class FeedReaderPods {
    private Daten daten;
    private boolean stop;
    private EventListenerList listeners = new EventListenerList();
    private ListeFilme liste;
    private int threads = 0;
    private Iterator<DatenPod> itPod;

    public FeedReaderPods(Daten d) {
        this.daten = d;
        this.liste = new ListeFilme(this.daten);
        this.listeners = new EventListenerList();
    }

    public boolean starten() {
        boolean ret = this.daten.listePod.size() > 0;
        this.threads = 0;
        this.stop = false;
        this.liste.clear();
        this.notifyStart(this.daten.listePod.size());
        new Thread(new Laden()).start();
        return ret;
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    public void stoppen() {
        this.stop = true;
    }

    public ListeFilme getListe() {
        return this.liste;
    }

    private synchronized DatenPod getPod() {
        if (this.itPod.hasNext()) {
            return this.itPod.next();
        }
        return null;
    }

    private synchronized void addListe(DatenFilm film) {
        this.liste.add(film);
    }

    private void downloadPods(DatenPod pod, String podcast, String strUrl, ListeFilme liste, String zielPfad) {
        try {
            URL feedUrl = new URL(strUrl);
            URLConnection conn = feedUrl.openConnection();
            conn.setRequestProperty("User-Agent", this.daten.system[3]);
            conn.setReadTimeout(2000);
            XmlReader xmlReader = new XmlReader(conn.getInputStream());
            SyndFeed feed = new SyndFeedInput().build(xmlReader);
            Iterator entryIter = feed.getEntries().iterator();
            while (!this.stop && entryIter.hasNext()) {
                SyndEntry entry = (SyndEntry)entryIter.next();
                Iterator it = entry.getEnclosures().iterator();
                while (!this.stop && it.hasNext()) {
                    SyndEnclosure sEnc = (SyndEnclosure)it.next();
                    if (!this.daten.system[11].endsWith(File.separator)) {
                        this.daten.system[11] = this.daten.system[11] + File.separator;
                    }
                    if (zielPfad.startsWith(File.separator)) {
                        zielPfad = zielPfad.substring(1);
                    }
                    if (!zielPfad.endsWith(File.separator)) {
                        zielPfad = zielPfad + File.separator;
                    }
                    zielPfad = this.daten.system[11] + zielPfad;
                    String url = sEnc.getUrl();
                    if (this.daten.log.zeilePruefen(url, ".mediathek_podder_log") || this.listeContainUrl(liste, url)) continue;
                    DatenFilm film = new DatenFilm(this.daten, "Podcast", podcast, entry.getTitle(), url, zielPfad);
                    liste.add(film);
                    pod.arr[4] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                    this.daten.setGeaendert();
                }
            }
        }
        catch (Exception e) {
            String[] str = new String[]{e.getMessage(), "Podcast:  " + podcast, "Url:      " + strUrl};
            new Fehler(this.daten).fehlerMeldung("Fehler!", str);
        }
    }

    private boolean listeContainUrl(ListeFilme liste, String str) {
        boolean ret = false;
        ListIterator it = liste.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenFilm)it.next()).arr[4].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void notifyStart(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(max);
        }
    }

    private void notifyProgress(String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(text);
        }
    }

    private void notifyFertig() {
        if (this.threads <= 0) {
            if (this.stop) {
                this.daten.listeFilme.clear();
            }
            for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
                l.fertig(this.stop);
            }
        }
    }

    private class Starten
    implements Runnable {
        private Starten() {
        }

        @Override
        public synchronized void run() {
            DatenPod pod;
            ListeFilme list = new ListeFilme(FeedReaderPods.this.daten);
            while (!FeedReaderPods.this.stop && (pod = FeedReaderPods.this.getPod()) != null) {
                FeedReaderPods.this.downloadPods(pod, pod.arr[1], pod.arr[2], list, pod.arr[3]);
                FeedReaderPods.this.notifyProgress(pod.arr[2]);
            }
            Iterator itPod = list.iterator();
            while (itPod.hasNext()) {
                FeedReaderPods.this.addListe((DatenFilm)itPod.next());
            }
            --FeedReaderPods.this.threads;
        }
    }

    private class Laden
    implements Runnable {
        private Laden() {
        }

        @Override
        public synchronized void run() {
            FeedReaderPods.this.itPod = ((FeedReaderPods)FeedReaderPods.this).daten.listePod.iterator();
            for (int t = 0; t < 5; ++t) {
                ++FeedReaderPods.this.threads;
                new Thread(new Starten()).start();
            }
            while (FeedReaderPods.this.threads > 0) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (FeedReaderPods.this.stop) {
                FeedReaderPods.this.liste.clear();
            }
            FeedReaderPods.this.notifyFertig();
        }
    }
}

