/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.ListeFilmUpdate;
import mediathek.gui.dialoge.DialogHinweis;

public class UpdateSuchen {
    Daten daten;
    private ListeFilmUpdate listeFilme = new ListeFilmUpdate();

    public UpdateSuchen(Daten ddaten) {
        this.daten = ddaten;
    }

    public void suchen(boolean progUpdate, boolean filmUpdate) {
        String version = "";
        String release = "";
        String updateUrl = "";
        String filmUrl = "";
        String parsername = "";
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader inReader = null;
            String user_agent = this.daten.system[3];
            int timeout = 10000;
            URLConnection conn = null;
            conn = new URL("http://zdfmediathk.sourceforge.net/update.xml").openConnection();
            conn.setRequestProperty("User-Agent", user_agent);
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
            parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                parsername = parser.getLocalName();
                if (parser.getLocalName().equals("Program_Version")) {
                    version = parser.getElementText();
                    continue;
                }
                if (parser.getLocalName().equals("Program_Release_Info")) {
                    release = parser.getElementText();
                    continue;
                }
                if (parser.getLocalName().equals("Download_Programm")) {
                    updateUrl = parser.getElementText();
                    continue;
                }
                if (parser.getLocalName().equals("Download_Filme_1")) {
                    filmUrl = parser.getElementText();
                    if (filmUrl.equals("")) continue;
                    this.listeFilme.add(new DatenFilmUpdate(filmUrl, "1"));
                    continue;
                }
                if (!parser.getLocalName().equals("Download_Filme_2") || (filmUrl = parser.getElementText()).equals("")) continue;
                this.listeFilme.add(new DatenFilmUpdate(filmUrl, "2"));
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "MediathekGuiUpdate: XMLParser");
        }
        if (filmUpdate) {
            if (this.listeFilme.isEmpty()) {
                new DialogHinweis(null, true, this.daten, "Es ist ein Fehler aufgetreten!\n\nEs konnten keine Updateserver zum aktualisieren der Filme\ngefunden werden.\n\n", "http://zdfmediathk.sourceforge.net/update.html", "Online nach neuen Programmversionen suchen?", 44, "Update suchen").setVisible(true);
            } else {
                this.daten.listeFilmUpdate = this.listeFilme;
                this.daten.system[35] = this.daten.listeFilmUpdate.getRand();
                this.daten.setGeaendertOhnePanel();
            }
        }
        if (progUpdate) {
            if (!version.equals("")) {
                this.daten.system[46] = Funktionen.getHeute();
                if (!version.equals("2.2.1")) {
                    new DialogHinweis(null, false, this.daten, "   ==================================================\n   Neue Version:\n   " + version + "\n\n" + "   ==================================================\n" + "   \u00c4nderungen:\n" + "   " + release + "\n\n" + "   ==================================================\n" + "   URL:\n" + "   " + updateUrl + "\n\n", updateUrl, "Online nach neuen Programmversionen suchen?", 44, "Eine neue Version liegt vor").setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Alles aktuell!", "Update suchen", 1);
                }
            } else {
                new DialogHinweis(null, true, this.daten, "Es ist ein Fehler aufgetreten!\n\n", "http://sourceforge.net/projects/zdfmediathk/", "Online nach neuen Programmversionen suchen?", 44, "Update suchen").setVisible(true);
            }
        }
    }

    public String[] getModel() {
        return this.listeFilme.getObjectData();
    }
}

