/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.beobachter.BeobWeb;
import mediathek.daten.Daten;
import mediathek.gui.GuiAbo;
import mediathek.gui.GuiDebug;
import mediathek.gui.GuiEinstellungen;
import mediathek.gui.GuiEinstellungenNetz;
import mediathek.gui.GuiEinstellungenSender;
import mediathek.gui.GuiFilme;
import mediathek.gui.GuiInfo;
import mediathek.gui.GuiInfoLaden;
import mediathek.gui.GuiPodder;
import mediathek.gui.GuiUpdate;
import mediathek.gui.OSXAdapter;
import mediathek.gui.dialoge.DialogExportFilme;
import mediathek.gui.dialoge.DialogImportFilme;
import mediathek.gui.dialoge.DialogOpenPanel;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.io.UpdateSuchen;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;

public class GuiMediathek
extends JFrame {
    private Daten daten;
    private GuiFilme guiFilme;
    private GuiDebug guiDebug;
    private GuiAbo guiAbo;
    private GuiPodder guiPodder;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private boolean debug = false;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private JButton jButtonStop;
    private JButton jButtonStopNachFilm;
    private JCheckBoxMenuItem jCheckBoxMenuItemPlayer;
    private JLabel jLabel2;
    private JLabel jLabelDownload;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItemAbo;
    private JMenuItem jMenuItemAktivitaet;
    private JMenuItem jMenuItemAnleitung;
    private JMenuItem jMenuItemButtonEinrichten;
    private JMenuItem jMenuItemEinstellungen;
    private JMenuItem jMenuItemEinstellungenNetz;
    private JMenuItem jMenuItemEinstellungenSender;
    private JMenuItem jMenuItemExport;
    private JMenuItem jMenuItemFehler;
    private JMenuItem jMenuItemImport;
    private JMenuItem jMenuItemInfos;
    private JMenuItem jMenuItemLaden;
    private JMenuItem jMenuItemPodcast;
    private JMenuItem jMenuItemUpdate;
    private JPanel jPanelExtra;
    private JProgressBar jProgressBar1;
    private JTextField jTextFieldDownloads;
    private JPanel statusPanel;

    public GuiMediathek(String[] ar) {
        String pfad = "";
        boolean max = false;
        this.initComponents();
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-D")) {
                    this.debug = true;
                }
                if (!ar[i].equals("-M")) continue;
                max = true;
            }
        }
        this.jPanelExtra.setLayout(new BorderLayout());
        this.setStatusPanel(false);
        this.jProgressBar1.setForeground(new Color(102, 153, 255));
        this.daten = new Daten(pfad, this.debug, this, false);
        this.titelSetzen();
        Funktionen.setLook(this.daten, this);
        this.initTabs();
        this.initListener();
        this.setSize(max);
        if (this.debug && this.daten.dialogFehler != null) {
            this.daten.dialogFehler.setVisible(true);
        }
        this.registerForMacOSXEvents();
        this.checkUpdate();
    }

    public void setSize(boolean max) {
        this.pack();
        if (max || Boolean.parseBoolean(this.daten.system[2])) {
            this.setExtendedState(6);
        } else {
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(this.daten.system[5]);
                y = Integer.parseInt(this.daten.system[6]);
            }
            catch (Exception ex) {
                x = 0;
                y = 0;
            }
            if (x > 0 && y > 0) {
                this.setSize(new Dimension(x, y));
            }
        }
    }

    public void setTabs() {
        this.jTabbedPane.removeAll();
        this.jPanelExtra.removeAll();
        if (!(this.daten.system[7].equals(Boolean.toString(true)) || this.daten.system[10].equals(Boolean.toString(true)) || this.debug)) {
            this.jPanelExtra.add((Component)this.guiFilme, "Center");
        } else {
            this.jPanelExtra.add((Component)this.jTabbedPane, "Center");
            this.jTabbedPane.addTab("Filme", this.guiFilme);
            if (this.daten.system[7].equals(Boolean.toString(true))) {
                this.jTabbedPane.addTab("Abonnements", this.guiAbo);
            }
            if (this.daten.system[10].equals(Boolean.toString(true))) {
                this.jTabbedPane.addTab("Podcasts", this.guiPodder);
            }
            if (this.debug) {
                this.jTabbedPane.addTab("Debug", this.guiDebug);
            }
        }
        this.pack();
    }

    private void checkUpdate() {
        if (this.daten.system[45].equals("")) {
            int answer = JOptionPane.showConfirmDialog(null, "Online nach neuen Programmversionen suchen?", "Update suchen", 0);
            this.daten.system[45] = answer == 0 ? Boolean.toString(true) : Boolean.toString(false);
            this.daten.setGeaendert();
        }
        if (Boolean.parseBoolean(this.daten.system[45])) {
            if (Boolean.parseBoolean(this.daten.system[46])) {
                if (!this.daten.system[47].equals(Funktionen.getHeute_yyyyMMdd())) {
                    new UpdateSuchen(this.daten).suchen(true, Boolean.parseBoolean(this.daten.system[48]));
                }
            } else {
                int tage = 99;
                try {
                    Date today = new Date(System.currentTimeMillis());
                    String date = this.daten.system[47];
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Date d = sdf.parse(date);
                    tage = Math.round((today.getTime() - d.getTime()) / 86400000L);
                }
                catch (ParseException ex) {
                    System.out.println("Fehler diff in Tagen");
                }
                if (tage >= 7) {
                    new UpdateSuchen(this.daten).suchen(true, Boolean.parseBoolean(this.daten.system[48]));
                }
            }
        }
    }

    private void titelSetzen() {
        if (this.daten.debug) {
            this.setTitle("Mediathek 2.3.0  ** DEBUG **       [ " + this.daten.getBasisVerzeichnis() + " ]     Seiten: " + this.daten.seitenZaehler);
        } else {
            this.setTitle("Mediathek 2.3.0");
        }
    }

    private void initListener() {
        this.jMenuItemEinstellungen.addActionListener(new DialogOpenPanel(null, true, "Einstellungen", new GuiEinstellungen(this.daten)));
        this.jMenuItemEinstellungenNetz.addActionListener(new DialogOpenPanel(null, true, "Netzwerk", new GuiEinstellungenNetz(this.daten)));
        this.jMenuItemEinstellungenSender.addActionListener(new DialogOpenPanel(null, true, "Einstellungen Sender", new GuiEinstellungenSender(this.daten)));
        this.jMenuItemUpdate.addActionListener(new DialogOpenPanel(null, false, "Update", new GuiUpdate(this.daten)));
        this.jMenuItemInfos.addActionListener(new DialogOpenPanel(null, false, "Programminfos", new GuiInfo(this.daten)));
        this.jCheckBoxMenuItemPlayer.addActionListener(new BeobPlayer());
        this.jMenuItemButtonEinrichten.addActionListener(new BeobPgruppen());
        this.jMenuItemExport.addActionListener(new BeobExport());
        this.jMenuItemLaden.addActionListener(new BeobLaden());
        this.jMenuItemImport.addActionListener(new BeobImport());
        this.jMenuItemAnleitung.addActionListener(new BeobWeb());
        this.jMenuItemAktivitaet.addActionListener(new DialogOpenPanel(null, false, "Aktivit\u00e4t", new GuiInfoLaden(this.daten)));
        this.jMenuItemFehler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((GuiMediathek)GuiMediathek.this).daten.dialogFehler != null) {
                    ((GuiMediathek)GuiMediathek.this).daten.dialogFehler.setVisible(true);
                }
            }
        });
        this.jMenuItemPodcast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GuiMediathek)GuiMediathek.this).daten.guiPodder.basisziel();
            }
        });
        this.jMenuItemAbo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GuiMediathek)GuiMediathek.this).daten.guiAbo.einstellungen();
            }
        });
        this.daten.starterClass.addListener(new BeobachterStart());
        this.jButtonStop.addActionListener(new AlleAbbrechen());
        this.jButtonStopNachFilm.addActionListener(new AlleAbbrechenNachFilm());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GuiMediathek.this.beenden();
            }
        });
    }

    private void initTabs() {
        this.guiFilme = new GuiFilme(this.daten);
        this.guiAbo = new GuiAbo(this.daten);
        this.guiPodder = new GuiPodder(this.daten);
        this.guiDebug = new GuiDebug(this.daten);
        this.setTabs();
    }

    private void setProgressBar(StartEvent ev) {
        this.titelSetzen();
        if (ev.nixTun()) {
            this.setStatusPanel(false);
            this.jLabelDownload.setText("Downloads:");
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setStringPainted(false);
        } else {
            this.setStatusPanel(true);
            this.jLabelDownload.setText("Downloads (" + ev.getMax() + "):");
            this.jProgressBar1.setMaximum(ev.getMax());
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(ev.getProgress());
            this.jProgressBar1.setStringPainted(true);
        }
        if (ev.getDown() == 0) {
            this.jTextFieldDownloads.setText(String.valueOf(""));
            this.jTextFieldDownloads.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        } else {
            this.jTextFieldDownloads.setText(String.valueOf(ev.getDown()));
            this.jTextFieldDownloads.setBackground(Konstanten.DOWNLOAD_FARBE_RUN);
        }
        this.statusPanel.repaint();
    }

    private void setStatusPanel(boolean bool) {
        for (int i = 0; i < this.statusPanel.getComponentCount(); ++i) {
            this.statusPanel.getComponent(i).setVisible(bool);
        }
    }

    private void beenden() {
        this.daten.allesAbbrechen();
        String x = String.valueOf(this.getSize().width);
        String y = String.valueOf(this.getSize().height);
        if (!x.equals(this.daten.system[5]) || !y.equals(this.daten.system[6])) {
            this.daten.system[5] = x;
            this.daten.system[6] = y;
            this.daten.setGeaendertOhnePanel();
        }
        if (this.daten.isGeaendert()) {
            this.daten.speichern();
        }
    }

    private void alleDownloadsAbbrechen() {
        this.daten.allesAbbrechen();
    }

    private void alleDownloadsAbbrechenNachFilm() {
        this.daten.allesAbbrechenNachFilm();
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jTextFieldDownloads = new JTextField();
        this.jLabelDownload = new JLabel();
        this.jButtonStop = new JButton();
        this.jButtonStopNachFilm = new JButton();
        this.jPanelExtra = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItemLaden = new JMenuItem();
        this.jMenuItemImport = new JMenuItem();
        this.jMenuItemExport = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.jCheckBoxMenuItemPlayer = new JCheckBoxMenuItem();
        this.jMenuItemButtonEinrichten = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItemEinstellungen = new JMenuItem();
        this.jMenuItemEinstellungenNetz = new JMenuItem();
        this.jMenuItemEinstellungenSender = new JMenuItem();
        this.jMenuItemUpdate = new JMenuItem();
        this.jMenuItemAbo = new JMenuItem();
        this.jMenuItemPodcast = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItemInfos = new JMenuItem();
        this.jMenuItemAktivitaet = new JMenuItem();
        this.jMenuItemFehler = new JMenuItem();
        this.jMenuItemAnleitung = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.statusPanel.setBorder(new SoftBevelBorder(0));
        this.jLabel2.setText("laufende Downloads:");
        this.jTextFieldDownloads.setEditable(false);
        this.jTextFieldDownloads.setHorizontalAlignment(0);
        this.jLabelDownload.setText("Downloads:");
        this.jButtonStop.setText("sofort stoppen");
        this.jButtonStop.setToolTipText("Downloads sofort abbrechen");
        this.jButtonStopNachFilm.setText("nach Film stoppen");
        this.jButtonStopNachFilm.setToolTipText("Downloads nach dem Film abbrechen");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelDownload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -1, 330, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStopNachFilm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(6, 6, 6).addComponent(this.jTextFieldDownloads, -2, 38, -2).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelDownload).addComponent(this.jProgressBar1, -2, 23, -2).addComponent(this.jButtonStop, -2, 19, -2).addComponent(this.jLabel2).addComponent(this.jTextFieldDownloads, -2, -1, -2).addComponent(this.jButtonStopNachFilm, -2, 19, -2)));
        statusPanelLayout.linkSize(1, this.jButtonStop, this.jButtonStopNachFilm, this.jProgressBar1, this.jTextFieldDownloads);
        this.jPanelExtra.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 950, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 328, Short.MAX_VALUE));
        this.jMenu1.setText("Filme");
        this.jMenuItemLaden.setText("Filmliste neu laden");
        this.jMenu1.add(this.jMenuItemLaden);
        this.jMenuItemImport.setText("Einstellungen zum Laden der Filmliste");
        this.jMenu1.add(this.jMenuItemImport);
        this.jMenuItemExport.setText("Filmliste exportieren");
        this.jMenuItemExport.setToolTipText("Die ganze Filmliste in eine Datei exportieren");
        this.jMenu1.add(this.jMenuItemExport);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu4.setText("Programme");
        this.jCheckBoxMenuItemPlayer.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.jCheckBoxMenuItemPlayer.setSelected(true);
        this.jCheckBoxMenuItemPlayer.setText("Playerbutton einblenden");
        this.jCheckBoxMenuItemPlayer.setToolTipText("Rahmen mit den Playerbutton einblenden");
        this.jMenu4.add(this.jCheckBoxMenuItemPlayer);
        this.jMenuItemButtonEinrichten.setText("Button einrichten");
        this.jMenu4.add(this.jMenuItemButtonEinrichten);
        this.jMenuBar1.add(this.jMenu4);
        this.jMenu2.setText("Einstellungen");
        this.jMenuItemEinstellungen.setText("Allgemeine Einstellungen");
        this.jMenuItemEinstellungen.setToolTipText("allgemeine Programmeinstellungen");
        this.jMenu2.add(this.jMenuItemEinstellungen);
        this.jMenuItemEinstellungenNetz.setText("Proxy einrichten");
        this.jMenuItemEinstellungenNetz.setToolTipText("Proxyserver eintragen");
        this.jMenu2.add(this.jMenuItemEinstellungenNetz);
        this.jMenuItemEinstellungenSender.setText("Sender ausw\u00e4hlen");
        this.jMenuItemEinstellungenSender.setToolTipText("Sender ein/ausschalten, Einstellungen der Sender");
        this.jMenu2.add(this.jMenuItemEinstellungenSender);
        this.jMenuItemUpdate.setText("Updates einrichten");
        this.jMenuItemUpdate.setToolTipText("Einrichten der Programmupdates");
        this.jMenu2.add(this.jMenuItemUpdate);
        this.jMenuItemAbo.setText("Abos einrichten");
        this.jMenu2.add(this.jMenuItemAbo);
        this.jMenuItemPodcast.setText("Podcasts einrichten");
        this.jMenu2.add(this.jMenuItemPodcast);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Infos");
        this.jMenuItemInfos.setText("Infos Anzeigen");
        this.jMenuItemInfos.setToolTipText("Programminfos, Speicherpfade");
        this.jMenu3.add(this.jMenuItemInfos);
        this.jMenuItemAktivitaet.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.jMenuItemAktivitaet.setText("Aktivit\u00e4t anzeigen");
        this.jMenu3.add(this.jMenuItemAktivitaet);
        this.jMenuItemFehler.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.jMenuItemFehler.setText("Fehler anzeigen");
        this.jMenu3.add(this.jMenuItemFehler);
        this.jMenuItemAnleitung.setText("Anleitung im Web \u00f6ffnen");
        this.jMenu3.add(this.jMenuItemAnleitung);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.statusPanel, -2, -1, -2)));
        this.pack();
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quitForMac", null));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public void quitForMac() {
        this.beenden();
    }

    private class BeobachterStart
    implements StartListener {
        private BeobachterStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            GuiMediathek.this.setProgressBar(ev);
        }
    }

    private class BeobImport
    implements ActionListener {
        private BeobImport() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DialogImportFilme(null, true, GuiMediathek.this.daten).setVisible(true);
        }
    }

    private class BeobLaden
    implements ActionListener {
        private BeobLaden() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiMediathek.this.guiFilme.filmListeLaden();
        }
    }

    private class BeobExport
    implements ActionListener {
        private BeobExport() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogExportFilme dialog = new DialogExportFilme(null, true, GuiMediathek.this.daten);
            dialog.setVisible(true);
        }
    }

    private class BeobPgruppen
    implements ActionListener {
        private BeobPgruppen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DialogPgruppen(null, true, GuiMediathek.this.daten, true, GuiMediathek.this.guiFilme).setVisible(true);
            GuiMediathek.this.guiFilme.setExtraVis(GuiMediathek.this.jCheckBoxMenuItemPlayer.isSelected());
        }
    }

    private class BeobPlayer
    implements ActionListener {
        private BeobPlayer() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.jCheckBoxMenuItemPlayer.setSelected(GuiMediathek.this.jCheckBoxMenuItemPlayer.isSelected());
            GuiMediathek.this.guiFilme.setExtraVis(GuiMediathek.this.jCheckBoxMenuItemPlayer.isSelected());
        }
    }

    private class AlleAbbrechenNachFilm
    implements ActionListener {
        private AlleAbbrechenNachFilm() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.alleDownloadsAbbrechenNachFilm();
        }
    }

    private class AlleAbbrechen
    implements ActionListener {
        private AlleAbbrechen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.alleDownloadsAbbrechen();
        }
    }
}

