/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.Fehler;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilmUpdate;
import mediathek.io.UpdateSuchen;

public class DialogImportFilme
extends JDialog {
    Daten daten;
    public boolean ok = false;
    public String ziel;
    private boolean stopBeob = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonBeenden;
    private JButton jButtonImportPfad;
    private JButton jButtonUpdate;
    private JCheckBox jCheckBox20;
    private JCheckBox jCheckBoxAlt;
    private JCheckBox jCheckBoxImport;
    private JCheckBox jCheckBoxNurAbos;
    private JCheckBox jCheckBoxSender;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButtonImportDatei;
    private JRadioButton jRadioButtonImportUrl;
    private JRadioButton jRadioButtonImportWebsite;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldPfadImportDatei;
    private JTextField jTextFieldUrl;

    public DialogImportFilme(Frame parent, boolean modal, Daten d) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Einstellungen zum Laden der Filme");
        this.daten = d;
        this.init();
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogImportFilme.this.beenden();
            }
        });
        this.jTextFieldPfadImportDatei.getDocument().addDocumentListener(new BeobTextFeld(this.jTextFieldPfadImportDatei, 34));
        this.jRadioButtonImportWebsite.addActionListener(new BeobAction());
        this.jRadioButtonImportDatei.addActionListener(new BeobAction());
        this.jRadioButtonImportUrl.addActionListener(new BeobAction());
        this.jButtonImportPfad.addActionListener(new BeobPfad(this.jTextFieldPfadImportDatei));
        this.jButtonUpdate.addActionListener(new BeobSuchen());
        this.jCheckBoxImport.addActionListener(new BeobCheckBox());
        this.jCheckBoxAlt.addActionListener(new BeobCheckBox());
        this.jCheckBoxSender.addActionListener(new BeobCheckBox());
        this.jCheckBoxNurAbos.addActionListener(new BeobCheckBox());
        this.jCheckBox20.addActionListener(new BeobCheckBox20());
        this.jTextFieldUrl.getDocument().addDocumentListener(new BeobTextFeld(this.jTextFieldUrl, 35));
    }

    private void init() {
        if (this.daten.system[38].equals("import-datei")) {
            this.jRadioButtonImportDatei.setSelected(true);
        } else if (this.daten.system[38].equals("import-url")) {
            this.jRadioButtonImportUrl.setSelected(true);
        } else {
            this.jRadioButtonImportWebsite.setSelected(true);
        }
        this.jTextFieldPfadImportDatei.setText(this.daten.system[34]);
        this.jTextFieldUrl.setText(this.daten.system[35]);
        this.jCheckBoxImport.setSelected(Boolean.parseBoolean(this.daten.system[48]));
        this.jCheckBoxAlt.setSelected(Boolean.parseBoolean(this.daten.system[43]));
        this.jCheckBoxSender.setSelected(Boolean.parseBoolean(this.daten.system[44]));
        this.jCheckBoxNurAbos.setSelected(Boolean.parseBoolean(this.daten.system[8]));
        this.jCheckBox20.setSelected(Boolean.parseBoolean(this.daten.system[49]));
        this.tabelleLaden();
        this.jTable1.getSelectionModel().addListSelectionListener(new BeobachterTableSelect1());
        this.textfeldSetzen();
    }

    private void textfeldSetzen() {
        this.jTextFieldPfadImportDatei.setEnabled(this.daten.system[38].equals("import-datei"));
        this.jTextFieldUrl.setEnabled(this.daten.system[38].equals("import-url"));
        this.jButtonUpdate.setEnabled(this.daten.system[38].equals("import-url"));
        this.jButtonImportPfad.setEnabled(this.daten.system[38].equals("import-datei"));
        this.jCheckBoxNurAbos.setEnabled(this.daten.system[38].equals("import-website"));
        this.jCheckBoxAlt.setEnabled(this.daten.system[38].equals("import-datei") || this.daten.system[38].equals("import-url"));
        this.jCheckBoxSender.setEnabled(this.daten.system[38].equals("import-datei") || this.daten.system[38].equals("import-url"));
        this.jCheckBox20.setEnabled(this.daten.system[38].equals("import-url"));
        this.jCheckBoxImport.setEnabled(this.daten.system[38].equals("import-url"));
    }

    private void beenden() {
        this.dispose();
        this.daten.setGeaendertSofort();
    }

    private void updateSuchen() {
        new UpdateSuchen(this.daten).suchen(false, true);
        this.stopBeob = true;
        this.jTextFieldUrl.setText(this.daten.system[35]);
        this.tabelleLaden();
        this.daten.setGeaendertSofort();
        this.stopBeob = false;
    }

    private void tabelleLaden() {
        this.jTable1.setModel(new DefaultTableModel(this.daten.listeFilmUpdate.getTableObjectData(), Konstanten.FILM_UPDATE_COLUMN_NAMES_ANZEIGE));
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            if (i == 0) {
                this.jTable1.getColumnModel().getColumn(i).setMinWidth(10);
                this.jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
                this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(350);
                continue;
            }
            if (i == 4 || i == 3) {
                this.jTable1.getColumnModel().getColumn(i).setMinWidth(0);
                this.jTable1.getColumnModel().getColumn(i).setMaxWidth(0);
                this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(0);
                continue;
            }
            this.jTable1.getColumnModel().getColumn(i).setMinWidth(10);
            this.jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(100);
        }
    }

    private void table1Select() {
        DatenFilmUpdate aktUpdate = null;
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            for (int i = 0; i < 16; ++i) {
                aktUpdate = this.daten.listeFilmUpdate.getNrUpdate((String)this.jTable1.getModel().getValueAt(this.jTable1.convertRowIndexToModel(selectedTableRow), 0));
            }
        }
        if (aktUpdate != null) {
            this.jTextFieldUrl.setText(aktUpdate.arr[0]);
            this.daten.system[35] = aktUpdate.arr[0];
            this.daten.setGeaendertSofort();
        } else {
            this.jTextFieldUrl.setText("");
        }
    }

    private void tabelleSelSetzten() {
        this.stopBeob = true;
        boolean gefunden = false;
        for (int i = 0; i < 16; ++i) {
            if (!this.jTable1.getModel().getValueAt(this.jTable1.convertRowIndexToModel(i), 0).equals(this.daten.system[35])) continue;
            gefunden = true;
            this.jTable1.setRowSelectionInterval(i, i);
            this.jTable1.scrollRectToVisible(this.jTable1.getCellRect(i, 0, false));
            break;
        }
        if (!gefunden) {
            this.jTable1.getSelectionModel().clearSelection();
        }
        this.stopBeob = false;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonBeenden = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonImportUrl = new JRadioButton();
        this.jButtonUpdate = new JButton();
        this.jCheckBoxImport = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTextFieldUrl = new JTextField();
        this.jLabel1 = new JLabel();
        this.jCheckBox20 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonImportDatei = new JRadioButton();
        this.jTextFieldPfadImportDatei = new JTextField();
        this.jButtonImportPfad = new JButton();
        this.jCheckBoxAlt = new JCheckBox();
        this.jCheckBoxSender = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jRadioButtonImportWebsite = new JRadioButton();
        this.jCheckBoxNurAbos = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jButtonBeenden.setText("Ok");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(51, 51, 255)), "Filmliste aus Datei importieren"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup1.add(this.jRadioButtonImportUrl);
        this.jRadioButtonImportUrl.setSelected(true);
        this.jRadioButtonImportUrl.setText("Url:");
        this.jButtonUpdate.setText("Liste online aktualisieren");
        this.jCheckBoxImport.setText("Importliste beim Update-Suchen aktualisieren");
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setText("URL:");
        this.jCheckBox20.setText("Nur Listen \"Nach 20 Uhr\"");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonImportUrl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUrl, -1, 666, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 710, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButtonUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 144, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox20).addComponent(this.jCheckBoxImport)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonImportUrl).addComponent(this.jScrollPane1, -1, 147, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUrl, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxImport).addComponent(this.jButtonUpdate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox20).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jButtonUpdate, this.jTextFieldUrl);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup1.add(this.jRadioButtonImportDatei);
        this.jRadioButtonImportDatei.setText("Datei:");
        this.jButtonImportPfad.setText(":::");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonImportDatei).addGap(8, 8, 8).addComponent(this.jTextFieldPfadImportDatei, -1, 643, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImportPfad).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldPfadImportDatei, -2, -1, -2).addComponent(this.jRadioButtonImportDatei).addComponent(this.jButtonImportPfad)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonImportPfad, this.jTextFieldPfadImportDatei);
        this.jCheckBoxAlt.setText("Auch \u00e4ltere Filme importieren");
        this.jCheckBoxSender.setText("Nur Sender die in den Einstellungen eingeschaltet sind, laden");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSender).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxAlt)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAlt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSender).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 255)));
        this.buttonGroup1.add(this.jRadioButtonImportWebsite);
        this.jRadioButtonImportWebsite.setText("Filme von den Websiten der Sender laden (dauert mehrere Stunden!)");
        this.jCheckBoxNurAbos.setText("nur Abos laden");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jCheckBoxNurAbos)).addComponent(this.jRadioButtonImportWebsite)).addContainerGap(306, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonImportWebsite).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxNurAbos).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonBeenden, GroupLayout.Alignment.TRAILING, -2, 94, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonBeenden).addContainerGap()));
        this.pack();
    }

    private class BeobachterTableSelect1
    implements ListSelectionListener {
        public int selectedModelRow = -1;

        private BeobachterTableSelect1() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!DialogImportFilme.this.stopBeob && !event.getValueIsAdjusting()) {
                DialogImportFilme.this.table1Select();
            }
        }
    }

    private class BeobCheckBox20
    implements ActionListener {
        private BeobCheckBox20() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DialogImportFilme.this.stopBeob) {
                DialogImportFilme.this.daten.system[49] = Boolean.toString(DialogImportFilme.this.jCheckBox20.isSelected());
                DialogImportFilme.this.daten.listeFilmUpdate.check20();
                DialogImportFilme.this.tabelleLaden();
                DialogImportFilme.this.daten.system[35] = DialogImportFilme.this.daten.listeFilmUpdate.getRand(0);
                DialogImportFilme.this.tabelleSelSetzten();
                DialogImportFilme.this.daten.setGeaendertSofort();
            }
        }
    }

    private class BeobCheckBox
    implements ActionListener {
        private BeobCheckBox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DialogImportFilme.this.stopBeob) {
                DialogImportFilme.this.daten.system[48] = Boolean.toString(DialogImportFilme.this.jCheckBoxImport.isSelected());
                DialogImportFilme.this.daten.system[43] = Boolean.toString(DialogImportFilme.this.jCheckBoxAlt.isSelected());
                DialogImportFilme.this.daten.system[8] = Boolean.toString(DialogImportFilme.this.jCheckBoxNurAbos.isSelected());
                DialogImportFilme.this.daten.system[44] = Boolean.toString(DialogImportFilme.this.jCheckBoxSender.isSelected());
                DialogImportFilme.this.daten.setGeaendert();
            }
        }
    }

    private class BeobSuchen
    implements ActionListener {
        private BeobSuchen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogImportFilme.this.updateSuchen();
        }
    }

    private class BeobPfad
    implements ActionListener {
        JTextField textFeld;

        public BeobPfad(JTextField ttextFeld) {
            this.textFeld = ttextFeld;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (!this.textFeld.getText().equals("")) {
                chooser.setCurrentDirectory(new File(this.textFeld.getText()));
            }
            chooser.setFileSelectionMode(0);
            chooser.setFileHidingEnabled(false);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    this.textFeld.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    new Fehler(DialogImportFilme.this.daten).fehlerMeldung(ex, "DialogImportFilme.BeobImport");
                }
            }
        }
    }

    private class BeobTextFeld
    implements DocumentListener {
        JTextField textFeld;
        int nr;

        public BeobTextFeld(JTextField tFeld, int n) {
            this.textFeld = tFeld;
            this.nr = n;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        void tusEinfach(DocumentEvent e) {
            if (!DialogImportFilme.this.stopBeob) {
                DialogImportFilme.this.daten.system[this.nr] = this.textFeld.getText();
                DialogImportFilme.this.tabelleSelSetzten();
                DialogImportFilme.this.daten.setGeaendertSofort();
            }
        }
    }

    private class BeobAction
    implements ActionListener {
        private BeobAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogImportFilme.this.daten.system[38] = DialogImportFilme.this.jRadioButtonImportUrl.isSelected() ? "import-url" : (DialogImportFilme.this.jRadioButtonImportDatei.isSelected() ? "import-datei" : "import-website");
            DialogImportFilme.this.daten.setGeaendertSofort();
            DialogImportFilme.this.textfeldSetzen();
        }
    }
}

