/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.Fehler;
import mediathek.daten.Daten;

public class FeedReaderPodster {
    private Daten daten;
    private String[][] feeds = new String[][]{{"http://podster.de/tag/business/opml", "Business"}, {"http://podster.de/tag/comedy/opml", "Comedy"}, {"http://podster.de/tag/filme/opml", "Filme"}, {"http://podster.de/tag/gesellschaft/opml", "Gesellschaft"}, {"http://podster.de/tag/kultur/opml", "Kultur"}, {"http://podster.de/tag/kunst/opml", "Kunst"}, {"http://podster.de/tag/musik/opml", "Musik"}, {"http://podster.de/tag/news/opml", "News"}, {"http://podster.de/tag/politik/opml", "Politik"}, {"http://podster.de/tag/privates/opml", "Privates"}, {"http://podster.de/tag/religion/opml", "Religion"}, {"http://podster.de/tag/spiele/opml", "Spiele"}, {"http://podster.de/tag/sport/opml", "Sport"}, {"http://podster.de/tag/technologie/opml", "Technologie"}, {"http://podster.de/tag/unterhaltung/opml", "Unterhaltung"}, {"http://podster.de/tag/wissenschaft/opml", "Wissenschaft"}};

    public FeedReaderPodster(Daten d) {
        this.daten = d;
    }

    public synchronized void starten() {
        this.daten.listePodster.clear();
        for (int i = 0; i < this.feeds.length; ++i) {
            new Laden(this.feeds[i][0], this.feeds[i][1]).laden();
        }
    }

    private class Laden {
        String feedurl = "";
        String thema = "";

        public Laden(String uurl, String tthema) {
            this.feedurl = uurl;
            this.thema = tthema;
        }

        public void laden() {
            try {
                if (!this.feedurl.equals("")) {
                    URL feedUrl = new URL(this.feedurl);
                    URLConnection conn = feedUrl.openConnection();
                    conn.setRequestProperty("User-Agent", ((FeedReaderPodster)FeedReaderPodster.this).daten.system[3]);
                    conn.setReadTimeout(2000);
                    XMLInputFactory inFactory = XMLInputFactory.newInstance();
                    inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                    XMLStreamReader parser = null;
                    InputStreamReader in = null;
                    in = new InputStreamReader(conn.getInputStream(), "ISO-8859-15");
                    parser = inFactory.createXMLStreamReader(in);
                    while (parser.hasNext()) {
                        int event = parser.next();
                        if (event != 1 || !parser.getLocalName().equals("outline")) continue;
                        this.get(parser, this.thema);
                    }
                }
            }
            catch (Exception ex) {
                new Fehler(FeedReaderPodster.this.daten).fehlerMeldung(ex, "FeedReaderPodster.Laden");
            }
        }

        private boolean get(XMLStreamReader parser, String thema) {
            boolean ret = true;
            String titel = "";
            String url = "";
            try {
                int attr = parser.getAttributeCount();
                String strAttr = "";
                for (int i = 0; i < attr; ++i) {
                    strAttr = parser.getAttributeLocalName(i);
                    if (strAttr.equals("title")) {
                        titel = parser.getAttributeValue(i);
                    }
                    if (!strAttr.equals("url")) continue;
                    url = parser.getAttributeValue(i);
                }
                ((FeedReaderPodster)FeedReaderPodster.this).daten.listePodster.addPod(titel, url, thema);
            }
            catch (Exception ex) {
                ret = false;
            }
            return ret;
        }
    }
}

