/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.EventListenerList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenPod;
import mediathek.daten.DatenPodster;
import mediathek.daten.DatenProg;
import mediathek.filme.DatenFilm;
import mediathek.filme.FilmListener;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class IoXml {
    private XMLOutputFactory outFactory;
    private XMLStreamWriter writer;
    private OutputStreamWriter out = null;
    ZipOutputStream zipOutputStream = null;
    BZip2CompressorOutputStream bZip2CompressorOutputStream = null;
    private Daten daten;
    EventListenerList listeners = new EventListenerList();
    public boolean stop = false;

    public IoXml(Daten d) {
        this.daten = d;
    }

    public void datenLesen() {
        this.stop = false;
        this.xmlDatenLesen();
        this.xmlDatenLesenFilme();
        this.xmlDatenLesenPodster();
    }

    public void datenLesenFilme() {
        this.stop = false;
        this.xmlDatenLesenFilme();
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importDatenFilme(String datei, boolean istDatei) {
        this.stop = false;
        this.notifyStart(1);
        this.notifyProgress(datei);
        boolean ret = true;
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        XMLStreamReader parser = null;
        InputStreamReader inReader = null;
        Object inputStream = null;
        BZip2CompressorInputStream bZip2CompressorInputStream = null;
        String user_agent = this.daten.system[3];
        int timeout = 30000;
        URLConnection conn = null;
        try {
            ZipInputStream zipInputStream;
            if (istDatei) {
                if (datei.endsWith(".bz2")) {
                    bZip2CompressorInputStream = new BZip2CompressorInputStream(new FileInputStream(datei));
                    inReader = new InputStreamReader((InputStream)bZip2CompressorInputStream, "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(new FileInputStream(datei));
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                }
            } else {
                conn = new URL(datei).openConnection();
                conn.setRequestProperty("User-Agent", user_agent);
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
                if (datei.endsWith(".bz2")) {
                    bZip2CompressorInputStream = new BZip2CompressorInputStream(conn.getInputStream());
                    inReader = new InputStreamReader((InputStream)bZip2CompressorInputStream, "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(conn.getInputStream());
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
                }
            }
            parser = inFactory.createXMLStreamReader(inReader);
            ret = this.datenLesenFilme(parser, Boolean.parseBoolean(this.daten.system[43]), datei);
        }
        catch (Exception ex) {
            ret = false;
            this.daten.fehler.fehlerMeldung(ex, "Filme importieren von: " + datei);
        }
        finally {
            try {
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception ex) {
                this.daten.fehler.fehlerMeldung(ex, "Stream.close");
            }
            this.notifyFertig();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean xmlDatenLesen() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".mediathek";
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            DatenPgruppe datenPgruppe = null;
            in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                String t = parser.getLocalName();
                if (parser.getLocalName().equals("System")) {
                    this.get(parser, event, "System", Konstanten.SYSTEM_COLUMN_NAMES, this.daten.system);
                    continue;
                }
                if (parser.getLocalName().equals("Senderliste")) {
                    String[] str = this.daten.filmeLaden.getListeSender();
                    this.get(parser, event, "Senderliste", this.daten.filmeLaden.getListeSender(), str);
                    this.daten.filmeLaden.setSenderOn(str);
                    continue;
                }
                if (parser.getLocalName().equals("Programmgruppe-Abo")) {
                    datenPgruppe = new DatenPgruppe();
                    if (!this.get(parser, event, "Programmgruppe-Abo", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                    this.daten.listePgruppeAbo.add(datenPgruppe);
                    continue;
                }
                if (parser.getLocalName().equals("Programmgruppe-Button")) {
                    datenPgruppe = new DatenPgruppe();
                    if (!this.get(parser, event, "Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                    this.daten.listePgruppeButton.add(datenPgruppe);
                    continue;
                }
                if (parser.getLocalName().equals("Programm")) {
                    DatenProg datenProg = new DatenProg();
                    if (!this.get(parser, event, "Programm", Konstanten.PROGRAMM_COLUMN_NAMES, datenProg.arr) || datenPgruppe == null) continue;
                    datenPgruppe.addProg(datenProg);
                    continue;
                }
                if (parser.getLocalName().equals("Abonnement")) {
                    DatenAbo datenAbo = new DatenAbo();
                    if (!this.get(parser, event, "Abonnement", Konstanten.ABO_COLUMN_NAMES, datenAbo.arr) || Boolean.parseBoolean(datenAbo.arr[10])) continue;
                    this.daten.listeAbo.addAbo(datenAbo);
                    continue;
                }
                if (parser.getLocalName().equals("Blacklist")) {
                    DatenBlacklist blacklist = new DatenBlacklist();
                    if (!this.get(parser, event, "Blacklist", Konstanten.BLACKLIST_COLUMN_NAMES, blacklist.arr)) continue;
                    this.daten.listeBlacklist.add(blacklist);
                    continue;
                }
                if (parser.getLocalName().equals("Pod")) {
                    DatenPod datenPod = new DatenPod();
                    if (!this.get(parser, event, "Pod", Konstanten.POD_COLUMN_NAMES, datenPod.arr)) continue;
                    this.daten.listePod.addPod(datenPod);
                    continue;
                }
                if (!parser.getLocalName().equals("Film-Update")) continue;
                DatenFilmUpdate datenFilmUpdate = new DatenFilmUpdate();
                if (!this.get(parser, event, "Film-Update", Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr)) continue;
                this.daten.listeFilmUpdate.addAlle(datenFilmUpdate);
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.datenLesen");
            ret = false;
        }
        finally {
            if (!this.daten.noGui) {
                if (this.daten.system[11].equals("")) {
                    Funktionen.addStandardPodcast(this.daten);
                }
                if (this.daten.listePgruppeAbo.size() == 0) {
                    Funktionen.addStandardprogrammeAbo(this.daten);
                }
                if (this.daten.listePgruppeButton.size() == 0) {
                    Funktionen.addStandardprogrammeButton(this.daten);
                }
                ret = false;
                this.daten.listeFilmUpdate.check20(Boolean.parseBoolean(this.daten.system[49]));
            }
        }
        return ret;
    }

    private boolean xmlDatenLesenFilme() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".filme";
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            parser = inFactory.createXMLStreamReader(in);
            ret = this.datenLesenFilme(parser);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean xmlDatenLesenPodster() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".podcaster";
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            parser = inFactory.createXMLStreamReader(in);
            ret = this.datenLesenPodster(parser);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean datenLesenFilme(XMLStreamReader parser) {
        return this.datenLesenFilme(parser, true, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean datenLesenFilme(XMLStreamReader parser, boolean auchAlte, String text) {
        boolean ret = true;
        text = Funktionen.textLaenge(text);
        try {
            while (!this.stop && parser.hasNext()) {
                int event = parser.next();
                if (event == 1 && parser.getLocalName().equals("Filmliste")) {
                    this.get(parser, event, "Filmliste", Konstanten.FILMLISTE_COLUMN_NAMES, this.daten.filmeLaden.filmlisteMetaDaten);
                    int anz = 1;
                    try {
                        anz = Integer.parseInt(this.daten.filmeLaden.filmlisteMetaDaten[3]);
                    }
                    catch (Exception ex) {
                    }
                    finally {
                        this.addMax(anz);
                    }
                }
                if (event != 1 || !parser.getLocalName().equals("Filme")) continue;
                DatenFilm datenFilm = new DatenFilm(this.daten);
                if (!this.get(parser, event, "Filme", Konstanten.FILME_COLUMN_NAMES, datenFilm.arr)) continue;
                this.notifyProgress(text);
                this.daten.filmeLaden.listeFilmeSchattenliste.add(datenFilm);
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean datenLesenPodster(XMLStreamReader parser) {
        boolean ret = true;
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals("Podster")) continue;
                DatenPodster datenPodster = new DatenPodster();
                if (!this.get(parser, event, "Podster", Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr)) continue;
                this.daten.listePodster.add(datenPodster);
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        int i;
        boolean ret = true;
        int maxElem = strRet.length;
        for (i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            this.daten.fehler.fehlerMeldung(ex, "IoXml.get");
        }
        return ret;
    }

    public synchronized void datenSchreiben() {
        this.stop = false;
        this.xmlDatenSchreiben();
        this.xmlFilmeSchreiben();
        this.xmlPodcastlisteSchreiben();
        this.daten.history.speichern();
    }

    public synchronized void filmeSchreiben() {
        this.stop = false;
        this.xmlFilmeSchreiben();
    }

    public synchronized void exportFilme(String datei) {
        this.stop = false;
        try {
            this.daten.fehler.systemMeldung("Filme exportieren nach: " + datei);
            this.xmlSchreibenStart(datei);
            this.xmlSchreibenFilmliste();
            this.xmlSchreibenFilm();
            this.xmlSchreibenEnde(datei);
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "Filme exportieren nach: " + datei);
        }
    }

    private void xmlDatenSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Daten schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".mediathek");
            this.xmlSchreibenSystem();
            this.xmlSchreibenProg();
            this.xmlSchreibenAbo();
            this.xmlSchreibenBlackList();
            this.xmlSchreibenPod();
            this.xmlSchreibenFilmUpdate();
            this.xmlSchreibenEnde();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void xmlFilmeSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Filme schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".filme");
            this.xmlSchreibenFilmliste();
            this.xmlSchreibenFilm();
            this.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.xmlFilmeSchreiben");
        }
    }

    private void xmlPodcastlisteSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Podcastliste schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".podcaster");
            this.xmlSchreibenPodcastliste();
            this.xmlSchreibenEnde();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void xmlSchreibenStart(String datei) throws Exception {
        File file = new File(datei);
        System.out.println("Datei schreiben: " + file.getAbsolutePath());
        this.outFactory = XMLOutputFactory.newInstance();
        if (datei.endsWith(".bz2")) {
            this.bZip2CompressorOutputStream = new BZip2CompressorOutputStream(new FileOutputStream(file), 2);
            this.out = new OutputStreamWriter((OutputStream)this.bZip2CompressorOutputStream, "UTF-8");
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            ZipEntry entry = new ZipEntry(".filme");
            this.zipOutputStream.putNextEntry(entry);
            this.out = new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8");
        } else {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        }
        this.writer = this.outFactory.createXMLStreamWriter(this.out);
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeCharacters("\n");
        this.writer.writeStartElement("Mediathek");
        this.writer.writeCharacters("\n");
    }

    private void xmlSchreibenSystem() {
        this.xmlSchreibenDaten("System", Konstanten.SYSTEM_COLUMN_NAMES, this.daten.system);
        this.xmlSchreibenDaten("Senderliste", this.daten.filmeLaden.getListeSender(), this.daten.filmeLaden.getSenderOn());
    }

    private void xmlSchreibenFilmliste() {
        this.xmlSchreibenDaten("Filmliste", Konstanten.FILMLISTE_COLUMN_NAMES, this.daten.filmeLaden.filmlisteMetaDaten);
    }

    private void xmlSchreibenPodcastliste() {
        ListIterator iterator = this.daten.listePodster.listIterator();
        while (iterator.hasNext()) {
            DatenPodster datenPodster = (DatenPodster)iterator.next();
            this.xmlSchreibenDaten("Podster", Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr);
        }
    }

    private void xmlSchreibenFilm() {
        ListIterator iterator = this.daten.filmeLaden.listeFilmeSchattenliste.listIterator();
        while (iterator.hasNext()) {
            DatenFilm datenFilm = (DatenFilm)iterator.next();
            this.xmlSchreibenDaten("Filme", Konstanten.FILME_COLUMN_NAMES, datenFilm.getClean().arr);
        }
    }

    private void xmlSchreibenProg() {
        ListIterator it;
        DatenPgruppe datenPgruppe;
        ListIterator iterator = this.daten.listePgruppeAbo.listIterator();
        while (iterator.hasNext()) {
            datenPgruppe = (DatenPgruppe)iterator.next();
            this.xmlSchreibenDaten("Programmgruppe-Abo", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", Konstanten.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
        iterator = this.daten.listePgruppeButton.listIterator();
        while (iterator.hasNext()) {
            datenPgruppe = (DatenPgruppe)iterator.next();
            this.xmlSchreibenDaten("Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", Konstanten.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
    }

    private void xmlSchreibenAbo() {
        ListIterator iterator = this.daten.listeAbo.listIterator();
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            this.xmlSchreibenDaten("Abonnement", Konstanten.ABO_COLUMN_NAMES, datenAbo.arr);
        }
    }

    private void xmlSchreibenBlackList() {
        for (DatenBlacklist blacklist : this.daten.listeBlacklist) {
            this.xmlSchreibenDaten("Blacklist", Konstanten.BLACKLIST_COLUMN_NAMES, blacklist.arr);
        }
    }

    private void xmlSchreibenPod() {
        ListIterator iterator = this.daten.listePod.listIterator();
        while (iterator.hasNext()) {
            DatenPod datenPod = (DatenPod)iterator.next();
            this.xmlSchreibenDaten("Pod", Konstanten.POD_COLUMN_NAMES, datenPod.arr);
        }
    }

    private void xmlSchreibenFilmUpdate() {
        ListIterator iterator = this.daten.listeFilmUpdate.alle.listIterator();
        while (iterator.hasNext()) {
            DatenFilmUpdate datenFilmUpdate = (DatenFilmUpdate)iterator.next();
            this.xmlSchreibenDaten("Film-Update", Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr);
        }
    }

    private void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray) {
        int xmlMax = datenArray.length;
        try {
            this.writer.writeStartElement(xmlName);
            for (int i = 0; i < xmlMax; ++i) {
                if (datenArray[i].equals("")) continue;
                this.writer.writeStartElement(xmlSpalten[i]);
                this.writer.writeCharacters(datenArray[i]);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.xmlSchreibenDaten");
        }
    }

    private void xmlSchreibenEnde() throws Exception {
        this.xmlSchreibenEnde("");
    }

    private void xmlSchreibenEnde(String datei) throws Exception {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
        if (datei.endsWith(".bz2")) {
            this.writer.close();
            this.bZip2CompressorOutputStream.close();
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream.closeEntry();
            this.writer.close();
            this.zipOutputStream.close();
        } else {
            this.writer.close();
        }
        this.daten.fehler.systemMeldung("geschrieben!");
    }

    private void notifyStart(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start("", max);
        }
    }

    private void addMax(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.addMax("", max);
        }
    }

    private void notifyProgress(String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress("", text);
        }
    }

    private void notifyFertig() {
        this.daten.fehler.systemMeldung("Liste Filme gelesen: " + Funktionen.getJetzt_HH_MM_SS());
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig("", false);
        }
    }
}

