/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io.starter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.Funktionen;
import mediathek.Hinweis;
import mediathek.HinweisKeineAuswahl;
import mediathek.TModel;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.filme.DatenFilm;
import mediathek.gui.dialoge.DialogZiel;
import mediathek.io.starter.ListeStarts;
import mediathek.io.starter.RuntimeExec;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;
import mediathek.io.starter.Starts;

public class StarterClass {
    private Daten daten;
    private boolean allesStop = false;
    private ListeStarts listeStarts;
    private Starten starten = null;
    private EventListenerList listeners = new EventListenerList();

    public StarterClass(Daten d) {
        this.daten = d;
        this.listeners = new EventListenerList();
        this.listeStarts = new ListeStarts(this.daten);
        this.starten = new Starten();
        Thread startenThread = new Thread(this.starten);
        startenThread.setDaemon(true);
        startenThread.start();
    }

    public synchronized Starts urlStarten(String url, int open, DatenFilm ersterFilm) {
        Starts ret = null;
        String befehlsString = "";
        String zielDateiname = "";
        String zielPfad = "";
        String zielPfadDatei = "";
        int art = 0;
        if (!url.equals("")) {
            DatenPgruppe gruppe = (DatenPgruppe)this.daten.listePgruppeButton.get(open);
            DatenProg prog = gruppe.getProgUrl(url);
            if (prog != null) {
                Starts s;
                befehlsString = prog.getBegehl();
                if ((url.startsWith("-r") || url.startsWith("rtmp") || url.startsWith("--host")) && !befehlsString.contains("flvstreamer") && !befehlsString.contains("rtmpdump")) {
                    new Hinweis(this.daten).hinweisFlash();
                }
                zielDateiname = gruppe.getZielDateiname();
                zielPfad = gruppe.getZielPfad();
                art = gruppe.checkDownloadDirekt(this.daten, url);
                if (!zielDateiname.equals("")) {
                    if (zielDateiname.contains("%p")) {
                        String name = Funktionen.getHeute_yyyyMMdd() + "_" + ersterFilm.arr[2] + "-" + ersterFilm.arr[3] + ".mp4";
                        name = Funktionen.replaceLeerDateiname(name, true);
                        DialogZiel dialog = new DialogZiel(null, true, this.daten, gruppe.getZielPfad(), Funktionen.getDateiName(this.daten, name));
                        dialog.setVisible(true);
                        if (!dialog.ok) {
                            return null;
                        }
                        zielDateiname = zielDateiname.replace("%p", dialog.zielDateiname);
                        zielPfad = dialog.zielPfad;
                    } else if (zielDateiname.contains("%n")) {
                        String name = Funktionen.getHeute_yyyyMMdd() + "_" + ersterFilm.arr[2] + "-" + ersterFilm.arr[3] + ".mp4";
                        String str = JOptionPane.showInputDialog("Dateiname eingeben", (Object)(name = Funktionen.replaceLeerDateiname(name, true)));
                        if (str == null) {
                            return null;
                        }
                        zielDateiname = zielDateiname.replace("%n", Funktionen.replaceLeerDateiname(str, true));
                    }
                    if (zielPfad.equals("")) {
                        JOptionPane.showMessageDialog(null, "Zielpfad angeben!", "Pfad leer", 1);
                    }
                    zielPfadDatei = ersterFilm.dateiNamenBauen(zielPfad, zielDateiname);
                    befehlsString = Funktionen.getBefhelsString(befehlsString, zielPfadDatei, url, ersterFilm);
                } else {
                    befehlsString = befehlsString.replace("%f", url);
                }
                ret = s = new Starts(1, ersterFilm, art, befehlsString, Boolean.parseBoolean(prog.arr[5]));
                if (s.art == 2) {
                    StartenProgramm zdfStarten = new StartenProgramm(s);
                    new Thread(zdfStarten).start();
                    this.addStarts(s);
                } else {
                    StartenDonwnload podderStart = new StartenDonwnload(s);
                    new Thread(podderStart).start();
                    this.addStarts(s);
                }
            }
        } else {
            new HinweisKeineAuswahl();
        }
        return ret;
    }

    public synchronized LinkedList<Starts> getStarts(int quelle) {
        LinkedList<Starts> ret = new LinkedList<Starts>();
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.quelle != quelle && quelle != -1) continue;
            ret.add(s);
        }
        return ret;
    }

    public synchronized TModel getStarterModell(TModel model) {
        return this.listeStarts.getModel(model);
    }

    public void addListener(StartListener listener) {
        this.listeners.add(StartListener.class, listener);
    }

    public synchronized void addListe(LinkedList<Starts> starts) {
        this.allesStop = false;
        if (starts != null) {
            ListIterator<Starts> it = starts.listIterator(0);
            while (it.hasNext()) {
                Starts s = it.next();
                this.addStarts(s);
            }
        }
    }

    public synchronized void addStarts(Starts starts) {
        this.allesStop = false;
        if (starts != null && !this.listeStarts.contain(starts)) {
            this.listeStarts.add(starts);
        }
        this.notifyStartEvent();
    }

    public synchronized int getState(String url) {
        int ret = 0;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (!s.film.arr[6].equals(url)) continue;
            ret = s.status;
            break;
        }
        return ret;
    }

    public synchronized Starts getStart(String url) {
        Starts ret = null;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (!s.film.arr[6].equals(url)) continue;
            ret = s;
            break;
        }
        return ret;
    }

    public synchronized void delStart(String url) {
        this.listeStarts.delStart(url);
    }

    public synchronized void aufraeumen(int quelle) {
        this.listeStarts.aufraeumen(quelle);
        this.notifyStartEvent();
    }

    public synchronized void abbrechen() {
        this.allesStop = true;
        this.listeStarts.delAlle();
        this.notifyStartEvent();
    }

    public synchronized void abbrechenNachFilm() {
        this.listeStarts.delRest();
        this.notifyStartEvent();
    }

    public synchronized void filmLoeschen(String url) {
        this.listeStarts.delStart(url);
        this.notifyStartEvent();
    }

    private void notifyStartEvent() {
        int down = 0;
        int progr = 0;
        int max = this.listeStarts.getmax();
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.status == 2) {
                ++down;
            }
            if (s.status < 3) continue;
            ++progr;
        }
        StartEvent event = new StartEvent(this, down, progr, max, this.allesStop);
        for (StartListener l : (StartListener[])this.listeners.getListeners(StartListener.class)) {
            l.starter(event);
        }
    }

    private Starts getListe() {
        Starts s;
        Starts ret = null;
        if (this.allesStop) {
            Iterator<Starts> it = this.listeStarts.getIt();
            while (it.hasNext()) {
                Starts s2 = it.next();
                if (s2.status >= 3) continue;
                it.remove();
            }
        } else if (this.listeStarts.size() >= 0 && this.listeStarts.getDown() < Integer.parseInt(this.daten.system[17]) && (s = this.naechsterStart()) != null && s.status == 1) {
            ret = s;
        }
        return ret;
    }

    private void buttonStartsPutzen() {
        boolean habsGetan = false;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.quelle != 1 || s.status == 2) continue;
            it.remove();
            habsGetan = true;
        }
        if (habsGetan) {
            this.notifyStartEvent();
        }
    }

    private Starts naechsterStart() {
        Starts s = null;
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            s = it.next();
            if (s.status != 1 || this.maxSenderLaufen(s, 1)) continue;
            return s;
        }
        it = this.listeStarts.getIt();
        while (it.hasNext()) {
            s = it.next();
            if (s.status != 1 || this.maxSenderLaufen(s, 2)) continue;
            return s;
        }
        return null;
    }

    private boolean maxSenderLaufen(Starts s, int max) {
        int counter = 0;
        Starts start = null;
        String sender = s.film.arr[1];
        Iterator<Starts> it = this.listeStarts.getIt();
        while (it.hasNext()) {
            start = it.next();
            if (start.status != 2 || !start.film.arr[1].equalsIgnoreCase(sender) || ++counter < max) continue;
            return true;
        }
        return false;
    }

    private boolean einmalErledigen(DatenFilm film) {
        boolean ret = false;
        String name = "";
        try {
            DatenAbo abo = this.daten.listeAbo.getEinmalAbo(film.arr[6]);
            if (abo != null) {
                ret = true;
                name = abo.arr[1];
                abo.arr[10] = Boolean.toString(true);
                this.daten.fehler.systemMeldung("StarterClass.einmalErledigen Abo: " + name);
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "StarterClass.einmalErledigen Abo: " + name);
        }
        return ret;
    }

    private boolean pruefen(Starts starts) {
        boolean ret = false;
        String logfile = "";
        if (starts.quelle == 2) {
            logfile = ".mediathek_zdf_log";
        } else if (starts.quelle == 3) {
            logfile = ".mediathek_podder_log";
        }
        File file = new File(starts.film.arr[14]);
        if (!file.exists()) {
            this.daten.fehler.fehlerMeldung("Fehler!", "Download fehlgeschlagen: " + starts.film.arr[14]);
        } else if (file.length() < 2048L) {
            this.daten.fehler.fehlerMeldung("Fehler!", "Download fehlgeschlagen: " + starts.film.arr[14]);
        } else {
            if (!this.einmalErledigen(starts.film)) {
                this.daten.log.zeileSchreiben(starts.film.arr[3], starts.film.arr[6], logfile);
            }
            ret = true;
        }
        return ret;
    }

    private class StartenDonwnload
    implements Runnable {
        Starts starts;

        public StartenDonwnload(Starts s) {
            this.starts = s;
            this.starts.status = 2;
            StarterClass.this.notifyStartEvent();
        }

        @Override
        public void run() {
            InputStream input = null;
            FileOutputStream destStream = null;
            try {
                int len;
                new File(this.starts.film.arr[13]).mkdirs();
                URL feedUrl = new URL(this.starts.film.arr[6]);
                input = feedUrl.openStream();
                byte[] buffer = new byte[1024];
                destStream = new FileOutputStream(this.starts.film.arr[14]);
                while ((len = input.read(buffer)) != -1) {
                    ((OutputStream)destStream).write(buffer, 0, len);
                    if (!StarterClass.this.allesStop && !this.starts.stoppen) continue;
                }
                input.close();
                ((OutputStream)destStream).close();
            }
            catch (Exception e) {
                ((StarterClass)StarterClass.this).daten.fehler.fehlerMeldung(e, "StarterClass.StartenDonwnload-1");
            }
            try {
                if (StarterClass.this.allesStop || this.starts.stoppen) {
                    new File(this.starts.film.arr[14]).delete();
                } else {
                    this.starts.status = this.starts.quelle == 1 ? 3 : (StarterClass.this.pruefen(this.starts) ? 3 : 4);
                }
            }
            catch (Exception e) {
                ((StarterClass)StarterClass.this).daten.fehler.fehlerMeldung(e, "StarterClass.StartenDonwnload-2");
            }
            StarterClass.this.notifyStartEvent();
        }
    }

    private class StartenProgramm
    implements Runnable {
        Starts starts;
        RuntimeExec runtimeExec;

        public StartenProgramm(Starts s) {
            this.starts = s;
            this.starts.status = 2;
            StarterClass.this.notifyStartEvent();
            try {
                new File(this.starts.film.arr[13]).mkdirs();
            }
            catch (Exception ex) {
                ((StarterClass)StarterClass.this).daten.fehler.fehlerMeldung(ex, "StarterClass.ZdfStarten.run");
            }
        }

        @Override
        public synchronized void run() {
            int k = 0;
            long filesize = -1L;
            boolean restart = false;
            boolean startOk = false;
            try {
                if (this.starten()) {
                    restart = true;
                }
                while (restart && !this.starts.stoppen) {
                    startOk = false;
                    restart = false;
                    while (!StarterClass.this.allesStop && !this.starts.stoppen) {
                        try {
                            k = this.starts.process.exitValue();
                            break;
                        }
                        catch (Exception ex) {
                            try {
                                this.wait(2000L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (StarterClass.this.allesStop || this.starts.stoppen) {
                        if (this.starts.process == null) continue;
                        this.starts.process.destroy();
                        this.starts.status = this.starts.quelle == 1 ? 3 : 1;
                        new File(this.starts.film.arr[14]).delete();
                        continue;
                    }
                    if (k != 0) {
                        if (this.starts.restart) {
                            File file;
                            if (filesize == -1L) {
                                file = new File(this.starts.film.arr[14]);
                                if (file.exists()) {
                                    filesize = file.length();
                                    startOk = true;
                                } else if (this.starts.startcounter < 3) {
                                    startOk = true;
                                }
                            } else {
                                file = new File(this.starts.film.arr[14]);
                                if (file.exists() && file.length() > filesize) {
                                    startOk = true;
                                    filesize = file.length();
                                }
                            }
                            if (startOk && this.starten()) {
                                restart = true;
                                continue;
                            }
                            this.starts.status = 4;
                            continue;
                        }
                        this.starts.status = 4;
                        continue;
                    }
                    if (this.starts.quelle == 1) {
                        this.starts.status = 3;
                        continue;
                    }
                    if (StarterClass.this.pruefen(this.starts)) {
                        this.starts.status = 3;
                        continue;
                    }
                    this.starts.status = 4;
                }
            }
            catch (Exception ex) {
                ((StarterClass)StarterClass.this).daten.fehler.fehlerMeldung(ex, "StarterClass.StartenProgramm");
            }
            StarterClass.this.notifyStartEvent();
        }

        private boolean starten() {
            boolean ret = true;
            this.runtimeExec = new RuntimeExec(StarterClass.this.daten, this.starts);
            this.starts.process = this.runtimeExec.exec();
            if (this.starts.process == null) {
                this.starts.status = 4;
                ret = false;
            } else {
                ++this.starts.startcounter;
            }
            return ret;
        }
    }

    private class Starten
    implements Runnable {
        Starts starts;

        private Starten() {
        }

        @Override
        public synchronized void run() {
            block6: while (true) {
                try {
                    while (true) {
                        if ((this.starts = StarterClass.this.getListe()) != null) {
                            switch (this.starts.art) {
                                case 2: {
                                    StartenProgramm zdfStarten = new StartenProgramm(this.starts);
                                    new Thread(zdfStarten).start();
                                    this.wait(10000L);
                                    continue block6;
                                }
                                case 1: {
                                    StartenDonwnload podderStart = new StartenDonwnload(this.starts);
                                    new Thread(podderStart).start();
                                    this.wait(2000L);
                                    continue block6;
                                }
                            }
                            ((StarterClass)StarterClass.this).daten.fehler.fehlerMeldung("Fehler!", "StarterClass.Starten - Switch-default");
                            continue;
                        }
                        StarterClass.this.buttonStartsPutzen();
                        this.wait(3000L);
                    }
                }
                catch (Exception ex) {
                    ((StarterClass)StarterClass.this).daten.fehler.fehlerMeldung(ex, "StarterClass.Starten.run");
                    continue;
                }
                break;
            }
        }
    }
}

