/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mediathek.Funktionen;
import mediathek.TModelAbo;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.gui.dialoge.DialogEditAbo;
import org.apache.commons.lang.StringEscapeUtils;

public class ListeAbo
extends LinkedList<DatenAbo> {
    Daten daten;
    private int nr = 0;

    public ListeAbo(Daten ddaten) {
        this.daten = ddaten;
    }

    public boolean addAbo(String sender, String thema, boolean exakt, String text) {
        boolean ret = false;
        DatenAbo datenAbo = new DatenAbo(thema, sender, thema, exakt, text, thema, "");
        DialogEditAbo dialogEditAbo = new DialogEditAbo(null, true, this.daten, datenAbo);
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok) {
            if (!this.aboSuchen(datenAbo.arr[2], datenAbo.arr[3], Boolean.parseBoolean(datenAbo.arr[4]), datenAbo.arr[5])) {
                this.addAbo(datenAbo);
                this.sort();
                ret = true;
            } else {
                JOptionPane.showMessageDialog(null, "Abo existiert bereits", "Abo anlegen", 1);
            }
        }
        return ret;
    }

    public boolean addEinmalAbo(String sender, String thema, String text, String url) {
        boolean ret = false;
        DatenAbo datenAbo = new DatenAbo(thema, sender, thema, true, text, thema, "");
        datenAbo.arr[9] = url;
        DialogEditAbo dialogEditAbo = new DialogEditAbo(null, true, this.daten, datenAbo);
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok) {
            if (!this.einmalAboSuchen(datenAbo.arr[9])) {
                this.addAbo(datenAbo);
                this.sort();
                ret = true;
            } else {
                JOptionPane.showMessageDialog(null, "Abo existiert bereits", "Abo anlegen", 1);
            }
        }
        return ret;
    }

    public void erledigteEinmalAboLoeschen() {
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            DatenAbo abo = (DatenAbo)it.next();
            if (!abo.binEinmal() || !Boolean.parseBoolean(abo.arr[10])) continue;
            it.remove();
        }
    }

    public void aboLoeschen(DatenAbo abo) {
        if (abo != null) {
            this.remove(abo);
        }
    }

    public void addAbo(DatenAbo datenAbo) {
        String str = String.valueOf(this.nr++);
        while (str.length() < 3) {
            str = "0" + str;
        }
        datenAbo.arr[0] = str;
        if (datenAbo.arr[4].equals("")) {
            datenAbo.arr[4] = Boolean.toString(true);
        }
        super.add(datenAbo);
    }

    public DatenAbo getAboNr(int i) {
        return (DatenAbo)this.get(i);
    }

    public void sort() {
        Collections.sort(this);
    }

    public void addObjectData(TModelAbo model) {
        model.setRowCount(0);
        ListIterator iterator = this.listIterator();
        Object[] object = new Object[11];
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            for (int m = 0; m < 11; ++m) {
                object[m] = m == 7 ? Funktionen.getDatumForObject(datenAbo.arr[7]) : datenAbo.arr[m];
            }
            model.addRow(object);
        }
    }

    public boolean aboSuchen(String sender, String thema, boolean exakt, String text) {
        boolean ret = false;
        DatenAbo abo2 = null;
        for (DatenAbo abo2 : this) {
            if (!abo2.arr[2].equalsIgnoreCase(sender) || !abo2.arr[3].equalsIgnoreCase(thema) || !abo2.arr[5].equalsIgnoreCase(text) || !Boolean.parseBoolean(abo2.arr[4]) || !exakt) continue;
            ret = true;
        }
        return ret;
    }

    public boolean einmalAboSuchen(String url) {
        if (url.equals("")) {
            return false;
        }
        boolean ret = false;
        DatenAbo abo2 = null;
        for (DatenAbo abo2 : this) {
            if (!abo2.arr[9].equals(url)) continue;
            ret = true;
        }
        return ret;
    }

    public boolean aboExists(String sender, String thema) {
        thema = StringEscapeUtils.unescapeHtml(thema.trim());
        boolean ret = false;
        if (this.getAbo(sender, thema, "", "") != null) {
            ret = true;
        }
        return ret;
    }

    public static boolean isPattern(String textSuchen) {
        return textSuchen.startsWith("#:");
    }

    public static Pattern makePattern(String textSuchen) {
        Pattern p = null;
        try {
            if (ListeAbo.isPattern(textSuchen)) {
                p = Pattern.compile(textSuchen.substring(2));
            }
        }
        catch (Exception ex) {
            p = null;
        }
        return p;
    }

    public static boolean aboPruefen(String senderSuchen, String themaSuchen, boolean themaExakt, String textSuchen, String imSender, String imThema, String imText) {
        Pattern p1 = ListeAbo.makePattern(themaSuchen);
        boolean ret = false;
        if (senderSuchen.equals("") || imSender.equalsIgnoreCase(senderSuchen)) {
            if (p1 != null) {
                if (p1.matcher(imThema).matches()) {
                    ret = ListeAbo.textPruefen(textSuchen, imText);
                }
            } else if (themaSuchen.equals("") || themaExakt && imThema.equalsIgnoreCase(themaSuchen) || !themaExakt && imThema.toLowerCase().contains(themaSuchen.toLowerCase())) {
                ret = ListeAbo.textPruefen(textSuchen, imText);
            }
        }
        return ret;
    }

    private static boolean textPruefen(String textSuchen, String imText) {
        Pattern p = ListeAbo.makePattern(textSuchen);
        boolean ret = false;
        if (p != null) {
            ret = p.matcher(imText).matches();
        } else if (textSuchen.equals("") || imText.toLowerCase().contains(textSuchen.toLowerCase())) {
            ret = true;
        }
        return ret;
    }

    public DatenAbo getAbo(String sender, String thema, String text, String url) {
        DatenAbo datenAbo = null;
        ListIterator it = this.listIterator();
        if (sender.equals("") && thema.equals("") && text.equals("") && url.equals("")) {
            this.daten.fehler.fehlerMeldung("Abo", "Leeres Abo!");
        } else {
            while (it.hasNext()) {
                datenAbo = (DatenAbo)it.next();
                if (!(!datenAbo.arr[9].equals("") ? datenAbo.arr[9].equals(url) : ListeAbo.aboPruefen(datenAbo.arr[2], datenAbo.arr[3], Boolean.parseBoolean(datenAbo.arr[4]), datenAbo.arr[5], sender, thema, text))) continue;
                return datenAbo;
            }
        }
        return null;
    }

    public DatenAbo getEinmalAbo(String url) {
        DatenAbo datenAbo = null;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            datenAbo = (DatenAbo)it.next();
            if (url.equals("") || !datenAbo.arr[9].equals(url)) continue;
            return datenAbo;
        }
        return null;
    }
}

