/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filme;

import java.io.File;
import mediathek.Funktionen;
import mediathek.GermanStringSorter;
import mediathek.daten.Daten;

public class DatenFilm
implements Comparable<DatenFilm> {
    Daten daten;
    public String[] arr;
    public boolean thema = false;

    public DatenFilm(Daten ddaten) {
        this.daten = ddaten;
        this.makeArr();
    }

    public DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String datum, String zeit) {
        this.daten = ddaten;
        this.makeArr();
        this.arr[1] = ssender;
        this.arr[2] = tthema;
        this.arr[3] = ttitel;
        this.arr[6] = uurl;
        this.arr[4] = Funktionen.checkDatum(this.daten, datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[5] = Funktionen.checkZeit(this.daten, this.arr[4], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[10] = urlThema;
        this.arr[16] = Boolean.toString(false);
    }

    public DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String uurlRtmp, String datum, String zeit, boolean alt) {
        this.daten = ddaten;
        this.makeArr();
        this.arr[1] = ssender;
        this.arr[2] = tthema;
        this.arr[3] = ttitel;
        this.arr[6] = uurl;
        this.arr[7] = uurlorg;
        this.arr[8] = uurlRtmp;
        this.arr[10] = urlThema;
        this.arr[4] = Funktionen.checkDatum(this.daten, datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[5] = Funktionen.checkZeit(this.daten, this.arr[4], zeit, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[16] = Boolean.toString(alt);
    }

    public DatenFilm(Daten ddaten, String ssender, String tthema, String ttitel, String uurl, String zielPfad, String datum) {
        this.daten = ddaten;
        this.makeArr();
        this.arr[1] = ssender;
        this.arr[2] = tthema;
        this.arr[3] = ttitel;
        this.arr[6] = uurl;
        this.arr[13] = zielPfad;
        this.arr[4] = Funktionen.checkDatum(this.daten, datum, this.arr[1] + " " + this.arr[2] + " " + this.arr[3]);
        this.arr[16] = Boolean.toString(false);
    }

    public DatenFilm getClean() {
        DatenFilm ret = new DatenFilm(this.daten);
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        ret.arr[0] = "";
        ret.arr[15] = "";
        ret.arr[11] = "";
        ret.arr[12] = "";
        ret.arr[13] = "";
        ret.arr[14] = "";
        ret.arr[17] = "";
        return ret;
    }

    public DatenFilm getCopy() {
        DatenFilm ret = new DatenFilm(this.daten);
        for (int i = 0; i < this.arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        return ret;
    }

    public String dateiNamenBauen(String pfad, String name) {
        if (!name.equals("")) {
            name = name.replace("%D", this.arr[4].equals("") ? Funktionen.getHeute_yyyyMMdd() : Funktionen.datumDatumZeitReinigen(Funktionen.datumDrehen(this.arr[4])));
            name = name.replace("%d", this.arr[5].equals("") ? Funktionen.getJetzt_HHMMSS() : Funktionen.datumDatumZeitReinigen(this.arr[5]));
            name = name.replace("%l", this.arr[0]);
            name = name.replace("%t", this.arr[2]);
            name = name.replace("%T", this.arr[3]);
            name = name.replace("%s", this.arr[1]);
            name = name.replace("%n", Funktionen.getDateiName(this.daten, this.arr[6]));
            name = name.replace("%N", Funktionen.getDateiName(this.daten, this.arr[6]));
            name = name.replace("%H", Funktionen.getHeute_yyyyMMdd());
            name = name.replace("%h", Funktionen.getJetzt_HHMMSS());
            this.arr[12] = Funktionen.replaceLeerDateiname(name, true);
        } else {
            this.arr[12] = Funktionen.replaceLeerDateiname(Funktionen.getDateiName(this.daten, this.arr[6]), true);
        }
        this.arr[13] = pfad.endsWith(File.separator) ? pfad.substring(0, pfad.length() - 1) : pfad;
        this.arr[14] = Funktionen.addsPfad(this.daten, pfad, this.arr[12]);
        return this.arr[14];
    }

    @Override
    public int compareTo(DatenFilm arg0) {
        int ret = 0;
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        ret = sorter.compare(this.arr[1], arg0.arr[1]);
        if (ret == 0) {
            ret = sorter.compare(this.arr[2], arg0.arr[2]);
        }
        return ret;
    }

    public void flvstreamerAendern() {
        this.arr[6] = Boolean.parseBoolean(this.daten.system[19]) ? this.getUrlFlvstreamer() : this.getUrlOrg();
    }

    public String getUrlOrg() {
        return DatenFilm.getUrlOrg(this.arr[8], this.arr[7], this.arr[6]);
    }

    public static String getUrlOrg(String url_rtmp, String url_org, String url) {
        String ret = "";
        ret = !url_rtmp.equals("") ? url_org : (url.startsWith("-r ") ? url.substring("-r ".length()) : url);
        return ret;
    }

    public String getUrlFlvstreamer() {
        String ret = "";
        ret = !this.arr[8].equals("") ? this.arr[8] : (this.arr[6].startsWith("rtmp") ? "-r " + this.arr[6] : this.arr[6]);
        return ret;
    }

    private void makeArr() {
        this.arr = new String[18];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
    }
}

