/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filme;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Funktionen;
import mediathek.TModelFilm;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.daten.Datum;
import mediathek.daten.ListeAbo;
import mediathek.filme.DatenFilm;
import org.apache.commons.lang.StringEscapeUtils;

public class ListeFilme
extends LinkedList<DatenFilm> {
    private Daten daten;
    private int nr = 0;
    private final int MAX_STELLEN = 6;
    private final String FUELL_ZEICHEN = "0";
    private SimpleDateFormat sdf_datum_zeit = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
    private SimpleDateFormat sdf_datum = new SimpleDateFormat("dd.MM.yyyy");

    public ListeFilme(Daten ddaten) {
        this.daten = ddaten;
    }

    @Override
    public synchronized void clear() {
        this.nr = 0;
        super.clear();
    }

    public void sort() {
        Collections.sort(this);
    }

    @Override
    public synchronized boolean add(DatenFilm film) {
        String str = String.valueOf(this.nr++);
        while (str.length() < 6) {
            str = "0" + str;
        }
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml(film.arr[3].trim());
        film.arr[0] = str;
        film.flvstreamerAendern();
        film = this.leitungAendern(film);
        return super.add(film);
    }

    public synchronized boolean superAdd(DatenFilm film) {
        return super.add(film);
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenFilm)it.next()).arr[1].equalsIgnoreCase(sender)) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized void delOhneSender(String sender) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public synchronized void getModelTabFilme(TModelFilm modelFilm, String filterSender, String filterThema, boolean filterExakt, String filterText) {
        modelFilm.setRowCount(0);
        if (this.size() == 0) {
            return;
        }
        ListeFilme liste = new ListeFilme(this.daten);
        Iterator it = this.iterator();
        boolean nixFiltern = false;
        if (filterSender.equals("") && filterThema.equals("") && filterText.equals("")) {
            nixFiltern = true;
        }
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (nixFiltern) {
                liste.superAdd(film);
                continue;
            }
            if (!ListeAbo.aboPruefen(filterSender, filterThema, filterExakt, filterText, film.arr[1], film.arr[2], film.arr[3])) continue;
            liste.superAdd(film);
        }
        liste.addObjectDataTabFilme(modelFilm);
    }

    public synchronized TModelFilm addAboModel(TModelFilm modelFilm) {
        this.addAboObjectData(modelFilm);
        return modelFilm;
    }

    public synchronized TModelFilm addPodModel(TModelFilm model) {
        model.setRowCount(0);
        this.addPodObjectData(model);
        return model;
    }

    public synchronized String[] getModelOfField(int feld, String filterString, int filterFeld) {
        HashSet<String> tree = new HashSet<String>();
        String str = "";
        tree.add("");
        Iterator it = this.iterator();
        if (filterString.equals("")) {
            while (it.hasNext()) {
                str = ((DatenFilm)it.next()).arr[feld];
                if (tree.contains(str)) continue;
                tree.add(str);
            }
        } else {
            while (it.hasNext()) {
                DatenFilm film = (DatenFilm)it.next();
                str = film.arr[feld];
                if (!film.arr[filterFeld].equalsIgnoreCase(filterString) || tree.contains(str)) continue;
                tree.add(str);
            }
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String h : tree) {
            list.add(h);
        }
        Funktionen.listeSort(list);
        String[] ret = new String[]{};
        ret = list.toArray(ret);
        return ret;
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        DatenFilm ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm f = (DatenFilm)it.next();
            if (!f.arr[6].equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    private void addObjectDataTabFilme(TModelFilm model) {
        Object[] object = null;
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            while (iterator.hasNext()) {
                DatenFilm film = (DatenFilm)iterator.next();
                DatenAbo datenAbo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3], film.arr[6]);
                film.arr[17] = datenAbo != null ? datenAbo.arr[1] : "";
                object = new Object[18];
                for (int m = 0; m < 18; ++m) {
                    object[m] = m == 4 ? this.getDatumForObject(film) : film.arr[m];
                }
                model.addRow(object);
            }
        }
    }

    private Datum getDatumForObject(DatenFilm film) {
        Datum tmp = new Datum(0L);
        if (!film.arr[4].equals("")) {
            try {
                if (!film.arr[5].equals("")) {
                    tmp.setTime(this.sdf_datum_zeit.parse(film.arr[4] + film.arr[5]).getTime());
                } else {
                    tmp.setTime(this.sdf_datum.parse(film.arr[4]).getTime());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }

    private void addAboObjectData(TModelFilm model) {
        DatenFilm film;
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[] object = null;
        model.setRowCount(0);
        ListIterator itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            film = (DatenFilm)itFilm.next();
            DatenAbo abo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3], film.arr[6]);
            if (abo == null || (!abo.binEinmal() || Boolean.parseBoolean(abo.arr[10])) && this.daten.log.urlPruefen(film.arr[6], ".mediathek_zdf_log")) continue;
            abo.arr[7] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
            this.daten.setGeaendert();
            if (this.checkListe(liste, film.arr[6])) {
                if (!ListeAbo.aboPruefen(abo.arr[2], abo.arr[3], Boolean.parseBoolean(abo.arr[4]), abo.arr[5], film.arr[1], film.arr[2], film.arr[3])) continue;
                this.loeschenInListe(liste, film.arr[6]);
                this.inListeEintragen(liste, abo, film);
                continue;
            }
            this.inListeEintragen(liste, abo, film);
        }
        if (liste.size() > 0) {
            object = new Object[18];
            itFilm = liste.listIterator();
            while (itFilm.hasNext()) {
                film = (DatenFilm)itFilm.next();
                DatenAbo datenAbo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3], film.arr[6]);
                if (datenAbo != null) {
                    film.arr[17] = datenAbo.arr[1];
                }
                for (int m = 0; m < 18; ++m) {
                    object[m] = m == 4 ? this.getDatumForObject(film) : film.arr[m];
                }
                model.addRow(object);
            }
        }
    }

    private void inListeEintragen(LinkedList<DatenFilm> liste, DatenAbo abo, DatenFilm film) {
        String zielPfad = "";
        String zielDateiname = "";
        DatenPgruppe gruppe = this.daten.listePgruppeAbo.getName(abo.arr[8]);
        if (gruppe != null) {
            DatenProg datenProg = gruppe.getProgUrl(film.arr[6]);
            if (datenProg != null) {
                film.arr[15] = gruppe.checkDownloadDirekt(this.daten, film.arr[6]) == 1 ? "direkter Download" : datenProg.arr[0];
            }
            zielDateiname = gruppe.getZielDateiname();
            zielPfad = gruppe.getZielPfad();
        }
        zielPfad = abo.aboPfadAnhaengen(this.daten, zielPfad);
        zielDateiname = film.dateiNamenBauen(zielPfad, zielDateiname);
        liste.add(film);
    }

    private TModelFilm addPodObjectData(TModelFilm model) {
        DatenFilm film;
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[] object = null;
        model.setRowCount(0);
        ListIterator itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            film = (DatenFilm)itFilm.next();
            String zielpfad = this.daten.listePod.getZiel(film.arr[2]);
            if (zielpfad == null || this.daten.log.urlPruefen(film.arr[6], ".mediathek_podder_log") || this.checkListe(liste, film.arr[6])) continue;
            zielpfad = Funktionen.addsPfad(this.daten, this.daten.system[11], zielpfad);
            film.dateiNamenBauen(zielpfad, Funktionen.getDateiName(this.daten, film.arr[6]));
            liste.add(film);
        }
        if (liste.size() > 0) {
            object = new Object[18];
            itFilm = liste.listIterator();
            while (itFilm.hasNext()) {
                film = (DatenFilm)itFilm.next();
                for (int m = 0; m < 18; ++m) {
                    object[m] = m == 4 ? this.getDatumForObject(film) : film.arr[m];
                }
                model.addRow(object);
            }
        }
        return model;
    }

    private boolean checkListe(LinkedList<DatenFilm> liste, String url) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (!url.equals(film.arr[6])) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void loeschenInListe(LinkedList<DatenFilm> liste, String url) {
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (!url.equals(film.arr[6])) continue;
            it.remove();
            break;
        }
    }

    private DatenFilm leitungAendern(DatenFilm film) {
        if (Boolean.parseBoolean(this.daten.system[18])) {
            film = film.getCopy();
            if (film.arr[1].equalsIgnoreCase("3Sat")) {
                film.arr[6] = film.arr[6].replace("/veryhigh/", "/300/");
            } else if (film.arr[1].equalsIgnoreCase("ZDF")) {
                film.arr[6] = film.arr[6].replace("/veryhigh/", "/300/");
            } else if (film.arr[1].equalsIgnoreCase("NDR")) {
                film.arr[6] = film.arr[6].replace(".hq.", ".lo.");
            }
        }
        return film;
    }
}

