/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.daten.Daten;
import mediathek.filme.BeobFilmeLaden;

public class MediathekNoGui {
    private Daten daten;
    private Date startZeit = new Date(System.currentTimeMillis());
    private Date stopZeit = null;
    private String output = "";

    public MediathekNoGui(String[] ar) {
        boolean debug = false;
        boolean update = false;
        String pfad = "";
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-D")) {
                    debug = true;
                }
                if (ar[i].equals("-update")) {
                    update = true;
                }
                if (!ar[i].equalsIgnoreCase("-o") || ar.length <= i) continue;
                this.output = ar[i + 1];
            }
        }
        this.daten = new Daten(pfad, debug, null, true);
        this.daten.allesLaden = !update;
        this.daten.fehlerFensterAnzeigen = false;
        System.out.println("");
        System.out.println("========================================");
        if (this.daten.allesLaden) {
            System.out.println("Laden: alles");
        } else {
            System.out.println("Laden: nur update");
        }
        System.out.println("========================================");
        System.out.println("");
        this.initListener();
        this.daten.filmeLaden.filmeBeimSenderLaden();
    }

    private void initListener() {
        this.daten.filmeLaden.addAdListener(new BeobachterLadenFilme());
    }

    private void undTschuess() {
        this.daten.speichern();
        if (!this.output.equals("")) {
            LinkedList<String> out = new LinkedList<String>();
            String tmp = "";
            do {
                if (this.output.startsWith(",")) {
                    this.output = this.output.substring(1);
                }
                if (this.output.contains(",")) {
                    tmp = this.output.substring(0, this.output.indexOf(","));
                    this.output = this.output.substring(this.output.indexOf(","));
                    out.add(tmp);
                    continue;
                }
                out.add(this.output);
            } while (this.output.contains(","));
            Iterator it = out.iterator();
            while (it.hasNext()) {
                this.daten.ioXmlSchreiben.exportFilme((String)it.next());
            }
        }
        this.stopZeit = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        int minuten = 0;
        try {
            minuten = Math.round((this.stopZeit.getTime() - this.startZeit.getTime()) / 60000L);
        }
        catch (Exception ex) {
            minuten = -1;
        }
        System.out.println("");
        System.out.println("========================================");
        System.out.println("  " + this.daten.filmeLaden.getSeitenZaehlerLauf() + " Seiten geladen");
        System.out.println("  " + this.daten.filmeLaden.listeFilmeSchattenliste.size() + " Filme gesamt");
        System.out.println("  --> Beginn: " + sdf.format(this.startZeit));
        System.out.println("  --> Fertig: " + sdf.format(this.stopZeit));
        System.out.println("  --> Dauer[Min]: " + minuten);
        System.out.println("========================================");
        if (this.daten.filmeLaden.listeFilmeSchattenliste.isEmpty()) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    private synchronized void progressBar(int max, int progress) {
        int proz = 0;
        String text = "";
        if (max != 0) {
            int i;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            if (max > 0 && proz == 100) {
                proz = 99;
            }
            text = "  [ ";
            int a = proz / 10;
            for (i = 0; i < a; ++i) {
                text = text + "#";
            }
            for (i = 0; i < 10 - a; ++i) {
                text = text + "-";
            }
            text = text + " ]  " + this.daten.filmeLaden.getSeitenZaehlerLauf() + " Seiten  /  " + proz + "% von " + max + " Themen  /  Filme: " + this.daten.filmeLaden.listeFilmeSchattenliste.size() + "\r";
            this.daten.fehler.progressMeldung(text);
        }
    }

    private class BeobachterLadenFilme
    extends BeobFilmeLaden {
        private BeobachterLadenFilme() {
        }

        @Override
        public void initProgressBar(String sender, int threads, int max, int progress, String text) {
            MediathekNoGui.this.progressBar(max, progress);
        }

        @Override
        public void beenden() {
            MediathekNoGui.this.undTschuess();
        }
    }
}

