/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.beobachter.EscBeenden;
import mediathek.daten.Daten;
import mediathek.daten.DatenPod;

public class DialogPod
extends JDialog {
    private Daten daten;
    public boolean ok = false;
    public DatenPod aktPod;
    private JTextField[] textfeldListe;
    private JButton jButtonAbbrechen;
    private JButton jButtonOk;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelExtra;

    public DialogPod(Frame parent, boolean modal, Daten d, DatenPod aaktPod) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Einstellungen Podcast");
        this.daten = d;
        this.aktPod = aaktPod;
        this.setExtra();
        this.pack();
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPod.this.check();
                DialogPod.this.beenden();
            }
        });
        this.jButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPod.this.beenden();
            }
        });
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogPod.this.beenden();
            }
        };
    }

    private void beenden() {
        this.dispose();
    }

    private void check() {
        this.daten.setGeaendert();
        this.ok = true;
        this.aktPod.arr[3] = Funktionen.replaceLeerDateiname(this.aktPod.arr[3], false);
    }

    private void setExtra() {
        this.textfeldListe = new JTextField[5];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < 5; ++i) {
            if (i == 4 || i == 0) continue;
            this.addExtraFeld(i, gridbag, c, this.jPanelExtra, this.aktPod.arr);
            c.gridy = ++zeile;
        }
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c, JPanel panel, String[] item) {
        JTextField textfeld;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel label = new JLabel(Konstanten.POD_COLUMN_NAMES[i] + ": ");
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridx = 1;
        c.weightx = 10.0;
        this.textfeldListe[i] = textfeld = new JTextField();
        if (i == 0) {
            textfeld.setEditable(false);
        }
        textfeld.setText(item[i]);
        textfeld.setMinimumSize(new Dimension(200, 0));
        textfeld.getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
        gridbag.setConstraints(textfeld, c);
        panel.add(textfeld);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanelExtra = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.jPanelExtra.setBorder(new SoftBevelBorder(1));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 456, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 71, Short.MAX_VALUE));
        this.jButtonOk.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelExtra, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButtonAbbrechen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOk, -2, 93, -2))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk, -2, 27, -2).addComponent(this.jButtonAbbrechen)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private class BeobachterDocumentTextfeld
    implements DocumentListener {
        int nr;

        public BeobachterDocumentTextfeld(int n) {
            this.nr = n;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            DialogPod.this.aktPod.arr[this.nr] = DialogPod.this.textfeldListe[this.nr].getText();
        }
    }
}

