/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.daten.DatenPod;
import mediathek.filme.DatenFilm;
import mediathek.filme.FilmListener;
import mediathek.filme.ListeFilme;

public class FeedReaderPods {
    final int MAX_THREAD_LADEN_PODCAST = 5;
    final int TIMEOUT = 5000;
    private Daten daten;
    private boolean stop;
    private EventListenerList listeners = new EventListenerList();
    private ListeFilme liste;
    private int threads = 0;
    private Iterator<DatenPod> itPod;

    public FeedReaderPods(Daten d) {
        this.daten = d;
        this.liste = new ListeFilme(this.daten);
        this.listeners = new EventListenerList();
    }

    public boolean starten() {
        boolean ret = this.daten.listePod.size() > 0;
        this.threads = 0;
        this.stop = false;
        this.liste.clear();
        this.notifyStart(this.daten.listePod.size());
        this.itPod = this.daten.listePod.iterator();
        for (int t = 0; t < 5; ++t) {
            ++this.threads;
            new Thread(new PodSuchen()).start();
        }
        return ret;
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    public void stoppen() {
        this.stop = true;
    }

    public ListeFilme getListe() {
        return this.liste;
    }

    private synchronized DatenPod getPod() {
        if (this.itPod.hasNext()) {
            return this.itPod.next();
        }
        return null;
    }

    private synchronized void addListe(DatenFilm film) {
        this.liste.add(film);
    }

    private void downloadPods(DatenPod pod, String podcast, String strUrl, ListeFilme liste, String zielPfad) {
        try {
            URL feedUrl = new URL(strUrl);
            URLConnection conn = feedUrl.openConnection();
            conn.setRequestProperty("User-Agent", this.daten.system[3]);
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(5000);
            XmlReader xmlReader = new XmlReader(conn.getInputStream());
            SyndFeed feed = new SyndFeedInput().build(xmlReader);
            Iterator entryIter = feed.getEntries().iterator();
            while (!this.stop && entryIter.hasNext()) {
                SyndEntry entry = (SyndEntry)entryIter.next();
                Iterator it = entry.getEnclosures().iterator();
                while (!this.stop && it.hasNext()) {
                    SyndEnclosure sEnc = (SyndEnclosure)it.next();
                    if (!this.daten.system[11].endsWith(File.separator)) {
                        this.daten.system[11] = this.daten.system[11] + File.separator;
                    }
                    if (zielPfad.startsWith(File.separator)) {
                        zielPfad = zielPfad.substring(1);
                    }
                    if (!zielPfad.endsWith(File.separator)) {
                        zielPfad = zielPfad + File.separator;
                    }
                    zielPfad = this.daten.system[11] + zielPfad;
                    String url = sEnc.getUrl();
                    String datum = "";
                    Date date = entry.getPublishedDate();
                    if (date != null) {
                        SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
                        datum = sdfOut.format(date);
                    }
                    if (this.daten.log.urlPruefen(url, ".mediathek_podder_log") || this.listeContainUrl(liste, url)) continue;
                    DatenFilm film = new DatenFilm(this.daten, "Podcast", podcast, entry.getTitle(), url, zielPfad, datum);
                    film.arr[11] = Funktionen.getDateiName(this.daten, film.arr[6]);
                    liste.add(film);
                    pod.arr[4] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                    this.daten.setGeaendert();
                }
            }
        }
        catch (Exception e) {
            String[] str = new String[]{e.getMessage(), "Podcast:  " + podcast, "Url:      " + strUrl};
            this.daten.fehler.fehlerMeldung("Fehler!", str);
        }
    }

    private boolean listeContainUrl(ListeFilme liste, String str) {
        boolean ret = false;
        ListIterator it = liste.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenFilm)it.next()).arr[6].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void notifyStart(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start("Podcast", max);
        }
    }

    private void notifyProgress(String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress("Podcast", text);
        }
    }

    private void notifyFertig() {
        if (this.threads <= 0) {
            for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
                l.fertig("Podcast", this.stop);
            }
        }
    }

    private class PodSuchen
    implements Runnable {
        private PodSuchen() {
        }

        @Override
        public synchronized void run() {
            DatenPod pod;
            ListeFilme list = new ListeFilme(FeedReaderPods.this.daten);
            while (!FeedReaderPods.this.stop && (pod = FeedReaderPods.this.getPod()) != null) {
                FeedReaderPods.this.downloadPods(pod, pod.arr[1], pod.arr[2], list, pod.arr[3]);
                FeedReaderPods.this.notifyProgress(pod.arr[2]);
            }
            Iterator itPod = list.iterator();
            while (itPod.hasNext()) {
                FeedReaderPods.this.addListe((DatenFilm)itPod.next());
            }
            --FeedReaderPods.this.threads;
            FeedReaderPods.this.notifyFertig();
        }
    }
}

