/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.EventListenerList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenPod;
import mediathek.daten.DatenPodster;
import mediathek.daten.DatenProg;
import mediathek.filme.DatenFilm;
import mediathek.filme.FilmListener;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class IoXmlLesen {
    private XMLOutputFactory outFactory;
    private XMLStreamWriter writer;
    private OutputStreamWriter out = null;
    ZipOutputStream zipOutputStream = null;
    BZip2CompressorOutputStream bZip2CompressorOutputStream = null;
    private Daten daten;
    EventListenerList listeners = new EventListenerList();
    public boolean stop = false;

    public IoXmlLesen(Daten d) {
        this.daten = d;
        this.stop = false;
        this.xmlDatenLesen();
        this.xmlDatenLesenFilme();
        if (!this.daten.noGui) {
            this.xmlDatenLesenPodster();
        }
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importDatenFilme(String datei, boolean istDatei) {
        this.stop = false;
        this.notifyStart(1);
        this.notifyProgress(datei);
        boolean ret = true;
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        XMLStreamReader parser = null;
        InputStreamReader inReader = null;
        BZip2CompressorInputStream bZip2CompressorInputStream = null;
        String user_agent = this.daten.system[3];
        int timeout = 10000;
        URLConnection conn = null;
        try {
            ZipInputStream zipInputStream;
            if (istDatei) {
                if (datei.endsWith(".bz2")) {
                    bZip2CompressorInputStream = new BZip2CompressorInputStream(new FileInputStream(datei));
                    inReader = new InputStreamReader((InputStream)bZip2CompressorInputStream, "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(new FileInputStream(datei));
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                }
            } else {
                conn = new URL(datei).openConnection();
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
                conn.setRequestProperty("User-Agent", user_agent);
                if (datei.endsWith(".bz2")) {
                    File tmpFile = File.createTempFile("mediathek", null);
                    tmpFile.deleteOnExit();
                    BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                    FileOutputStream fOut = new FileOutputStream(tmpFile);
                    byte[] buffer = new byte[100];
                    int n = 0;
                    int count = 0;
                    this.addMax(99);
                    while (!this.stop && -1 != (n = in.read(buffer))) {
                        fOut.write(buffer, 0, n);
                        if (++count <= 160) continue;
                        this.notifyProgressDatei("Download: " + datei);
                        count = 0;
                    }
                    fOut.close();
                    in.close();
                    inReader = new InputStreamReader((InputStream)new BZip2CompressorInputStream(new FileInputStream(tmpFile)), "UTF-8");
                } else if (datei.endsWith(".zip")) {
                    zipInputStream = new ZipInputStream(conn.getInputStream());
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
                }
            }
            parser = inFactory.createXMLStreamReader(inReader);
            ret = this.datenLesenFilme(parser, datei);
        }
        catch (Exception ex) {
            ret = false;
            this.daten.fehler.fehlerMeldung(ex, "Filme importieren von: " + datei);
        }
        finally {
            try {
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception ex) {
                this.daten.fehler.fehlerMeldung(ex, "Stream.close");
            }
        }
        this.notifyFertig();
        return ret;
    }

    public synchronized DatenPgruppe ImportPgruppe(String datei) {
        DatenPgruppe datenPgruppe = null;
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                if (parser.getLocalName().equals("Programmgruppe-Button")) {
                    if (this.daten.listePgruppeButton == null) continue;
                    datenPgruppe = new DatenPgruppe();
                    if (this.get(parser, event, "Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                    datenPgruppe = null;
                    continue;
                }
                if (!parser.getLocalName().equals("Programm") || datenPgruppe == null) continue;
                DatenProg datenProg = new DatenProg();
                if (!this.get(parser, event, "Programm", Konstanten.PROGRAMM_COLUMN_NAMES, datenProg.arr)) continue;
                datenPgruppe.addProg(datenProg);
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.datenLesen");
            datenPgruppe = null;
        }
        return datenPgruppe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmlDatenLesen() {
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".mediathek";
            if (new File(datei).exists()) {
                XMLInputFactory inFactory = XMLInputFactory.newInstance();
                inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                XMLStreamReader parser = null;
                InputStreamReader in = null;
                DatenPgruppe datenPgruppe = null;
                in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                parser = inFactory.createXMLStreamReader(in);
                while (parser.hasNext()) {
                    int event = parser.next();
                    if (event != 1) continue;
                    if (parser.getLocalName().equals("System")) {
                        this.get(parser, event, "System", Konstanten.SYSTEM_COLUMN_NAMES, this.daten.system);
                        continue;
                    }
                    if (parser.getLocalName().equals("Senderliste")) {
                        String[] str = this.daten.filmeLaden.getListeSender();
                        this.get(parser, event, "Senderliste", this.daten.filmeLaden.getListeSender(), str);
                        this.daten.filmeLaden.setSenderOn(str);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programmgruppe-Abo")) {
                        datenPgruppe = new DatenPgruppe();
                        if (!this.get(parser, event, "Programmgruppe-Abo", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                        this.daten.listePgruppeAbo.add(datenPgruppe);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programmgruppe-Button")) {
                        datenPgruppe = new DatenPgruppe();
                        if (!this.get(parser, event, "Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                        this.daten.listePgruppeButton.add(datenPgruppe);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programm")) {
                        DatenProg datenProg = new DatenProg();
                        if (!this.get(parser, event, "Programm", Konstanten.PROGRAMM_COLUMN_NAMES, datenProg.arr)) continue;
                        datenPgruppe.addProg(datenProg);
                        continue;
                    }
                    if (parser.getLocalName().equals("Abonnement")) {
                        DatenAbo datenAbo = new DatenAbo();
                        if (!this.get(parser, event, "Abonnement", Konstanten.ABO_COLUMN_NAMES, datenAbo.arr) || Boolean.parseBoolean(datenAbo.arr[10])) continue;
                        this.daten.listeAbo.addAbo(datenAbo);
                        continue;
                    }
                    if (parser.getLocalName().equals("Blacklist")) {
                        DatenBlacklist blacklist = new DatenBlacklist();
                        if (!this.get(parser, event, "Blacklist", Konstanten.BLACKLIST_COLUMN_NAMES, blacklist.arr)) continue;
                        this.daten.listeBlacklist.add(blacklist);
                        continue;
                    }
                    if (parser.getLocalName().equals("Pod")) {
                        DatenPod datenPod = new DatenPod();
                        if (!this.get(parser, event, "Pod", Konstanten.POD_COLUMN_NAMES, datenPod.arr)) continue;
                        this.daten.listePod.addPod(datenPod);
                        continue;
                    }
                    if (!parser.getLocalName().equals("Film-Update")) continue;
                    DatenFilmUpdate datenFilmUpdate = new DatenFilmUpdate();
                    if (!this.get(parser, event, "Film-Update", Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr)) continue;
                    this.daten.listeFilmUpdate.addAlle(datenFilmUpdate);
                }
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.datenLesen");
        }
        finally {
            if (!this.daten.noGui) {
                if (this.daten.system[11].equals("")) {
                    Funktionen.addStandardPodcast(this.daten);
                }
                if (this.daten.listePgruppeAbo.size() == 0) {
                    Funktionen.addStandardprogrammeAbo(this.daten);
                }
                if (this.daten.listePgruppeButton.size() == 0) {
                    Funktionen.addStandardprogrammeButton(this.daten);
                }
                this.daten.listeFilmUpdate.check20(Boolean.parseBoolean(this.daten.system[31]));
            }
        }
    }

    private boolean xmlDatenLesenFilme() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".filme";
            if (new File(datei).exists()) {
                XMLInputFactory inFactory = XMLInputFactory.newInstance();
                inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                XMLStreamReader parser = null;
                InputStreamReader in = null;
                in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                parser = inFactory.createXMLStreamReader(in);
                ret = this.datenLesenFilme(parser, "");
            }
        }
        catch (Exception ex) {
            System.err.println("IoXml.xmlDatenLesenFilme: " + ex.getMessage());
            ret = false;
        }
        return ret;
    }

    private boolean xmlDatenLesenPodster() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".podcaster";
            if (new File(datei).exists()) {
                XMLInputFactory inFactory = XMLInputFactory.newInstance();
                inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                XMLStreamReader parser = null;
                InputStreamReader in = null;
                in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                parser = inFactory.createXMLStreamReader(in);
                ret = this.datenLesenPodster(parser);
            }
        }
        catch (Exception ex) {
            System.err.println("IoXml.xmlDatenLesenPodster: " + ex.getMessage());
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean datenLesenFilme(XMLStreamReader parser, String text) {
        boolean ret = true;
        text = Funktionen.textLaenge(text);
        try {
            while (!this.stop && parser.hasNext()) {
                int event = parser.next();
                if (event == 1 && parser.getLocalName().equals("Filmliste")) {
                    this.get(parser, event, "Filmliste", Konstanten.FILMLISTE_COLUMN_NAMES, this.daten.filmeLaden.filmlisteMetaDaten);
                    int anz = 1;
                    try {
                        anz = Integer.parseInt(this.daten.filmeLaden.filmlisteMetaDaten[3]);
                    }
                    catch (Exception ex) {
                    }
                    finally {
                        this.addMax(anz);
                    }
                }
                if (event != 1 || !parser.getLocalName().equals("Filme")) continue;
                DatenFilm datenFilm = new DatenFilm(this.daten);
                if (!this.get(parser, event, "Filme", Konstanten.FILME_COLUMN_NAMES, datenFilm.arr)) continue;
                this.notifyProgress(text);
                this.daten.filmeLaden.listeFilmeSchattenliste.add(datenFilm);
            }
        }
        catch (Exception ex) {
            System.err.println("IoXml.datenLesenFilme: " + ex.getMessage());
            ret = false;
        }
        return ret;
    }

    private boolean datenLesenPodster(XMLStreamReader parser) {
        boolean ret = true;
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals("Podster")) continue;
                DatenPodster datenPodster = new DatenPodster();
                if (!this.get(parser, event, "Podster", Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr)) continue;
                this.daten.listePodster.add(datenPodster);
            }
        }
        catch (Exception ex) {
            System.err.println("IoXml.datenLesenPodster: " + ex.getMessage());
            ret = false;
        }
        return ret;
    }

    private boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        int i;
        boolean ret = true;
        int maxElem = strRet.length;
        for (i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            this.daten.fehler.fehlerMeldung(ex, "IoXml.get");
        }
        return ret;
    }

    private void notifyStart(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start("", max);
        }
    }

    private void addMax(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.addMax("", max);
        }
    }

    private void notifyProgress(String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress("", text);
        }
    }

    private void notifyProgressDatei(String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(text);
        }
    }

    private void notifyFertig() {
        this.daten.fehler.systemMeldung("Liste Filme gelesen: " + Funktionen.getJetzt_HH_MM_SS());
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig("", false);
        }
    }
}

