#include "ChampionshipMenu.h"
#include "Data.h"
#include "Config.h"
#include "MyFont.h"
#include "SelectionWheel.h"
#include <sstream>
#include "TextViewer.h"
#include "text.h"
#include "Loading.h"
#include "Circuito.h"
#include "Carrera.h"
#include "Moto.h"
#include "Confirm.h"
#include "RaceResults.h"
#include "BikeSelection.h"
#include "ChampionshipData.h"
#include "Profile.h"
#include "TrackSelection.h"
#include "RaceMenu.h"
#include "Jukebox.h"
#include "SlideShow.h"
#include "HiddenDriver.h"
using namespace std;

#define init_item(key,text,x,y) items[key]=text; pos[key][0]=x; pos[key][1]=y; charsdone[key]=0; sel_level[key]=0; selected[key]=false;

static string int2str(int x) {
	stringstream s;
	s<<x;
	return s.str();
}

void ChampionshipMenu::Run() {
	Fade(true);
	while (true) {
		
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed) {
				Fade(false);return;
			} 
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
			if (config->sound_on) music->snd_selcancel.Play();
			last_key=sf::Key::Escape; Fade(false); return;
		} else if(App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
			last_key=sf::Key::Return; if (SelOk()) return;
		} else if(App->GetInput().IsKeyDown(sf::Key::Up) && last_key!=sf::Key::Up) {
			last_key=sf::Key::Up; SelMove(true);
		} else if(App->GetInput().IsKeyDown(sf::Key::Down) && last_key!=sf::Key::Down) {
			last_key=sf::Key::Down; SelMove(false);
		} else if (!App->GetInput().IsKeyDown(last_key)) {
			last_key=sf::Key::Count;
		}
		Draw();
		App->TimedDisplay();
	}
	
}

ChampionshipMenu::ChampionshipMenu() {
	
	profile->LoadChampionshipData();
	
//	App->SetFramerateLimit(0);
	
	loading->Draw();
	
	load_fade;
	load_wh(s,fix_image_file("data/menu/champbksh.png"),1,1);
	ssprite.SetPosition(600,435); 
	ssprite.SetScale(global_scale*.65,global_scale*.65);
	load_wh(b,fix_image_file("data/menu/raceback.png"),1,1);
	bsprite.SetPosition(screen_w/2,screen_h/2);
	load_wh(t,fix_image_file(data->bikes[profile->bike].dir+"thumbnail.png"),1,1);
	tsprite.SetPosition(594,415); 
	tsprite.SetScale(global_scale*.65,global_scale*.65);
	
	int x1=150,x2=450,y1=180,y2=95;
	
	init_item(mic_continue,config->spanish?"CONTINUAR":"CONTINUE",x1,y1+0);
	init_item(mic_positions,config->spanish?"POSICIONES":"POSITIONS",x1,y1+50);
	init_item(mic_calendar,config->spanish?"CALENDARIO":"CALENDAR",x1,y1+100);
	init_item(mic_bike_setup,config->spanish?"CONF. MOTO":"BIKE SETUP",x1,y1+150);
	init_item(mic_help,config->spanish?"AYUDA!":"HELP!",x1,y1+200);
	init_item(mic_retire,config->spanish?"ABANDONAR":"RETIRE",x1,y1+250);
	
	init_item(mic_champ_pts,"Championship Points: 123",x2,y2+0);
	init_item(mic_curr_pos,"Current Position: 1/15",x2,y2+45);
	init_item(mic_races_done,"Races Completed: 1/10",x2,y2+90);
	init_item(mic_next_race,"Next Race: Moonligth Pit",x2,y2+135);
	
	UpdateResults();
	
	for (int i=0;i<mic_count;i++) selected[i]=false;
	for (int i=0;i<mic_count;i++) charsdone[i]=0;
	selection=mic_continue; selected[selection]=true;
	tostart=10;
//	InitRacers(level=alevel);
//	App->SetFramerateLimit(FPS);
}

ChampionshipMenu::~ChampionshipMenu() {
	delete championship_data; championship_data=NULL;
	if (circuito) delete circuito;
	circuito=NULL;
}

void ChampionshipMenu::Draw() {
	
	App->Draw(bsprite);
	
	font->RenderSmall(90,60,.75,config->spanish?"Campeonato":"Championship");
	string esc=config->spanish?"Presione X para volver al menu principal":"Press X to return to main menu"; 
	esc[config->spanish?9:6]=27;
	font->RenderSmall(30,575,.35,esc.c_str());
	
	if (tostart) {
		tostart--;
	} else {
		for (int i=0;i<mic_count;i++) {
			if (selected[i]) {
				if (sel_level[i]<8) sel_level[i]+=1;
			} else {
				if (sel_level[i]>0) sel_level[i]-=1;
			}
			font->RenderPartial(pos[i][0]-sel_level[i],pos[i][1]+sel_level[i],.55+.025*sel_level[i],items[i],charsdone[i]/char_speed);
			if (charsdone[i]==char_speed*items[i].size()) continue; charsdone[i]++;
		}
	}
	
	App->Draw(ssprite);
	App->Draw(tsprite);
	
	sel_wheel->Draw(pos[selection][0],pos[selection][1]);
	
}

bool ChampionshipMenu::SelOk() {
	if (config->sound_on) music->snd_selok.Play();
	if (selection==mic_continue) {
		Fade(false);
		if (championship_data->next_race<0) {
			championship_data->SortPositions();
			if (championship_data->bikes[0].idx==championship_data->pbike) {
				loading->Draw();
				SlideShow *ss=new SlideShow();
				ss->Run();
				delete ss;
			} else {
				TextViewer *text_viewer = new TextViewer("data/menu/champ.png",config->spanish?"El campeonato termino.":"Championship Is Over",config->spanish?text_es_champ_over:text_en_champ_over,false);
				text_viewer->Show(); delete text_viewer;
			}
		} else {
			TrackSelection::target_track=championship_data->races[championship_data->next_race].idx;
			TrackSelection *track_selection = new TrackSelection();
			if (track_selection->Select(2)) {
				loading->Draw();
				delete track_selection;
				RaceMenu *race_menu = new RaceMenu(TrackSelection::target_track, TrackSelection::laps, TrackSelection::level);
				if (race_menu->Run()) {
					RaceResults *results = new RaceResults();
					results->CalculateChampPositions();
					results->Show();
					if (profile->tips_seen<9) {
						hidden->Run(
							(config->spanish?th_tip_es:th_tip_en)[(profile->tips_seen)-1],
							tips_imgs[(profile->tips_seen)-1].fname,
							tips_imgs[(profile->tips_seen)-1].x,
							tips_imgs[(profile->tips_seen)-1].y
							);
						profile->tips_seen++;
					}
					profile->Save(true);
				}
				delete race_menu;
			} else
				delete track_selection;
			UpdateResults();
		}
		Fade(true);
	} else if (selection==mic_calendar) {
		Fade(false);
		RaceResults *results = new RaceResults();
		results->CalculateChampCalendar();
		results->Show();
		loading->Draw();
		delete results;
		Fade(true);
	} else if (selection==mic_positions) {
		Fade(false);
		RaceResults *results = new RaceResults();
		results->CalculateChampPositions();
		results->Show();
		loading->Draw();
		delete results;
		Fade(true);
	} else if (selection==mic_retire) {
		if (!profile->on_championship || championship_data->next_race==-1 || confirm->Ask(this,config->spanish?"Confirmar Abandono":"Really retire?")) {
			profile->RetireFromChampionship();
			return true;
		}
	} else if (selection==mic_help) {
		Fade(false);
		TextViewer *text_viewer = new TextViewer("data/menu/help.png",config->spanish?"Carrera":"Race Mode",config->spanish?text_es_help_championship:text_en_help_championship);
		text_viewer->Show(); delete text_viewer;
		Fade(true);
	} else if (selection==mic_bike_setup) {
		Fade(false);
		BikeSelection *bike_selection = new BikeSelection(false);
		bike_selection->Select(1);
		delete bike_selection;
		Fade(true);
	}
	return false;
}

void ChampionshipMenu::SelMove(bool up) {
	if (config->sound_on) music->snd_selmove.Play();
	if (up) {
		if (selection==mic_continue) return;
		selected[selection--]=false;
		selected[selection]=true;
	} else {
		if (selection==mic_retire) return;
		selected[selection++]=false;
		selected[selection]=true;
	}
}

void ChampionshipMenu::UpdateResults() {

	int pos=0; championship_data->SortPositions();
	while (championship_data->bikes[pos].idx!=championship_data->pbike) pos++;
	
	items[mic_champ_pts]=string(config->spanish?"Puntaje Actual: ":"Championship Points: ")
		+int2str(championship_data->bikes[pos].pts);
	items[mic_curr_pos]=string(config->spanish?"Posicion Actual: ":"Current Position: ")
		+int2str(pos+1)+"/"+int2str(championship_data->num_bikes);
	items[mic_races_done]=string(config->spanish?"Carreras Comp: ":"Races Completed: ")
		+int2str(championship_data->races_done)+"/"+int2str(championship_data->num_races);
	if (championship_data->next_race>=0)
		items[mic_next_race]=string(config->spanish?"Sig. Carrera: ":"Next Race: ")+
			data->tracks[championship_data->races[championship_data->next_race].idx].name;
	else
		items[mic_next_race]=config->spanish?"Campeonato Completo":"Championship Completed";
	
	charsdone[mic_next_race]=0;
	charsdone[mic_champ_pts]=0;
	charsdone[mic_curr_pos]=0;
	charsdone[mic_races_done]=0;
	
	if (championship_data->next_race==-1) {
		string should_be=config->spanish?"TERMINAR":"FINISH";
		if (items[mic_retire]!=should_be) {
			items[mic_retire]=should_be;
			charsdone[mic_retire]=0;
		}
	}
	
}

implement_fade(ChampionshipMenu)
	
	
