#ifndef CONFIG_H
#define CONFIG_H
#include <SFML/Window.hpp>

#define MAX_VOLUME 20

#define vol_music (float(config->music_vol)/MAX_VOLUME)
#define vol_sound (float(config->sound_vol)/MAX_VOLUME)

struct Config {
	sf::Key::Code key_accel,key_brake,key_left,key_right;
	bool joy_accel_ib, joy_brake_ib, joy_left_ib, joy_right_ib; // si cada mov es eje (false) o boton (true)
	int joy_accel,joy_brake,joy_left,joy_right; // botones o ejes (+/- segun dir)
	int num_modes, *modes_h,*modes_w, cur_mode, old_mode;
	bool fullscreen, old_fullscreen;
	bool music_on;
	int joystick;
	int music_vol;
	bool sound_on;
	int sound_vol;
	bool spanish,know_lang;
	bool extra_fx;
	bool shaders_on;
	bool changed;
	int particles_low;
	int particles_hi;
	int real_w,real_h;
	int version;
	bool low_textures;
	Config();
	~Config();
	void LoadModes();
	void ChangeLanguage(bool up);
	void ChangeResolution(bool up);
	void ChangeFullscreen(bool up);
	void ChangeTextures(bool up);
	void ChangeParticles(bool up);
	void ChangeSound(bool up);
	void ChangeSoundVol(bool up);
	void ChangeMusic(bool up);
	void ChangeMusicVol(bool up);
	void ChangeJoystick(bool up);
	void SetJoys(bool bja, int ja, bool bjb, int jb, bool bjr, int jr, bool bjl, int jl);
	void SetKeys(int ka, int kb, int kr, int kl);
	void Save(bool forced=false);
};

extern Config *config;

#endif

