#ifndef DATA_H
#define DATA_H
#include "global.h"

class ChampionshipData;

extern int pts_champ[3][10];
extern int pts_bike[3][3];
extern int champ_avail_tracks[3];

struct TrackData {
	string name,id,dir,best_name;
	real best_time;
	char weather;
};

struct BikeData {
	string name,id,dir;
};

#define champ_records_max 15
struct ChampRecord {
	string name; int pts;
	bool operator<(const ChampRecord &c) const { return pts>c.pts; }
};

struct Data {
	
	bool profile_order_changed;
	void SaveSomething();
	
	ChampRecord champ_records[champ_records_max+1];
	int champ_records_count;
	
	string profile_names[profile_max];
	string profile_files[profile_max];
	int profile_count;
	
	TrackData tracks[track_max];
	int track_count;
	
	BikeData bikes[bike_max];
	int bike_count;
	
	bool records_changed;
	bool SetChampRecord(string name, int pts);
	void SortChampRecords();
	
	Data();
	
	void LoadTracks();
	void LoadBikes();
	void LoadProfiles();
	
	void SelectProfile(string file="");
	void DeleteProfile(int n);
	
	void SaveProfiles();
	bool ProfileExists(string name);
	
	int FindTrack(string id);
	int FindBike(string id);
	
	string NewProfile(string name);
	
	void SetRecord(string id, string n, real t);
	void SaveRecords();

};



struct Racer {
	int controller, start_pos;
	string name, dir;
	real best_lap;
	real accel,brake,turn,vel;
	int idx; // indice en data->bikes
	Racer(){best_lap=-1;}
	void SetUnnamedPlayer(int num);
	void SetFromProfile(int num);
	void SetForQuickrace(int num);
	void SetFromChampionship(int num, int level);
	void SetRandom(int num, int level);
};

extern Data *data;
extern Racer *racers;

#endif

