#include "Confirm.h"
#include "MyFont.h"

Confirm::Confirm() {
	image.LoadFromFile("data"SLASH"misc"SLASH"confirm.png");
	sprite.SetImage(image);
	sprite.SetCenter(image.GetWidth()/2,image.GetHeight()/2);
	sprite.SetPosition(screen_w/2,screen_h/2);
}

string Confirm::Input(const char *what) {
	FloatRect rect(0,0,screen_w,screen_h);
	view=new View(rect);
	App->SetView(*view);
	string text2;
	real h=0;
	while (h<1) {
		h+=.2;
		sprite.SetScale(h,h);
		App->Draw(sprite);
		App->Display();
	}
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				last_key=sf::Key::Escape; return ""; 
			} else if (App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				last_key=sf::Key::Return; if (text.size()) return text;
			} else if (App->GetInput().IsKeyDown(sf::Key::Back) && last_key!=sf::Key::Back) {
				last_key=sf::Key::Back; if (text.size()) text=text.substr(0,text.size()-1);
			} else if (App->GetInput().IsKeyDown(sf::Key::Subtract) && last_key!=sf::Key::Subtract) {
					text+='-';
			} else if (App->GetInput().IsKeyDown(sf::Key::Space) && last_key!=sf::Key::Space) {
					text+=' ';
			} else  {
				last_key=Key::Count;
				for (int i=sf::Key::A,c='a';i<=sf::Key::Z;i++,c++) {
					if (App->GetInput().IsKeyDown((Key::Code)i)) {
					if (!down[int(c)]) {
						down[int(c)]=true; 
						if (App->GetInput().IsKeyDown(sf::Key::LShift) || App->GetInput().IsKeyDown(sf::Key::RShift))
							text+=c+('A'-'a');
						else
							text+=c;
					}
					} else
						down[int(c)]=false;
				}
				for (int i=sf::Key::Num0,c='0';i<=sf::Key::Num9;i++,c++) {
					if (App->GetInput().IsKeyDown((Key::Code)i)) {
					if (!down[int(c)]) {
						text+=c; down[int(c)]=true;
					}
					} else
						down[int(c)]=false;
				}
			}
		}
		
		while (font->Ancho(text.c_str(),.7)>220)
			text=text.substr(0,text.size()-1);
		
		App->Draw(sprite);
		font->RenderSmall(
			screen_w/2-100,screen_h/2-20,
			.5,what);
		
		if (text2.size()!=text.size()+1) {
			f=0; text2=text+"|";
		}
		
		if (((f++)/5)%2) {
			if (text.size())
				font->RenderSmall(
					screen_w/2-100,screen_h/2+40,
					.7,text.c_str());
		} else
			font->RenderSmall(
				screen_w/2-100,screen_h/2+40,
				.7,text2.c_str());
		
		
		App->Display();
	}
	return "";
}
