#include "Experience.h"
#include "MyFont.h"
#include "Config.h"
#include "SelectionWheel.h"
#include "Jukebox.h"

Experience::Experience(experience_text aet) {
	et=aet;
	load_fade;
	load_wh(b,fix_image_file("data/misc/experience.png"),1,1);
	bsprite.SetPosition(screen_w/2, screen_h/2);
	if (config->sound_on) sbuf.LoadFromFile("data/sound/cash.wav");
	snd.SetBuffer(sbuf);
	snd.SetVolume(100*vol_sound);
}

void Experience::Draw() {
	App->Clear(Color(0,0,0));
	App->Draw(bsprite);
	if (et==ET_RECORD) {
		font->RenderCenter(
			screen_w/2,screen_h/2-65,.7,
			config->spanish?"Felicidades: Has entrado en el":"Congratulations: You won");
		font->RenderCenter(
			screen_w/2,screen_h/2-10,.7,
			config->spanish?"cuadro de maximas puntuaciones":"a lot of points and your name");
		font->RenderCenter(
			screen_w/2,screen_h/2+45,.7,
			config->spanish?"en modo campeonato.":"will be listed in the top-10 table.");
	} else if (et==ET_CREDITS) {
		font->RenderCenter(
			screen_w/2,screen_h/2-65,.7,
			config->spanish?"Felicidades: Has ganado":"Congratulations: You earned new");
		font->RenderCenter(
			screen_w/2,screen_h/2-10,.7,
			config->spanish?"puntos de experiencia. Puedes":"experience credits. Go to bike-setup");
		font->RenderCenter(
			screen_w/2,screen_h/2+45,.7,
			config->spanish?"usarlos para mejorar tu moto.":"and use them to improve your bike.");
	} else if (et==ET_TRACKS) {
		font->RenderCenter(
			screen_w/2,screen_h/2-65,.7,
			config->spanish?"Al ganar el campeonato":"By winning the");
		font->RenderCenter(
			screen_w/2,screen_h/2-10,.7,
			config->spanish?"has desbloqueado nuevos":"championship yo have");
		font->RenderCenter(
			screen_w/2,screen_h/2+45,.7,
			config->spanish?"circuitos.":"unlocked new tracks.");
	}
	font->RenderSmall(
		screen_w/2+145,screen_h/2+110,.75,
		config->spanish?"Continuar":"Continue");
	sel_wheel->Draw(screen_w/2+155,screen_h/2+110);
}

void Experience::Run() {
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	snd.Play();
	Fade(true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			if (config->sound_on) music->snd_selcancel.Play();
			last_key=sf::Key::Escape; Fade(false); return; 
		} } else if (App->GetInput().IsKeyDown(sf::Key::Return)) { if (last_key!=sf::Key::Return) {
			if (config->sound_on) music->snd_selok.Play();
			last_key=sf::Key::Return; Fade(false); return;
		} } else {
			last_key=sf::Key::Count;
		}
		Draw();
		
		App->TimedDisplay();
	}
}

implement_fade(Experience);

