#include "RaceExtras.h"
#include "Carrera.h"
#include "MyFont.h"

RaceExtras *race_extras;

RaceExtras::RaceExtras() {
	sflag="Race Finished";
	slast="Last Lap";
	swins=" Wins The Race";
	sesc="press E to continue";
	sesc[6]=27;
	Reload();
}

void RaceExtras::Reload() {
	shadow_image.LoadFromFile(fix_image_file("data/misc/shadow.png"));
	light_image.LoadFromFile(fix_image_file("data/misc/light.png"));
	spray_image.LoadFromFile(fix_image_file("data/misc/spray.png"));
	load_wh(t,fix_image_file("data/osd/time.png"),1,1);
	load_wh(f,fix_image_file("data/osd/flag.png"),1,4);
	load_wh(s,fix_image_file("data/osd/semaforo.png"),1,6);
}

void RaceExtras::Reset() {
	irecord=ilast=itime=iflag=0;
	nflag=0; dflag=1;
#ifdef DEBUG
	slen=3*13-1;
#else
	slen=12*13-1;
#endif
	snum=0; iwon=0;
}

void RaceExtras::Update(real x, real y, real z) {
	if (snum<slen) {
		int is=(snum/(slen/7))%6;
		snum++;
		ssprite.SetSubRect(IntRect(0,sh*is,sw,sh*(is+1)));
		ssprite.SetPosition(x,y-z*screen_h/3);
		ssprite.SetScale(z*global_scale,z*global_scale);
		App->Draw(ssprite);
		if (snum>(slen/7)*6) carrera->started=true;
	}	
	if (iflag>0) {
		nflag=(nflag+1)%8;
		fsprite.SetScale(z*global_scale,z*global_scale);
		fsprite.SetSubRect(IntRect(0,nflag/2*fh,fw,(nflag/2+1)*fh));
		fsprite.SetPosition(x-z*75,y-z*(screen_h/2-55));
		App->Draw(fsprite);
		if (iflag<sflag.size()*2)
			font->RenderPartial(x+10*z,y-z*(screen_h/2-70),z/2,sflag,iflag/2);
		else
			font->RenderSmall(x+10*z,y-z*(screen_h/2-70),z/2,sflag.c_str());
		iflag++;
	} 
	if (iwon>0) {
		if (iwon<who_won.size()*2)
			font->RenderPartial(x-100*z,y+z*(screen_h/2-75),z/2,who_won,iwon/2);
		else if (iwon<400)
			font->RenderSmall(x-100*z,y+z*(screen_h/2-75),z/2,who_won.c_str());
		else if (iwon<400+who_won.size()*2)
			font->RenderPartial(x-100*z,y+z*(screen_h/2-75),z/2,who_won,who_won.size()-(iwon-400)/2);
		else if (!carrera->player_done)
			iwon--;
		else if (iwon>600) {
			if (iwon-600<sesc.size()*2)
				font->RenderPartial(x-100*z,y+z*(screen_h/2-75),z/2,sesc,(iwon-600)/2);
			else
				font->RenderSmall(x-100*z,y+z*(screen_h/2-75),z/2,sesc.c_str());
		}
		iwon++;
	}
	if (ilast>0) {
		if (ilast<slast.size()*2)
			font->RenderPartial(x-z*20,y-z*(screen_h/2-75),z/2,slast,ilast/2);
		else if (ilast>500)
			font->RenderPartial(x-z*20,y-z*(screen_h/2-75),z/2,slast,slast.size()-(ilast-500)/2);
		else
			font->RenderSmall(x-z*20,y-z*(screen_h/2-75),z/2,slast.c_str());
		ilast++;
		if (ilast==500+slast.size()*2) ilast=0;
	}
	if (irecord>0) {
		tsprite.SetScale(z*global_scale,z*global_scale);
		tsprite.SetPosition(x-z*110,y+z*(screen_h/2-45));
		App->Draw(tsprite);
		if (irecord<srecord.size()*2)
			font->RenderPartial(x-z*70,y+z*(screen_h/2-30),z/2,srecord,irecord/2);
		else if (irecord>500)
			font->RenderPartial(x-z*70,y+z*(screen_h/2-30),z/2,srecord,srecord.size()-(irecord-500)/2);
		else
			font->RenderSmall(x-z*70,y+z*(screen_h/2-30),z/2,srecord.c_str());
		irecord++;
		if (irecord==500+srecord.size()*2) irecord=0;
	}
}

void RaceExtras::ShowFlag() {
	iflag=1;
}

void RaceExtras::ShowLast() {
	ilast=1;
}

void RaceExtras::ShowRecord(bool absolute) {
	if (absolute) srecord="All-Time Best Lap!";
	else srecord="Personal Best Lap!";
	irecord=1;
}

void RaceExtras::Won(string name) {
	who_won=name+" Wins The Race";
	iwon=1;
}
