#include "RaceResults.h"
#include "Carrera.h"
#include "Data.h"
#include "MyFont.h"
#include "Moto.h"
#include "SelectionWheel.h"
#include <sstream>
#include "Data.h"
#include "Jukebox.h"
#include "ChampionshipData.h"
#include "Config.h"
#include "Profile.h"
using namespace std;

char *diff2str(Moto *m1, Moto *m2) {
	static char buf[15];
	char *c=buf;
	int lapd=m1->lap-m2->lap;
	if (m2->time_total<0) {
		*(c++)=' '; *(c++)='\0'; return buf;
	} else if (lapd) { 
		if (lapd>9) *(c++)='0'+lapd/10;
		*(c++)='0'+lapd%10;
		*(c++)='L'; *(c++)='\0';
		return buf;
	}
	double t=m2->time_total-m1->time_total;
	if (t>1000) {
		*(c++)='x';
		*(c++)='x';
		*(c++)='x';
		*(c++)='.';
		*(c++)='x';
		*(c++)='x';
	} else {
		int pe=int(t);
		int pd=int((t-pe)*100);
		int ce=int(pe/100);
		if (ce) *(c++)=ce+'0';
		else { *(c++)=' '; *(c++)=' '; }
		*(c++)=int(pe/10)%10+'0';
		*(c++)=pe%10+'0';
		*(c++)='.';
		*(c++)=pd/10+'0';
		*(c++)=pd%10+'0';
	}
	*c='\0';
	return buf;
}

char *diff2str(const Racer &r1, const Racer &r2) {
	static char buf[15];
	char *c=buf;
	if (r2.best_lap<0) {
		*(c++)=' '; *(c++)='\0'; return buf;
	}
	double t=r2.best_lap-r1.best_lap;
	if (t>1000) {
		*(c++)='x';
		*(c++)='x';
		*(c++)='x';
		*(c++)='.';
		*(c++)='x';
		*(c++)='x';
	} else {
		int pe=int(t);
		int pd=int((t-pe)*100);
		int ce=int(pe/100);
		if (ce) *(c++)=ce+'0';
		else { *(c++)=' '; *(c++)=' '; }
		*(c++)=int(pe/10)%10+'0';
		*(c++)=pe%10+'0';
		*(c++)='.';
		*(c++)=pd/10+'0';
		*(c++)=pd%10+'0';
	}
	*c='\0';
	return buf;
}


static char *time2str(real sec) {
	static char buf[15];
	if (sec<0) {
		buf[0]='D'; buf[1]='N'; buf[2]='F'; 
		buf[3]='\0'; return buf;
	}
	char *b=buf;
	int m = int (sec/60);
	int s = int (sec)%60;
	int f = int(sec*100)%100;
	*(b++)=m/10+'0';*(b++)=m%10+'0';
	*(b++)=':';
	*(b++)=s/10+'0';*(b++)=s%10+'0';
	*(b++)='.';
	*(b++)=f/10+'0';*(b++)=f%10+'0';
	*(b++)=0;
	return buf;
}

static string int2str(int x) {
	static char r[4]; 
	r[1]=r[2]=r[3]='\0';
	if (x<10) { r[0]='0'+x; }
	else if (x<100) { r[0]='0'+x/10; r[1]='0'+x%10; }
	else { r[0]='0'+x/100; r[1]='0'+(x%100)/10; r[2]='0'+x%10; }
	return r;
}

static string lev2str(int x) {
	switch (x) {
	case 1: return config->spanish?"Facil":"Easy";
	case 2: return config->spanish?"Normal":"Normal";
	case 3: return config->spanish?"Dificil":"Hard";
	default: return config->spanish?"<Desconocido>":"<Unknown>";
	}
}

RaceResults::RaceResults() {
	if (config->music_on) music->PlayMusic();
	load_fade;
	bimage.LoadFromFile("data/menu/table_back.png");
	bsprite.SetImage(bimage); bsprite.SetCenter(0,0); 
	bsprite.SetPosition(0,0);
	himage.LoadFromFile("data/menu/table_hi.png");
	hsprite.SetImage(himage); hsprite.SetCenter(0,0); 
	hsprite.SetPosition(0,0);
	limage.LoadFromFile("data/menu/table_low.png");
	lsprite.SetImage(limage); lsprite.SetCenter(0,limage.GetHeight());
	lsprite.SetPosition(0,screen_h);
}

void RaceResults::Calculate() {

	delta_y=0; target=0;
	
	cant_results=data->bike_count;
	
	items[4*cant_results] = config->spanish?"RESULTADOS":"RACE RESULTS";
	pos[4*cant_results][0] = (screen_w-font->Ancho(items[4*cant_results].c_str(),.8))/2; pos[4*cant_results][1] = 45;
	items[4*cant_results+1] = config->spanish?"Continuar":"Continue";
	pos[4*cant_results+1][0] = 590; pos[4*cant_results+1][1] = 570;
	
	items[4*cant_results+2] = config->spanish?"Pos":"Pos";
	pos[4*cant_results+2][0] = 50; pos[4*cant_results+2][1] = 120;
	items[4*cant_results+3] = config->spanish?"Nombre":"Name";
	pos[4*cant_results+3][0] = 170; pos[4*cant_results+3][1] = 120;
	items[4*cant_results+4] = config->spanish?"Dif":"Diff";
	pos[4*cant_results+4][0] = 500; pos[4*cant_results+4][1] = 120;
	items[4*cant_results+5] = config->spanish?"Tiempo":"Time";
	pos[4*cant_results+5][0] = 650; pos[4*cant_results+5][1] = 120;
	
	for (int i=0;i<cant_results;i++) {
		pos[4*i][0]=90; pos[4*i+1][0]=170; pos[4*i+2][0]=560; pos[4*i+3][0]=720;
		pos[4*i+2][1]=pos[4*i][1]=pos[4*i+1][1]=pos[4*i+3][1]=170+i*40;
	}
	
	for (int i=0;i<cant_results*4+6;i++) charsdone[i]=0;
	for (int i=0;i<cant_results;i++) items[4*i]=int2str(i+1);
	for (int i=0;i<cant_results;i++) items[4*i+1]=racers[i].name;
	
	items[4*0+2]=" ";
	for (int i=1;i<cant_results;i++)
		items[4*i+2]=diff2str(racers[0],racers[i]);
	
	for (int i=0;i<cant_results;i++) 
		items[4*i+3]=time2str(racers[i].best_lap);
}

void RaceResults::Calculate(Carrera *carrera) {
	
	delta_y=0; target=0;
	
	cant_results=carrera->num_racers;
	
	items[4*cant_results] = config->spanish?"RESULTADOS":"RACE RESULTS";
	pos[4*cant_results][0] = (screen_w-font->Ancho(items[4*cant_results].c_str(),.8))/2; pos[4*cant_results][1] = 45;
	items[4*cant_results+1] = config->spanish?"Continuar":"Continue";
	pos[4*cant_results+1][0] = 590; pos[4*cant_results+1][1] = 570;
	
	items[4*cant_results+2] = config->spanish?"Pos":"Pos";
	pos[4*cant_results+2][0] = 50; pos[4*cant_results+2][1] = 120;
	items[4*cant_results+3] = config->spanish?"Nombre":"Name";
	pos[4*cant_results+3][0] = 170; pos[4*cant_results+3][1] = 120;
	items[4*cant_results+4] = config->spanish?"Dif":"Diff";
	pos[4*cant_results+4][0] = 500; pos[4*cant_results+4][1] = 120;
	items[4*cant_results+5] = config->spanish?"Tiempo":"Time";
	pos[4*cant_results+5][0] = 650; pos[4*cant_results+5][1] = 120;
	
	for (int i=0;i<cant_results;i++) {
		pos[4*i][0]=90; pos[4*i+1][0]=170; pos[4*i+2][0]=560; pos[4*i+3][0]=720;
		pos[4*i+2][1]=pos[4*i][1]=pos[4*i+1][1]=pos[4*i+3][1]=170+i*40;
	}
	
	for (int i=0;i<cant_results*4+6;i++) charsdone[i]=0;
	for (int i=0;i<cant_results;i++) items[4*i]=int2str(i+1);
	for (int i=0;i<cant_results;i++) items[4*i+1]=motos[i]->name;
	
	items[4*0+2]=" ";
	for (int i=1;i<cant_results;i++)
		items[4*i+2]=diff2str(motos[0],motos[i]);
	 
	for (int i=0;i<cant_results;i++) {
		if (motos[0]->lap==motos[i]->lap || motos[i]->lap==1)
			items[4*i+3]=time2str(motos[i]->time_total);
		else
			items[4*i+3]=diff2str(motos[0],motos[i]);
	}

}

void RaceResults::Show() {
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	tostart=20;
	Fade(true);
	App->SetView(*view);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				return;
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				if (config->sound_on) music->snd_selcancel.Play();
				last_key=sf::Key::Escape; Fade(false); return;
			} else if (App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				last_key=sf::Key::Return; Fade(false); return;
			} else if(App->GetInput().IsKeyDown(sf::Key::Up) && last_key!=sf::Key::Up) {
				last_key=sf::Key::Up; Move(true); 
			} else if(App->GetInput().IsKeyDown(sf::Key::Down) && last_key!=sf::Key::Down) {
				last_key=sf::Key::Down;  Move(false);
			} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
				last_key=sf::Key::Count;
			}
		}
		Draw();
		App->TimedDisplay();
	}
}

void RaceResults::Draw() {
	
	App->Draw(bsprite);
	
	delta_y = (6*delta_y+pos[0][1]-pos[target*4][1])/7;
	
	if (tostart) tostart--; else {
		
		for (int i=0;i<4*cant_results;i++) {
			font->RenderPartialI(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
			i++;
			font->RenderPartial(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
			i++;
			font->RenderPartialI(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
			i++;
			font->RenderPartialI(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
		}
		for (int i=0;i<4*cant_results;i++) { if (charsdone[i]==2*char_speed*items[i].size()) continue; charsdone[i]++; }

	App->Draw(hsprite);
	App->Draw(lsprite);
		
		for (int i=4*cant_results;i<4*cant_results+2;i++) {
			font->RenderPartial(pos[i][0],pos[i][1],.80,items[i],charsdone[i]/char_speed/2);
			if (charsdone[i]==2*char_speed*items[i].size()) continue; charsdone[i]++;
		}
		for (int i=4*cant_results+2;i<4*cant_results+6;i++) {
			font->RenderPartial(pos[i][0],pos[i][1],.65,items[i],charsdone[i]/char_speed/2);
			if (charsdone[i]==2*char_speed*items[i].size()) continue; charsdone[i]++;
		}
	}
	
	sel_wheel->Draw(595,565);
}

void RaceResults::Move(bool up) {
	if (up) {
		if (target>0) target--;
	} else {
		if (target<cant_results-8) target++;
	}
}

int RaceResults::GetPlayerPos() {
	int i=0;
	while (motos[i]->controller) i++;
	return motos[i]->pos;
}

void RaceResults::CalculateChampCalendar() {
	delta_y=0; target=0;
	
	cant_results=championship_data->num_races;
	
	items[4*cant_results] = config->spanish?"CALENDARIO":"CALENDAR";
	pos[4*cant_results][0] = (screen_w-font->Ancho(items[4*cant_results].c_str(),.8))/2; pos[4*cant_results][1] = 45;
	items[4*cant_results+1] = config->spanish?"Continuar":"Continue";
	pos[4*cant_results+1][0] = 590; pos[4*cant_results+1][1] = 570;
	
	items[4*cant_results+2] = config->spanish?"Carrera":"Race";
	pos[4*cant_results+2][0] = 50; pos[4*cant_results+2][1] = 120;
	items[4*cant_results+3] = config->spanish?"Circuito":"Track";
	pos[4*cant_results+3][0] = 170; pos[4*cant_results+3][1] = 120;
	items[4*cant_results+4] = config->spanish?"Nivel/Vts":"Level/Laps";
	pos[4*cant_results+4][0] = 400; pos[4*cant_results+4][1] = 120;
	items[4*cant_results+5] = config->spanish?"Pos/Pts":"Pos/Pts";
	pos[4*cant_results+5][0] = 600; pos[4*cant_results+5][1] = 120;
	
	for (int i=0;i<cant_results;i++) {
		pos[4*i][0]=90; pos[4*i+1][0]=170; pos[4*i+2][0]=510; pos[4*i+3][0]=680;
		pos[4*i+2][1]=pos[4*i][1]=pos[4*i+1][1]=pos[4*i+3][1]=170+i*40;
	}
	
	for (int i=0;i<cant_results*4+6;i++) charsdone[i]=0;
	for (int i=0;i<cant_results;i++) {
		items[4*i]=int2str(i+1);
		items[4*i+1]=data->tracks[championship_data->races[i].idx].name;
		if (championship_data->races[i].results) {
			items[4*i+2]=lev2str(championship_data->races[i].level)
				+"/"+int2str(championship_data->races[i].laps);
			items[4*i+3]=int2str(championship_data->races[i].GetPos(championship_data->pbike))
				+"/"+int2str(championship_data->races[i].GetPts(championship_data->pbike));
		} else {
			items[4*i+2]="";
			items[4*i+3]="";
		}
	}
	
}

void RaceResults::CalculateChampPositions() {
	delta_y=0; target=0;
	
	cant_results=data->bike_count;
	
	items[4*cant_results] = config->spanish?"POSICIONES":"POSITIONS";
	pos[4*cant_results][0] = (screen_w-font->Ancho(items[4*cant_results].c_str(),.8))/2; pos[4*cant_results][1] = 45;
	items[4*cant_results+1] = config->spanish?"Continuar":"Continue";
	pos[4*cant_results+1][0] = 590; pos[4*cant_results+1][1] = 570;
	
	items[4*cant_results+2] = config->spanish?"Pos":"Pos";
	pos[4*cant_results+2][0] = 50; pos[4*cant_results+2][1] = 120;
	items[4*cant_results+3] = config->spanish?"Nombre":"Name";
	pos[4*cant_results+3][0] = 170; pos[4*cant_results+3][1] = 120;
	items[4*cant_results+4] = config->spanish?"Dif":"Diff";
	pos[4*cant_results+4][0] = 530; pos[4*cant_results+4][1] = 120;
	items[4*cant_results+5] = config->spanish?"Pts":"Pts";
	pos[4*cant_results+5][0] = 680; pos[4*cant_results+5][1] = 120;
	
	for (int i=0;i<cant_results;i++) {
		pos[4*i][0]=90; pos[4*i+1][0]=170; pos[4*i+2][0]=560; pos[4*i+3][0]=720;
		pos[4*i+2][1]=pos[4*i][1]=pos[4*i+1][1]=pos[4*i+3][1]=170+i*40;
	}
	
	for (int i=0;i<cant_results*4+6;i++) charsdone[i]=0;
	for (int i=0;i<cant_results;i++) {
		items[4*i]=int2str(i+1);
		if (championship_data->bikes[i].idx==championship_data->pbike)
			items[4*i+1]=profile->name;
		else
			items[4*i+1]=data->bikes[championship_data->bikes[i].idx].name;
		if (i)
			items[4*i+2]=int2str(championship_data->bikes[0].pts-championship_data->bikes[i].pts);
		else
			items[4*i+2]="";
		items[4*i+3]=int2str(championship_data->bikes[i].pts);
	}
	
}


implement_fade(RaceResults)

