#include "TextViewer.h"
#include "MyFont.h"
#include "Data.h"
#include "Config.h"
#include "Jukebox.h"

TextViewer::TextViewer(string fback, string atitle, string atext, bool botline) {
	textviewer_lines=botline?10:12;
	show_botline=botline;
	load_fade;
	text=atext;
	title=atitle;
	
	lc=0; l[0]=0; dl=0;
	for (unsigned int i=0;i<text.size();i++)
		if (text[i]=='\n') l[++lc]=i+1;
	
	for (int i=0;i<textviewer_lines;i++) ln[i]=-i*2;
	
	image.LoadFromFile(fix_image_file(fback));
	sprite.SetImage(image);
	sprite.SetScale(global_scale,global_scale);
}

void TextViewer::Show() {
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	Fade(true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				return;
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				if (config->sound_on && music) music->snd_selcancel.Play();
				last_key=sf::Key::Escape; Fade(false); return;
			} else if (App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				if (!show_botline) {
					if (config->sound_on && music) music->snd_selcancel.Play();
					Fade(false); return;
				} else if (dl<lc-textviewer_lines) {
					dl++; for (int i=0;i<textviewer_lines-1;i++) ln[i]=ln[i+1]; ln[textviewer_lines-1]=0;
				}
				last_key=sf::Key::Return; 
			} else if(App->GetInput().IsKeyDown(sf::Key::Up) && last_key!=sf::Key::Up) {
				last_key=sf::Key::Up; if (dl) {
					dl--; for (int i=textviewer_lines-1;i>0;i--) ln[i]=ln[i-1]; ln[0]=0;
				}
			} else if(App->GetInput().IsKeyDown(sf::Key::Down) && last_key!=sf::Key::Down) {
				last_key=sf::Key::Down;  if (dl<lc-textviewer_lines) {
					dl++; for (int i=0;i<textviewer_lines-1;i++) ln[i]=ln[i+1]; ln[textviewer_lines-1]=0;
				} 
			} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
				last_key=sf::Key::Count;
			}
		}
		Draw();
		App->TimedDisplay();
	}
}

void TextViewer::Draw() {
	
	App->Draw(sprite);
	for (int i=0;i<textviewer_lines;i++) {
		if (i==lc) break;
		string s = text.substr(l[i+dl], l[i+dl+1]-l[i+dl]-1);
		if (!s.size()) continue;
		if (ln[i]<0)
			ln[i]+=2/char_speed;
		else if (ln[i]>=int(s.size()))
			font->RenderSmall(70,110+i*42,.55,s.c_str());
		else
			font->RenderPartial(70,110+i*42,.55,s,ln[i]+=2/char_speed);
	}
	font->RenderSmall(screen_w/2-font->Ancho(title.c_str(),.45)/2,50,.45,title.c_str());
	if (show_botline) font->RenderSmall(400,550,.35,"(use arrows to scroll, escape to return)");
}

implement_fade(TextViewer)
	
