#ifndef CIRCUITO_H
#define CIRCUITO_H

#include <string>
#include "global.h"
using namespace std;

#define route_max 256

#define qp_unknown 0
#define qp_track 1
#define qp_grass 2
#define qp_leca 4
#define qp_wall 8
#define qp_finishline 16

struct pos_largada { 
	real x,y,a,r; 
};

struct Circuito {
	int mm_x0,mm_y0;
	int version;
	Sound snd_fans1, snd_fans2;
//	int ai_route[route_max][2];
	int checkpoints[route_max][4];
	real checkpoints_alpha[route_max][3];
	int finish_line[2];
	int fans[route_max][50];
	int check_count;
	Image mapa, light;
	Image imini; Sprite smini;
	int image_c, image_r;
	Image **image;
	Sprite **sprite;
#ifdef DEBUG
	Sprite msprite;
#endif
	declare_wh(t);
	real scale, scale_mapa, scale_mini;
	real best_lap; string id;
	// datos para ubicar las posiciones de largada
	real largada_angle, largada_x, largada_y; // posicion del primero
	real largada_dc, largada_df; // delta para las pos de los otros
	int largada_nxf; // cuantos corredores por fila
	Circuito(int track_index);
	~Circuito();
	int QuePisa(real x, real y);
	Color Luz(real x, real y);
	pos_largada PosLargada(int i);
	void DoSounds(int x, int y);
	void Draw(real x, real y);
	void DeleteSomething();
	bool BuildIfNeeded(int track_index);
	bool IsOk();
};

extern Circuito *circuito;

#endif

