#include "LangSelection.h"
#include "Config.h"

LangSelection::LangSelection() {
	load_fade;
	load_wh(m,"data/misc/langm.png",1,1);
	msprite.SetPosition(screen_w/2,screen_h/4);
	load_wh(es,"data/misc/langes.png",1,1);
	load_wh(ess,"data/misc/langess.png",1,1);
	load_wh(en,"data/misc/langen.png",1,1);
	load_wh(ens,"data/misc/langens.png",1,1);
	essprite.SetPosition(screen_w/2,screen_h/2);
	esssprite.SetPosition(screen_w/2,screen_h/2);
	ensprite.SetPosition(screen_w/2,screen_h/2+100);
	enssprite.SetPosition(screen_w/2,screen_h/2+100);
	spanish=false;
}

void LangSelection::Run() {
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	Fade(true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				return;
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				last_key=sf::Key::Escape; Fade(false); return;
			} else if (App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				last_key=sf::Key::Return; Fade(false); return;
			} else if(App->GetInput().IsKeyDown(sf::Key::Up) && last_key!=sf::Key::Up) {
				last_key=sf::Key::Up; config->spanish=!config->spanish;
			} else if(App->GetInput().IsKeyDown(sf::Key::Down) && last_key!=sf::Key::Down) {
				last_key=sf::Key::Down; config->spanish=!config->spanish;
			} else if(App->GetInput().IsKeyDown(sf::Key::Left) && last_key!=sf::Key::Left) {
				last_key=sf::Key::Left; config->spanish=!config->spanish;
			} else if(App->GetInput().IsKeyDown(sf::Key::Right) && last_key!=sf::Key::Right) {
				last_key=sf::Key::Right; config->spanish=!config->spanish;
			} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
				last_key=sf::Key::Count;
			}
		}
		Draw();
		App->TimedDisplay();
	}
}

void LangSelection::Draw() {
	App->Clear(Color(0,0,0,255));
	App->Draw(msprite);
	if (config->spanish) App->Draw(esssprite); else App->Draw(enssprite);
	App->Draw(essprite);
	App->Draw(ensprite);
}

implement_fade(LangSelection);


