#include "MyFont.h"
#include "global.h"
#include <cstring>
using namespace std;

MyFont *font;

MyFont::MyFont() {
	Load();
}

void MyFont::Reload() {
	if (global_scale==my_global_scale) return;
	for (int i=0;i<256;i++) {
		if (sprs[i]) delete imgs[i];
		if (imgs[i]) delete sprs[i];
	}
	Load();
}

void MyFont::Load() {
	
	my_global_scale=global_scale;
	
	for (int i=0;i<256;i++) { sprs[i]=NULL; imgs[i]=NULL; }
	
	string file="data/font/X.png";
	int space=5/my_global_scale;
	for (int x='a';x<='z';x++) {
		file[10]=x;
		imgs[x]=new Image();
		imgs[x]->LoadFromFile(fix_image_file(file));
		sprs[x]=new Sprite(*imgs[x]);
		ws[x]=imgs[x]->GetWidth();
		sprs[x]->SetCenter(0,imgs[x]->GetHeight());
		ws[x]+=space;
	}
	sprs[int('q')]->SetCenter(0,imgs[int('q')]->GetHeight()-5/global_scale);
	for (int x='0';x<='9';x++) {
		file[10]=x;
		imgs[x]=new Image();
		imgs[x]->LoadFromFile(fix_image_file(file));
		sprs[x]=new Sprite(*imgs[x]);
		ws[x]=imgs[x]->GetWidth();
		sprs[x]->SetCenter(0,imgs[x]->GetHeight());
		ws[x]+=space;
	}
	
	int x='.';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/dot.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight());
	ws[x]+=space;

	x='|';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/pipe.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()*.8);
	ws[x]+=space;

	x='\"';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/quotes.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()*3);
	ws[x]+=space;

	x='/';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/slash.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight());
	ws[x]+=space;

	x=27;
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/escape.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()-15/global_scale);
	ws[x]+=space;
	
	x=1;
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/help.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()-15/global_scale);
	ws[x]+=space;
	
	x='@';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/at.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight());
	ws[x]+=space;
	
	x=(unsigned char)'';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/enie.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight());
	ws[x]+=space;
	
	x='?';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/question.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight());
	ws[x]+=space;
	
	x=(unsigned char)'';
	sprs[x]=new Sprite(*imgs['?']);
	sprs[x]->FlipY(true); sprs[x]->FlipX(true);
	ws[x]=imgs['?']->GetWidth();
	sprs[x]->SetCenter(0,imgs['?']->GetHeight());
	ws[x]+=space;
	
	x='!';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/exclamation.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight());
	ws[x]+=space;
	
	x=',';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/comma.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()*.6);
	ws[x]+=space;
	
	x='\'';
	sprs[x]=new Sprite(*imgs[int(',')]);
	ws[x]=imgs[int(',')]->GetWidth();
	sprs[x]->SetCenter(0,imgs[int(',')]->GetHeight()*3);
	ws[x]+=space;
	
	
	x='(';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/parenthesis.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()*.9);
	ws[x]+=space;
	
	x=')';
	sprs[x]=new Sprite(*imgs[int('(')]);
	ws[x]=imgs[int('(')]->GetWidth();
	sprs[x]->SetCenter(0,imgs[int('(')]->GetHeight()*.9);
	ws[x]+=space;
	sprs[x]->FlipX(true);
	
	x='<';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/less.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()*1.05);
	ws[x]+=space;
	
	x='>';
	sprs[x]=new Sprite(*imgs[int('<')]);
	ws[x]=imgs[int('<')]->GetWidth();
	sprs[x]->SetCenter(0,imgs[int('<')]->GetHeight()*1.05);
	ws[x]+=space;
	sprs[x]->FlipX(true);
	
	x=':';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/two_dots.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()*1.3);
	ws[x]+=space;
	
	x='+';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/plus.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[x]->GetHeight()*1.3);
	ws[x]+=space;

	x='-';
	imgs[x]=new Image();
	imgs[x]->LoadFromFile(fix_image_file("data/font/minus.png"));
	sprs[x]=new Sprite(*imgs[x]);
	ws[x]=imgs[x]->GetWidth();
	sprs[x]->SetCenter(0,imgs[int('/')]->GetHeight()/2);
	ws[x]+=space;

	x='_';
	sprs[x]=new Sprite(*imgs[int('-')]);
	ws[x]=imgs[int('-')]->GetWidth();
	sprs[x]->SetCenter(0,imgs[int('-')]->GetHeight()*0.25);
	ws[x]+=space;
	
	for (int x='a';x<='z';x++) {
		sprs[x-'a'+'A']=sprs[x];
		ws[x-'a'+'A']=ws[x];
	}
	
//	for (int i=0;i<256;i++) ws[i]-=my_global_scale;
}


void MyFont::RenderSmall(real x,real y, real z, const char *s1,int n1,const char *s2, int n2) {
	const char *c=s1; char *b=buffer;
	while (*c) *(b++)=*(c++);
	*(b++)=n1/10+'0';*(b++)=n1%10+'0';
	c=s2; 
	while (*c) *(b++)=*(c++);
	*(b++)=n2/10+'0';*(b++)=n2%10+'0';
	*b='\0';
	RenderSmall(x,y,z,buffer);
}

void MyFont::RenderSmall(real x,real y, real z, const char *s1,int n1) {
	const char *c=s1; char *b=buffer;
	while (*c) *(b++)=*(c++);
	*(b++)=n1/10+'0';*(b++)=n1%10+'0';
	*b='\0';
	RenderSmall(x,y,z,buffer);
}

void MyFont::RenderSmall(real x,real y, real z, int n1, const char *s1) {
	const char *c=s1; char *b=buffer;
	*(b++)=n1/10+'0';*(b++)=n1%10+'0';
	while (*c) *(b++)=*(c++);
	*b='\0';
	RenderSmall(x,y,z,buffer);
}

void MyFont::RenderTime(real x,real y, real z, real sec) {
	char *b=buffer;
	int m = int (sec/60);
	int s = int (sec)%60;
	int f = int(sec*100)%100;
	*(b++)=m/10+'0';*(b++)=m%10+'0';
	*(b++)=':';
	*(b++)=s/10+'0';*(b++)=s%10+'0';
	*(b++)='.';
	*(b++)=f/10+'0';*(b++)=f%10+'0';
	*(b++)=0;
	RenderSmall(x,y,z,buffer);
}

real MyFont::Ancho(const char *s, real z) {
	z*=my_global_scale;
	const char *c=s;
	real dx=0;
	while (*c) {
		if (*c==' ') 
			dx+=10;
		else {
			dx+=ws[int((unsigned char)*c)];
		}
		c++;
	}
	return dx*z;
}

void MyFont::RenderSmall(real x,real y, real z, const char *s) {
	z*=my_global_scale;	
	const char *c=s;
	real dx=0;
	while (*c) {
		int t=(unsigned char)*c;
		if (t==' ') 
			dx+=10*z/my_global_scale;
		else {
			sprs[t]->SetPosition(x+dx,y);
			if (t>='a'&&t<='z')
				sprs[t]->SetScale(z,z*.8);
			else
				sprs[t]->SetScale(z,z);
			App->Draw(*sprs[t]);
			dx+=ws[t]*z;
		}
		c++;
	}
}

void MyFont::RenderPartialI(real x,real y, real z, const string &s, int n) {
	if (!n) return;
	strcpy(buffer,s.c_str());
	buffer[n]='\0';
	RenderSmall(x-Ancho(buffer,z),y,z,buffer);
}

void MyFont::RenderPartial(real x,real y, real z, const string &s, int n) {
	if (!n) return;
	strcpy(buffer,s.c_str());
	buffer[n]='\0';
	RenderSmall(x,y,z,buffer);
}

void MyFont::RenderSmall(real x,real y, real z, real t) {
	char *c = buffer;
	if (t>1000) {
		*(c++)='x';
		*(c++)='x';
		*(c++)='x';
		*(c++)='.';
		*(c++)='x';
		*(c++)='x';
	} else {
		int pe=int(t);
		int pd=int((t-pe)*100);
		int ce=int(pe/100);
		if (ce) *(c++)=ce+'0';
		else { *(c++)=' '; *(c++)=' '; }
		*(c++)=int(pe/10)%10+'0';
		*(c++)=pe%10+'0';
		*(c++)='.';
		*(c++)=pd/10+'0';
		*(c++)=pd%10+'0';
	}
	*c='\0';
	RenderSmall(x,y,z,buffer);
}

void MyFont::RenderSmall(real x,real y, real z, int t) {
	char *c = buffer;
	if (t>100) {
		*(c++)='x';
		*(c++)='x';
		*(c++)='x';
	} else {
		*(c++)=t/10+'0';
		*(c++)=t%10+'0';
	}
	*c='\0';
	RenderSmall(x,y,z,buffer);
}

void MyFont::RenderCenter(real x,real y, real z, const char *s) {
	RenderSmall(x-Ancho(s,z)/2,y,z,s);
}
