#include "Profile.h"
#include "ChampionshipData.h"
#include "global.h"

Profile *profile;

static int str2int(string s) {
	unsigned int i=0, r=0;
	while (i<s.size() && s[i]>='0' && s[i]<='9')
		r=r*10+s[i++]-'0';
	return r;
}

Profile::Profile(string afile) {
	CERR("Profile::Profile("<<afile<<")...");
	on_championship=false;
	bike=0; tips_seen=0; avail_tracks=champ_avail_tracks[0];
	accel=brake=turn=vel=0;
	for (int i=0;i<track_max;i++) {
		best_lap[i]=-1; pts[i]=0;
	}
	
	file=afile;
	string s,k,v; int i;
	ifstream fil(file.c_str());
	while (getline(fil,s)) {
		if (!s.size() || s[0]=='#') continue;
		size_t p=s.find('=');
		if (p==string::npos) continue;
		k=s.substr(0,p);
		v=s.substr(p+1);
		if (k=="name") name=v;
		else if (k=="avail_tracks") avail_tracks=str2int(v);
		else if (k=="tips_seen") tips_seen=str2int(v);
		else if (k=="championship") on_championship=(v=="1");
		else if (k=="bike" ) bike=data->FindBike(v);
		else if (k=="accel") accel=str2int(v);
		else if (k=="vel") vel=str2int(v);
		else if (k=="turn") turn=str2int(v);
		else if (k=="brake") brake=str2int(v);
		else if (k.size()>5 && k.substr(0,5)=="best_") {
			k=k.substr(5);
			if ((i=data->FindTrack(k))>=0) 
				best_lap[i]=atof(v.c_str());
		}
		else if (k.size()>4 && k.substr(0,4)=="pts_") {
			k=k.substr(4);
			if ((i=data->FindTrack(k))>=0) 
				pts[i]=atoi(v.c_str());
		}
	}
	if (bike<0) bike=0;
	fil.close();
	changed=false;
}

void Profile::SetRecord(string id, real t) {
	int i=data->FindTrack(id); if (i<0) return;
	best_lap[i]=t; changed=true;
}

void Profile::Save(bool forced) {
	CERR("Profile::Save...");
	if (!changed && !forced) return;
	ofstream fil(file.c_str(),ios::trunc);
	fil<<"name="<<name<<endl;
	fil<<"bike="<<data->bikes[bike].id<<endl;
	fil<<"avail_tracks="<<avail_tracks<<endl;
	fil<<"tips_seen="<<tips_seen<<endl;
	fil<<"championship="<<(on_championship?"1":"0")<<endl;
	fil<<"accel="<<accel<<endl;
	fil<<"vel="<<vel<<endl;
	fil<<"turn="<<turn<<endl;
	fil<<"brake="<<brake<<endl;
	for (int i=0;i<data->track_count;i++) {
		if (best_lap[i]>0)
			fil<<"best_"<<data->tracks[i].id<<"="<<best_lap[i]<<endl;
		if (pts[i]>0)
			fil<<"pts_"<<data->tracks[i].id<<"="<<pts[i]<<endl;
	}
	fil.close();
}

void Profile::ChangeBike(int cred_vel, int cred_accel, int cred_brake, int cred_turn, int abike) {
	if (cred_vel!=vel) { vel=cred_vel; changed=true; }
	if (cred_accel!=accel) { accel=cred_accel; changed=true; }
	if (cred_brake!=brake) { brake=cred_brake; changed=true; }
	if (cred_turn!=turn) { turn=cred_turn; changed=true; }
	if (abike!=bike) { bike=abike; changed=true; }
	Save();
}

int Profile::GetPoints() {
	int p=0;
	for (int i=0;i<track_max;i++)
		p+=pts[i];
	return p;
}

int Profile::UpdatePoints(int track_num, int level, int pos) {
	if (pos>3) return 0;
	int np = pts_bike[level-1][pos-1];
	int op = pts[track_num];
	if (np<=op) return 0;
	pts[track_num]=np;
	changed=true;
	Save();
	return np-op;
}

Profile::~Profile() { 
	CERR("Profile::~Profile...");
	delete championship_data; championship_data=NULL; 
}

void Profile::LoadChampionshipData() {
	if (on_championship) {
		string fname=file.substr(0,file.size()-4)+".cps";
		championship_data=new ChampionshipData(fname);
	} else
		championship_data=new ChampionshipData();
}

void Profile::RetireFromChampionship() {
	delete championship_data; championship_data=NULL;
	if (on_championship) {on_championship=false; changed=true; Save();}
}
