#include "Records.h"
#include "Config.h"
#include "Jukebox.h"
#include "SelectionWheel.h"
#include "MyFont.h"
#include <cstring>
using namespace std;

static char *time2str(real sec) {
	static char buf[15];
	if (sec<0) {
		strcpy(buf,"--:--.--");
		return buf;
	}
	char *b=buf;
	int m = int (sec/60);
	int s = int (sec)%60;
	int f = int(sec*100)%100;
	*(b++)=m/10+'0';*(b++)=m%10+'0';
	*(b++)=':';
	*(b++)=s/10+'0';*(b++)=s%10+'0';
	*(b++)='.';
	*(b++)=f/10+'0';*(b++)=f%10+'0';
	*(b++)=0;
	return buf;
}

static string int2str(int x) {
	static char r[4]; 
	r[1]=r[2]=r[3]='\0';
	if (x<10) { r[0]='0'+x; }
	else if (x<100) { r[0]='0'+x/10; r[1]='0'+x%10; }
	else { r[0]='0'+x/100; r[1]='0'+(x%100)/10; r[2]='0'+x%10; }
	return r;
}

Records::Records() {
	load_fade;
	load_wh(bk,fix_image_file("data/menu/scores_back.png"),1,1);
	bksprite.SetCenter(0,0); bksprite.SetPosition(0,0);
	load_wh(t,fix_image_file("data/menu/scores_top.png"),1,1);
	tsprite.SetCenter(0,0); bksprite.SetPosition(0,0);
	load_wh(b,fix_image_file("data/menu/scores_bottom.png"),1,1);
	bsprite.SetCenter(0,bimage.GetHeight()); bsprite.SetPosition(0,screen_h);
	load_wh(m,fix_image_file(config->spanish?"data/menu/scores_es.png":"data/menu/scores_en.png"),1,1);
	msprite.SetPosition(685,screen_h/2-15);
}

void Records::Run() {
	mcol=Color(255,255,255,0);
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	LoadChamps();
	tostart=20;
	Fade(true);
	App->SetView(*view);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				return;
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				if (config->sound_on) music->snd_selcancel.Play();
				last_key=sf::Key::Escape; Fade(false); return;
			} else if (App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				last_key=sf::Key::Return; 
				if (showing_laps) { Fade(false); return; } else LoadLaps();
			} else if(App->GetInput().IsKeyDown(sf::Key::Up) && last_key!=sf::Key::Up) {
				last_key=sf::Key::Up; Move(true); 
			} else if(App->GetInput().IsKeyDown(sf::Key::Down) && last_key!=sf::Key::Down) {
				last_key=sf::Key::Down;  Move(false);
			} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
				last_key=sf::Key::Count;
			}
		}
		Draw();
		App->TimedDisplay();
	}
}

void Records::Draw() {
	
	App->Draw(bksprite);
	msprite.SetColor(mcol);
	App->Draw(msprite);
	
	delta_y = (6*delta_y+pos[0][1]-pos[target*4][1])/7;
	
	if (tostart) tostart--; else {

		if (cant_results==0) {
			for (int i=3;i<7;i++) {
				font->RenderPartial((594-font->Ancho(items[i].c_str(),.55))/2,80+50*i,.55,items[i],charsdone[i]/char_speed/2);
				if (charsdone[i]==2*char_speed*items[i].size()) continue; charsdone[i]++;
			}
		} else if (ncols==3) {
			for (int i=0;i<3*cant_results;i++) {
				font->RenderPartial(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
				i++;
				font->RenderPartialI(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
				i++;
				font->RenderPartialI(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
			}
		} else {
			for (int i=0;i<3*cant_results;i++) {
				font->RenderPartialI(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
				i++;
				font->RenderPartial(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
				i++;
				font->RenderPartialI(pos[i][0],pos[i][1]+delta_y,.55,items[i],charsdone[i]/char_speed/2);
			}
		}
		for (int i=0;i<3*cant_results;i++) { 
			if (charsdone[i]==2*char_speed*items[i].size()) continue; charsdone[i]++;
		}
		
		App->Draw(bsprite);
		App->Draw(tsprite);
		
		for (int i=3*cant_results;i<3*cant_results+3;i++) {
			font->RenderPartial(pos[i][0],pos[i][1],.80,items[i],charsdone[i]/char_speed/2);
			if (charsdone[i]==2*char_speed*items[i].size()) continue; charsdone[i]++;
		}
	}
	if (mcol.a<255) mcol.a++;
	mcol.r=mcol.g=mcol.b=mcol.a;
	sel_wheel->Draw(595,565);
}

void Records::Move(bool up) {
	if (up) {
		if (target>0) target--;
	} else {
		if (target<cant_results-8) target++;
	}
}

void Records::LoadLaps() {
	
	showing_laps=true;
	target=0; ncols=3; delta_y=0;
	cant_results=data->track_count;
	for (int i=0;i<cant_results;i++) {
		items[3*i]=data->tracks[i].name;
		items[3*i+1]=data->tracks[i].best_name;
		items[3*i+2]=time2str(data->tracks[i].best_time);
	}
	
	for (int i=0;i<cant_results;i++) {
		pos[3*i][0]=50; pos[3*i+1][0]=415; pos[3*i+2][0]=545;
		pos[3*i+2][1]=pos[3*i][1]=pos[3*i+1][1]=170+i*40;
	}
	
	items[3*cant_results] = config->spanish?"MEJORES PILOTOS":"BEST RIDERS";
	pos[3*cant_results][0] = (screen_w-font->Ancho(items[3*cant_results].c_str(),.8))/2; pos[3*cant_results][1] = 45;
	items[3*cant_results+1] = config->spanish?"Continuar":"Continue";
	pos[3*cant_results+1][0] = 590; pos[3*cant_results+1][1] = 570;
	items[3*cant_results+2] = config->spanish?"Mejor Vuelta por Circuito":"Track's Best Laps";
	pos[3*cant_results+2][0] = (594-font->Ancho(items[3*cant_results+2].c_str(),.8))/2; pos[3*cant_results+2][1] = 120;
	for (int i=0;i<3*cant_results+3;i++) charsdone[i]=0;
	charsdone[3*cant_results]=items[3*cant_results].size()*char_speed*2;
}

void Records::LoadChamps() {
	showing_laps=false;
	target=0; ncols=2; delta_y=0;
	cant_results=data->champ_records_count;
	if (cant_results) {
		for (int i=0;i<cant_results;i++) {
			items[3*i]=int2str(i+1);
			items[3*i+1]=data->champ_records[i].name;
			items[3*i+2]=int2str(data->champ_records[i].pts);
		}
		for (int i=0;i<cant_results;i++) {
			pos[3*i][0]=120; pos[3*i+1][0]=150; pos[3*i+2][0]=475;
			pos[3*i+1][1]=pos[3*i+2][1]=pos[3*i][1]=170+i*40;
		}
	} else {
		charsdone[3]=charsdone[4]=charsdone[5]=charsdone[6]=0;
		items[3]=config->spanish?"Nadie ha comletado":"Nobody has finished a";
		items[4]=config->spanish?"un campeonato aun. Puedes":"championship yet. Be";
		items[5]=config->spanish?"ser el primero en hacerlo":"the first to do it and";
		items[6]=config->spanish?"y que tu nombre se lea aqui.":"have your name listed here";
	}
	items[3*cant_results] = config->spanish?"MEJORES PILOTOS":"BEST RIDERS";
	pos[3*cant_results][0] = (screen_w-font->Ancho(items[3*cant_results].c_str(),.8))/2; pos[3*cant_results][1] = 45;
	items[3*cant_results+1] = config->spanish?"Continuar":"Continue";
	pos[3*cant_results+1][0] = 590; pos[3*cant_results+1][1] = 570;
	items[3*cant_results+2] = config->spanish?"Max. Puntaje en Campeonato":"Top Championship's Scores";
	pos[3*cant_results+2][0] = (594-font->Ancho(items[3*cant_results+2].c_str(),.8))/2; pos[3*cant_results+2][1] = 120;
	for (int i=0;i<3*cant_results+3;i++) charsdone[i]=0;
}


implement_fade(Records);
