#include "TrackSelection.h"
#include "Data.h"
#include "MyFont.h"
#include "SelectionWheel.h"
#include <sstream>
#include "global.h"
#include "Loading.h"
#include "Profile.h"
#include "Config.h"
#include "Confirm.h"
#include "ChampionshipData.h"
#include "Jukebox.h"
using namespace std;

#define init_item(key,text,x,y) items[key]=text; pos[key][0]=x; pos[key][1]=y; charsdone[key]=0; sel_level[key]=0; selected[key]=false;

int TrackSelection::laps=5;
int TrackSelection::level=1;

real TrackSelection::current_track=0;
int TrackSelection::target_track=0;


static string int2str(int x) {
	stringstream s;
	s<<x;
	return s.str();
}

static char *time2str(real sec) {
	static char buf[15];
	if (sec<=0) {
		buf[0]='-'; buf[1]='-'; buf[2]=':'; buf[3]='-';
		buf[4]='-'; buf[5]='.'; buf[6]='-'; buf[7]='-';
		buf[8]='\0'; return buf;
	}
	char *b=buf;
	int m = int (sec/60);
	int s = int (sec)%60;
	int f = int(sec*100)%100;
	*(b++)=m/10+'0';*(b++)=m%10+'0';
	*(b++)=':';
	*(b++)=s/10+'0';*(b++)=s%10+'0';
	*(b++)='.';
	*(b++)=f/10+'0';*(b++)=f%10+'0';
	*(b++)=0;
	return buf;
}

TrackSelection::TrackSelection() {
	loading->Draw();
	load_wh(ws,fix_image_file("data/misc/wsun.png"),1,1);
	load_wh(wl,fix_image_file("data/misc/lock.png"),1,1);
	load_wh(wr,fix_image_file("data/misc/wrain.png"),1,1);
	load_wh(wn,fix_image_file("data/misc/wnight.png"),1,1);
	load_fade;
	load_wh(b,fix_image_file("data/menu/selback.png"),1,1);
	bsprite.SetPosition(screen_w/2,screen_h/2);
	if (config->extra_fx) {
		load_wh(r,fix_image_file("data/menu/selref.png"),1,1);
		rsprite.SetCenter(0,rimage.GetHeight());
		rsprite.SetPosition(0,screen_h);
	}
	
	itracks = new Image[data->track_count];
	stracks = new Sprite[data->track_count];
	for (int i=0;i<data->track_count;i++) {
		itracks[i].LoadFromFile(fix_image_file(data->tracks[i].dir+"thumbnail.png"));
		stracks[i].SetImage(itracks[i]);
		stracks[i].SetCenter(itracks[i].GetWidth()/2,3*itracks[i].GetHeight()/4);
	}
	
	int x1=100,x2=300,x3=550,x4=620,y=125;
	
	init_item(mit_name,config->spanish?"Circuito:":"Track Name:",x1,y+0);
	init_item(mit_name_value,"<>",x2,y+0);
	init_item(mit_laps,config->spanish?"Vueltas:":"Laps:",x1,y+50);
	init_item(mit_laps_value,string("<")+int2str(laps)+">",x2,y+50);
	init_item(mit_level,config->spanish?"Dificultad":"Difficulty:",x1,y+100);
	string slevel=config->spanish?"<facil>":"<easy>";
	if (level==2) slevel=config->spanish?"<normal>":"<normal>";
	if (level==3) slevel=config->spanish?"<dificil>":"<hard>";
	init_item(mit_level_value,slevel,x2,y+100);
//	init_item(mit_opponents,"Opponents:",x1,y+150);
//	init_item(mit_opponents_value,"<14>",x2,y+150);
	init_item(mit_fastlap,config->spanish?"Mejor Vlt. Abs.":"Absolute Best Lap",x3,y-40);
	init_item(mit_fastlap_name,"lala",x4,y-4);
	init_item(mit_fastlap_value,"01:04.56",x4,y+30);
	init_item(mit_personallap,config->spanish?"Mejor Vlt. Pers.":"Personal Best Lap",x3,y+75);
	init_item(mit_personallap_value,"--:--.--",x4,y+110);
	init_item(mit_pts,config->spanish?"Pts. de Exp.:":"Exp. Credits:",x3,y+160);
	init_item(mit_pts_value,"0",x3+150,y+160);
	init_item(mit_race,config->spanish?"CONTINUAR":"CONTINUE",135,330);
	
	for (int i=0;i<mit_count;i++) visible[i]=true;
	
}

void TrackSelection::Reset() {
	for (int i=0;i<mit_count;i++) selected[i]=false;
	for (int i=mit_name+2*(num_opts+1);i<mit_race;i++) visible[i]=false;
	for (int i=mit_name;i<mit_name+2*(num_opts+1);i++) visible[i]=true;
	selection=mit_race; selected[selection]=true; selected[selection+1]=true;
	tostart=10;
}

TrackSelection::~TrackSelection() {
	delete [] itracks;
	delete [] stracks;
}

void TrackSelection::Draw() {
	
	App->Draw(bsprite);
	
	font->RenderSmall(300,60,.75,config->spanish?"Conf. Carrera":"Race Set-up");
	
	if (tostart) {
		tostart--;
	} else {
		for (int i=0;i<mit_count;i++) {
			if (!visible[i]) continue;
			if (selected[i]) {
				if (sel_level[i]<8) sel_level[i]+=1;
			} else {
				if (sel_level[i]>0) sel_level[i]-=1;
			}
			font->RenderPartial(pos[i][0]-sel_level[i],pos[i][1]+sel_level[i],.55+.025*sel_level[i],items[i],charsdone[i]/char_speed);
			if (charsdone[i]==char_speed*items[i].size()) continue; charsdone[i]++;
		}
	}
	
	sel_wheel->Draw(pos[selection][0],pos[selection][1]);

	current_track = (target_track+9*current_track	)/10;
	while (current_track-4<0) { current_track+=data->track_count; target_track+=data->track_count; }
	
	if (config->extra_fx) {
		for (int i=-3;i<3;i++) {
			int t = (int(current_track)+i)%data->track_count;
			real d = current_track-int(current_track)-i;
			real ud = d<0?-d:d;
			if (ud>1) ud=1;
			stracks[t].FlipY(true);
			stracks[t].SetScale(global_scale*(2-ud)/4,global_scale*(2-ud)/4);
			stracks[t].SetPosition(530-d*225,505+100+100*(1-ud));
			App->Draw(stracks[t]);
			stracks[t].FlipY(false);
		}
		App->Draw(rsprite);
	}
	for (int i=-3;i<3;i++) {
		int t = (int(current_track)+i)%data->track_count;
		real d = current_track-int(current_track)-i;
		real ud = d<0?-d:d;
		if (ud>1) ud=1;
		real s=global_scale*(2-ud)/4;
		stracks[t].SetScale(s,s);
		stracks[t].SetPosition(530-d*225,505);
		Sprite *ps = &(data->tracks[t].weather=='n'?wnsprite:(data->tracks[t].weather=='r'?wrsprite:wssprite));
		if (profile&&t>=profile->avail_tracks) ps=&wlsprite;
		App->Draw(stracks[t]);
		ps->SetPosition(530-d*235+s*150/global_scale,525-s*300/global_scale);
		ps->SetScale(s,s);
		App->Draw(*ps);
	}
	
}

bool TrackSelection::Select(int anum_opts) {

	num_opts=anum_opts;
	
	Reset(); LoadTrackData();
	
	Fade(true);
	while (true) {
		
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed) {
				Fade(false);return false;
			}
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			if (config->sound_on) music->snd_selcancel.Play();
			last_key=sf::Key::Escape; Fade(false); return false;
		} } else if(App->GetInput().IsKeyDown(sf::Key::Return)) { if (last_key!=sf::Key::Return) {
			last_key=sf::Key::Return; 
			if (SelOk()) { 
				Fade(false); 
				target_track=target_track%data->track_count;
				return true;
			}
		} } else if(App->GetInput().IsKeyDown(sf::Key::Up)) { if (last_key!=sf::Key::Up) {
			last_key=sf::Key::Up; SelMove(true);
		} } else if(App->GetInput().IsKeyDown(sf::Key::Down)) { if (last_key!=sf::Key::Down) {
			last_key=sf::Key::Down; SelMove(false);
		} } else if(App->GetInput().IsKeyDown(sf::Key::Left)) { if (last_key!=sf::Key::Left) {
			last_key=sf::Key::Left; SelChange(false);
		} } else if(App->GetInput().IsKeyDown(sf::Key::Right)) { if (last_key!=sf::Key::Right) {
			last_key=sf::Key::Right; SelChange(true);
//			} } else if(App->GetInput().IsKeyDown(sf::Key::H)) { if (last_key!=sf::Key::H) {
//				last_key=sf::Key::H; show_help=!show_help;
		} } else last_key=sf::Key::Count;
		
		Draw();
		App->TimedDisplay();
	}
}

bool TrackSelection::SelOk() {
	if (config->sound_on) music->snd_selok.Play();
	if (profile && target_track%data->track_count>=profile->avail_tracks)  {
		confirm->Tell2(this,
			config->spanish?"Tienes que ganar campeonatos":"You have to win in championship",
			config->spanish?"para desbloquear esta pista":"mode to unlock this track.");
		return false;
	}
	if (selection==mit_name) {
		Zoom();
	} else if (selection==mit_race)
		return true;
	return false;
}

void TrackSelection::SelMove(bool up) {
	if (config->sound_on) music->snd_selmove.Play();
	if (up) {
		if (selection==mit_name) return;
		selected[selection]=false;
		if (selection==mit_race) {
			selection=mit_name+2*num_opts;
		} else {
			selected[selection+1]=false;
			selection-=2;
		}
		selected[selection]=true;
		selected[selection+1]=true;
	} else {
		if (selection==mit_race) return;
		selected[selection]=false;
		selected[selection+1]=false;
		if (selection==mit_name+num_opts*2) {
			selection=mit_race;
		} else {
			selection+=2;
			selected[selection+1]=true;
		}
		selected[selection]=true;
	}
}

void TrackSelection::SelChange(bool right) {
	if (config->sound_on) music->snd_selmove.Play();
	if (selection==mit_name) {
		if (championship_data) {
			confirm->Tell2(this,
				config->spanish?"No podes modificar el":"You cannot modify",
				config->spanish?"calendario del campeonato.":"Championship's calendar. ");
			return;
		}
		
		if (right) {
			target_track++;
		} else {
			target_track--;
		}
		LoadTrackData();
	} else if (selection==mit_laps) {
		if (right) {
			if (laps<50) {
				laps++;
				items[mit_laps_value]=string("<")+int2str(laps)+">";
				charsdone[mit_laps_value]=items[mit_laps_value].size()*char_speed;
			}
		} else {
#ifdef DEBUG
			if (laps>0+level) 
#else
			if (laps>2+level) 
#endif
			{
				laps--;
				items[mit_laps_value]=string("<")+int2str(laps)+">";
				charsdone[mit_laps_value]=items[mit_laps_value].size()*char_speed;
			}
		}
	} else if (selection==mit_level) {
		if (right) {
			if (level<3) level++;
			if (laps<2+level) {
				laps=2+level;
				items[mit_laps_value]=string("<")+int2str(laps)+">";
				charsdone[mit_laps_value]=items[mit_laps_value].size()*char_speed;
			}
		} else {
			if (level>1) level--;
		}
		string s=config->spanish?"<facil>":"<easy>";
		if (level==2) s=config->spanish?"<normal>":"<normal>";
		if (level==3) s=config->spanish?"<dificil>":"<hard>";
		if (items[mit_level_value]!=s) {
			items[mit_level_value]=s;
			charsdone[mit_level_value]=0;
		}
	}
}

void TrackSelection::LoadTrackData() {
	while (target_track<0) {
		target_track+=data->track_count;
		current_track+=data->track_count;
	}
	int i=target_track%data->track_count;
	string s=string("<")+data->tracks[i].name+">";
	items[mit_personallap_value]=time2str(profile->best_lap[i]);
	items[mit_fastlap_name]=data->tracks[i].best_name;
	items[mit_fastlap_value]=time2str(data->tracks[i].best_time);
	charsdone[mit_fastlap_value]=charsdone[mit_fastlap_name]=charsdone[mit_personallap_value]=1;
	items[mit_pts_value]=int2str(profile->pts[i]); charsdone[mit_pts_value]=0;
	if (items[mit_name_value]==s) return;
	items[mit_name_value]=s; charsdone[mit_name_value]=1;
}

void TrackSelection::Zoom() {
	real d;
	while (true) {
		if (current_track>target_track) d=current_track-target_track;
		else d=target_track-current_track;
		if (d<.1) break;
		Draw(); App->TimedDisplay();
	}
	int i=target_track%data->track_count;
	real zoom=0;
	if (config->extra_fx) {
		while (zoom<=1) {
			zoom+=.1;
			Draw();
			stracks[i].SetPosition(530*(1-zoom)+screen_w/2*zoom,505*(1-zoom)+425*zoom);
			stracks[i].SetScale(global_scale*((1-zoom)/2+1.25*zoom),global_scale*((1-zoom)/2+1.25*zoom));
			fsprite.SetColor(Color(255,255,255,int(zoom*218)));
			App->Draw(fsprite);
			App->Draw(stracks[i]);
			App->TimedDisplay();
		}
	} else zoom=1;
	bool done=false;
	while (!done) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed) {
				done=true;
			}
		}
		if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
			last_key=sf::Key::Escape; done=true;
		} else if(App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
			last_key=sf::Key::Return; done=true;
		} else if (!App->GetInput().IsKeyDown(sf::Key::Return) && !App->GetInput().IsKeyDown(sf::Key::Escape)) {
			last_key=sf::Key::Count;
		}
		Draw();
		stracks[i].SetPosition(screen_w/2*zoom,425);
		stracks[i].SetScale(global_scale*1.25,global_scale*1.25);
		App->Draw(fsprite);
		App->Draw(stracks[i]);
		App->TimedDisplay();
	}
	if (config->extra_fx) {
		while (zoom>0) {
			Draw();
			stracks[i].SetPosition(530*(1-zoom)+screen_w/2*zoom,505*(1-zoom)+425*zoom);
			stracks[i].SetScale(global_scale*((1-zoom)/2+1.25*zoom),global_scale*((1-zoom)/2+1.25*zoom));
			fsprite.SetColor(Color(255,255,255,int(zoom*218)));
			App->Draw(fsprite);
			App->Draw(stracks[i]);
			App->TimedDisplay();
			zoom-=.1;
		}
	}
	
}

implement_fade(TrackSelection)
