/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.MusicConfiguration;
import dk.borderworlds.MusicPipe;
import dk.borderworlds.MusicPlayer;
import dk.borderworlds.Song;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mp3Player
extends MusicPlayer
implements Runnable {
    private Song song = null;
    private Process proc = null;
    private BufferedInputStream bis;
    String name;
    private Thread inputreader;
    private String status;
    private byte[] statusLine;
    private String title;
    private String filename;
    private int pausePosition;
    private MusicConfiguration configuration;
    private MusicPipe pipe;

    public Mp3Player(MusicConfiguration musicConfiguration) {
        this.configuration = musicConfiguration;
    }

    public void playSong(Song song) {
        this.song = song;
        this.playSong(0);
    }

    public void playSong(int n) {
        this.status = n == 0 ? "Starting" : "Resuming";
        this.title = this.song.getFilename();
        this.filename = this.song.getFilename();
        Runtime runtime = Runtime.getRuntime();
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.proc = null;
        }
        try {
            int n2;
            String string = this.configuration.getDevice();
            int n3 = n2 = this.pausePosition == 0 ? 3 : 5;
            if (string.equals("STDOUT")) {
                ++n2;
            }
            String[] stringArray = new String[n2];
            stringArray[0] = "mpg123";
            stringArray[1] = "-v";
            if (string.equals("STDOUT")) {
                stringArray[2] = "-s";
            }
            if (this.pausePosition != 0) {
                stringArray[n2 - 3] = "-k";
                stringArray[n2 - 2] = "" + this.pausePosition;
            }
            stringArray[n2 - 1] = this.song.getDirectory() + File.separator + this.song.getFilename();
            this.proc = runtime.exec(stringArray);
            InputStream inputStream = this.proc.getErrorStream();
            this.pipe = new MusicPipe(this.proc.getInputStream());
            this.bis = new BufferedInputStream(inputStream);
            this.inputreader = new Thread(this);
            this.inputreader.start();
            this.status = "Playing";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseSong() {
        if (this.statusLine != null) {
            int n;
            for (n = 0; this.statusLine.length > 16 + n && this.statusLine[16 + n] != 32 && n < 6; ++n) {
            }
            String string = new String(this.statusLine, 16, n);
            this.pausePosition = Integer.parseInt(string);
        } else {
            this.pausePosition = 0;
        }
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            this.proc = null;
        }
    }

    public void resumeSong() {
        if (this.pausePosition != 0) {
            this.playSong(this.pausePosition);
            this.pausePosition = 0;
        }
    }

    public void stopSong() {
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            this.proc = null;
            this.song = null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStatus() {
        if (this.status.equals("Retrying")) {
            this.playSong(0);
            return "Retrying";
        }
        if (this.status.equals("Playing") && this.bis == null) {
            if (this.pausePosition == 0) {
                this.status = "Stopped";
                this.song = null;
            } else {
                this.status = "Paused";
            }
        }
        return this.status;
    }

    public String getFilename() {
        if (this.song == null) {
            return "(none)";
        }
        return this.filename;
    }

    public String getTitle() {
        if (this.song == null) {
            return "(none)";
        }
        return this.title;
    }

    public String getPosition() {
        if (this.statusLine != null) {
            return new String(this.statusLine, 0, 5);
        }
        return "N/A";
    }

    public String getLength() {
        if (this.statusLine != null && this.statusLine[0] >= 48 && this.statusLine[0] <= 57) {
            int n = (Integer.parseInt(new String(this.statusLine, 0, 2)) * 100 * 60 + Integer.parseInt(new String(this.statusLine, 8, 2)) * 100 * 60 + Integer.parseInt(new String(this.statusLine, 3, 2)) * 100 + Integer.parseInt(new String(this.statusLine, 11, 2)) * 100 + Integer.parseInt(new String(this.statusLine, 6, 2)) + Integer.parseInt(new String(this.statusLine, 14, 2))) / 100;
            return (n / 60 < 10 ? "0" : "") + n / 60 + ":" + (n % 60 < 10 ? "0" : "") + n % 60;
        }
        return "N/A";
    }

    public boolean acceptsType(String string) {
        return string.equals("mp3");
    }

    public Song getSong() {
        return this.song;
    }

    public void run() {
        int n;
        boolean bl = true;
        byte[] byArray = new byte[1024];
        this.statusLine = new byte[22];
        byte[] byArray2 = new byte[256];
        int n2 = 0;
        for (n = 0; n < 22; ++n) {
            this.statusLine[n] = 32;
        }
        Pattern pattern = Pattern.compile("^Frame#\\s+(\\d+).*Time:\\s+(\\d{2}:\\d{2}\\.\\d{2})\\s+\\[(\\d{2}:\\d{2}\\.\\d{2})\\]");
        Pattern pattern2 = Pattern.compile("^Title\\s+:\\s+(.*?)\\s+Artist:");
        Pattern pattern3 = Pattern.compile("^Can't");
        while (bl) {
            try {
                n = this.bis.read(byArray, 0, 1024);
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        if (byArray[i] == 10 || byArray[i] == 13) {
                            String string = new String(byArray2, 0, n2);
                            Matcher matcher = pattern.matcher(string);
                            if (matcher.find()) {
                                this.statusLine = (matcher.group(2) + matcher.group(3) + matcher.group(1)).getBytes();
                            }
                            if ((matcher = pattern2.matcher(string)).find()) {
                                this.title = matcher.group(1);
                            }
                            if ((matcher = pattern3.matcher(string)).find()) {
                                this.status = "Retrying";
                            }
                            n2 = 0;
                            continue;
                        }
                        byArray2[n2++] = byArray[i];
                    }
                    continue;
                }
                if (n != -1) continue;
                this.bis.close();
                this.bis = null;
                bl = false;
            }
            catch (Exception exception) {
                if (!exception.getClass().getName().equals("java.io.IOException")) continue;
                this.bis = null;
                bl = false;
            }
        }
    }
}

