/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.SelectOnlyTableModel;
import dk.borderworlds.Song;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class MusicQueue
implements ActionListener,
MouseListener {
    private JTable table;
    private JScrollPane scrollPane;
    private JPanel panel;
    private JButton up;
    private JButton down;
    private JButton delete;
    private Vector rowData = new Vector();
    private Vector songs = new Vector();

    public MusicQueue(String string) {
        Vector<String> vector = new Vector<String>();
        vector.add("Directory");
        vector.add("Filename");
        this.table = new JTable(new SelectOnlyTableModel(this.rowData, (Vector)vector));
        this.table.addMouseListener(this);
        this.table.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(200, 103));
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JLabel(string), "North");
        this.panel.add((Component)this.scrollPane, "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        this.up = new JButton("Up");
        this.up.addActionListener(this);
        this.down = new JButton("Down");
        this.down.addActionListener(this);
        this.delete = new JButton("Delete");
        this.delete.addActionListener(this);
        jPanel.add(this.up);
        jPanel.add(this.down);
        jPanel.add(this.delete);
        this.panel.add((Component)jPanel, "South");
    }

    public Component getComponent() {
        return this.panel;
    }

    public void addSong(Song song) {
        this.addSong(song, false);
    }

    public void addSong(Song song, boolean bl) {
        if (bl) {
            this.songs.add(0, song);
        } else {
            this.songs.add(song);
        }
        Vector<String> vector = new Vector<String>();
        vector.add(song.getDirectory());
        vector.add(song.getFilename());
        if (bl) {
            this.rowData.add(0, vector);
        } else {
            this.rowData.add(vector);
        }
        TableModel tableModel = this.table.getModel();
        TableModelEvent tableModelEvent = new TableModelEvent(tableModel, this.rowData.size() - 1, this.rowData.size() - 1, -1, 1);
        this.table.tableChanged(tableModelEvent);
    }

    public Song getSong() {
        if (this.songs.size() > 0) {
            Song song = (Song)this.songs.get(0);
            this.songs.removeElementAt(0);
            this.rowData.removeElementAt(0);
            TableModel tableModel = this.table.getModel();
            TableModelEvent tableModelEvent = new TableModelEvent(tableModel, 0, 0, -1, -1);
            this.table.tableChanged(tableModelEvent);
            return song;
        }
        return null;
    }

    public int size() {
        return this.songs.size();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = this.table.getSelectedRow();
        if (string.equals("Up")) {
            if (n > 0) {
                Object e = this.rowData.get(n - 1);
                Object e2 = this.rowData.get(n);
                this.rowData.set(n - 1, e2);
                this.rowData.set(n, e);
                Object e3 = this.songs.get(n - 1);
                Object e4 = this.songs.get(n);
                this.songs.set(n - 1, e4);
                this.songs.set(n, e3);
                TableModel tableModel = this.table.getModel();
                TableModelEvent tableModelEvent = new TableModelEvent(tableModel, n - 1, n);
                this.table.tableChanged(tableModelEvent);
                this.table.setRowSelectionInterval(n - 1, n - 1);
            }
        } else if (string.equals("Down")) {
            if (n != -1 && n < this.rowData.size() - 1) {
                Object e = this.rowData.get(n);
                Object e5 = this.rowData.get(n + 1);
                this.rowData.set(n, e5);
                this.rowData.set(n + 1, e);
                Object e6 = this.songs.get(n);
                Object e7 = this.songs.get(n + 1);
                this.songs.set(n, e7);
                this.songs.set(n + 1, e6);
                TableModel tableModel = this.table.getModel();
                TableModelEvent tableModelEvent = new TableModelEvent(tableModel, n + 1, n);
                this.table.tableChanged(tableModelEvent);
                this.table.setRowSelectionInterval(n + 1, n + 1);
            }
        } else if (string.equals("Delete") && n != -1) {
            this.rowData.removeElementAt(n);
            this.songs.removeElementAt(n);
            TableModel tableModel = this.table.getModel();
            TableModelEvent tableModelEvent = new TableModelEvent(tableModel, n, n, -1, -1);
            this.table.tableChanged(tableModelEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.delete.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

