/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.MusicQueue;
import dk.borderworlds.SelectOnlyTableModel;
import dk.borderworlds.Song;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class MusicSearch
implements ActionListener,
MouseListener {
    private Vector songs;
    private Vector rowData;
    private Vector foundSongs;
    private JFrame searchFrame;
    private JButton enqueue;
    private JTextField searchField;
    private JTable table;
    private MusicQueue queue;

    public MusicSearch(Vector vector, MusicQueue musicQueue) {
        this.songs = vector;
        this.queue = musicQueue;
        this.searchFrame = new JFrame("Search");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.searchFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(" Search for:  "), "West");
        this.searchField = new JTextField(50);
        this.searchField.addActionListener(this);
        jPanel2.add((Component)this.searchField, "Center");
        jPanel.add((Component)jPanel2, "North");
        this.rowData = new Vector();
        this.foundSongs = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Directory");
        vector2.add("Filename");
        this.table = new JTable(new SelectOnlyTableModel(this.rowData, (Vector)vector2));
        this.table.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        this.enqueue = new JButton("Enqueue");
        this.enqueue.addActionListener(this);
        jPanel3.add(this.enqueue);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        this.searchFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MusicSearch.this.searchFrame.dispose();
            }
        });
        this.searchFrame.pack();
        this.searchFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            this.searchFrame.dispose();
        } else if (string.equals("Enqueue")) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                this.queue.addSong((Song)this.foundSongs.get(nArray[i]));
            }
        } else {
            this.doSearch(string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.enqueue.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void doSearch(String string) {
        Song song;
        int n;
        this.foundSongs.removeAllElements();
        for (n = 0; n < this.songs.size(); ++n) {
            song = (Song)this.songs.get(n);
            if (!song.matchesString(string)) continue;
            this.foundSongs.add(song);
        }
        this.rowData.removeAllElements();
        for (n = 0; n < this.foundSongs.size(); ++n) {
            song = (Song)this.foundSongs.get(n);
            Vector<String> vector = new Vector<String>();
            vector.add(song.getDirectory());
            vector.add(song.getFilename());
            this.rowData.add(vector);
        }
        TableModel tableModel = this.table.getModel();
        TableModelEvent tableModelEvent = new TableModelEvent(tableModel);
        this.table.tableChanged(tableModelEvent);
    }
}

