/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.MusicConfiguration;
import dk.borderworlds.MusicPipe;
import dk.borderworlds.MusicPlayer;
import dk.borderworlds.Song;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OggPlayer
extends MusicPlayer
implements Runnable {
    private Song song = null;
    private Process proc = null;
    private BufferedInputStream bis;
    String name;
    private Thread inputreader;
    private String status;
    private byte[] statusLine;
    private String title;
    private String filename;
    private int pausePosition;
    private MusicConfiguration configuration;
    private MusicPipe pipe;

    public OggPlayer(MusicConfiguration musicConfiguration) {
        this.configuration = musicConfiguration;
    }

    public void playSong(Song song) {
        this.song = song;
        this.playSong(0);
    }

    public void playSong(int n) {
        this.status = n == 0 ? "Starting" : "Resuming";
        this.title = this.song.getFilename();
        this.filename = this.song.getFilename();
        Runtime runtime = Runtime.getRuntime();
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.proc = null;
        }
        try {
            int n2;
            String string = this.configuration.getDevice();
            int n3 = n2 = this.pausePosition == 0 ? 5 : 7;
            if (string.equals("STDOUT")) {
                n2 += 2;
            }
            String[] stringArray = new String[n2];
            stringArray[0] = "ogg123";
            stringArray[1] = "-v";
            stringArray[2] = "-d";
            stringArray[3] = "oss";
            if (string.equals("STDOUT")) {
                stringArray[3] = "raw";
                stringArray[4] = "-f";
                stringArray[5] = "-";
            }
            if (this.pausePosition != 0) {
                stringArray[n2 - 3] = "-k";
                stringArray[n2 - 2] = "" + this.pausePosition;
            }
            stringArray[n2 - 1] = this.song.getDirectory() + File.separator + this.song.getFilename();
            this.proc = runtime.exec(stringArray);
            InputStream inputStream = this.proc.getErrorStream();
            this.pipe = new MusicPipe(this.proc.getInputStream());
            this.bis = new BufferedInputStream(inputStream);
            this.inputreader = new Thread(this);
            this.inputreader.start();
            this.status = "Playing";
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void pauseSong() {
        if (this.statusLine != null) {
            String string = new String(this.statusLine, 0, 2);
            String string2 = new String(this.statusLine, 3, 2);
            this.pausePosition = Integer.parseInt(string) * 60 + Integer.parseInt(string2);
        } else {
            this.pausePosition = 0;
        }
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            this.proc = null;
        }
    }

    public void resumeSong() {
        if (this.pausePosition != 0) {
            this.playSong(this.pausePosition);
            this.pausePosition = 0;
        }
    }

    public void stopSong() {
        if (this.proc != null) {
            this.proc.destroy();
            while (this.bis != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            this.proc = null;
            this.song = null;
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStatus() {
        if (this.status.equals("Retrying")) {
            this.playSong(0);
            return "Retrying";
        }
        if (this.status.equals("Playing") && this.bis == null) {
            if (this.pausePosition == 0) {
                this.status = "Stopped";
                this.song = null;
            } else {
                this.status = "Paused";
            }
        }
        return this.status;
    }

    public String getFilename() {
        if (this.song == null) {
            return "(none)";
        }
        return this.filename;
    }

    public String getTitle() {
        if (this.song == null) {
            return "(none)";
        }
        return this.title;
    }

    public String getPosition() {
        if (this.statusLine != null) {
            return new String(this.statusLine, 0, 5);
        }
        return "N/A";
    }

    public String getLength() {
        if (this.statusLine != null) {
            return new String(this.statusLine, 5, 5);
        }
        return "N/A";
    }

    public boolean acceptsType(String string) {
        return string.equals("ogg");
    }

    public Song getSong() {
        return this.song;
    }

    public void run() {
        int n;
        boolean bl = true;
        byte[] byArray = new byte[1024];
        this.statusLine = new byte[10];
        byte[] byArray2 = new byte[256];
        int n2 = 0;
        for (n = 0; n < 10; ++n) {
            this.statusLine[n] = 32;
        }
        Pattern pattern = Pattern.compile("^Time:\\s+(\\d{2}:\\d{2})\\.\\d{2}\\s+.*\\s+of\\s+(\\d{2}:\\d{2})\\.\\d{2}\\s+");
        Pattern pattern2 = Pattern.compile("^Title: (.*)$");
        Pattern pattern3 = Pattern.compile("^Error:");
        while (bl) {
            try {
                n = this.bis.read(byArray, 0, 1024);
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        if (byArray[i] == 10 || byArray[i] == 13) {
                            String string = new String(byArray2, 0, n2);
                            Matcher matcher = pattern.matcher(string);
                            if (matcher.find()) {
                                this.statusLine = (matcher.group(1) + matcher.group(2)).getBytes();
                            }
                            if ((matcher = pattern2.matcher(string)).matches()) {
                                this.title = matcher.group(1);
                            }
                            if ((matcher = pattern3.matcher(string)).find()) {
                                this.status = "Retrying";
                            }
                            n2 = 0;
                            continue;
                        }
                        byArray2[n2++] = byArray[i];
                    }
                    continue;
                }
                if (n != -1) continue;
                this.bis.close();
                this.bis = null;
                bl = false;
            }
            catch (Exception exception) {
                if (!exception.getClass().getName().equals("java.io.IOException")) continue;
                this.bis = null;
                bl = false;
            }
        }
    }
}

