/**********************************************************************
 *
 *    FILE:            FrontFace.cpp
 *
 *    DESCRIPTION:    Read/Write osg::FrontFace in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 21.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "FrontFace.h"
#include "Object.h"

using namespace ive;

void FrontFace::write(DataOutputStream* out){
    // Write FrontFace's identification.
    out->writeInt(IVEFRONTFACE);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        throw Exception("FrontFace::write(): Could not cast this osg::FrontFace to an osg::Object.");
    // Write FrontFace's properties.

    // Write mode
    out->writeInt(getMode());
}

void FrontFace::read(DataInputStream* in){
    // Peek on FrontFace's identification.
    int id = in->peekInt();
    if(id == IVEFRONTFACE){
        // Read FrontFace's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            throw Exception("FrontFace::read(): Could not cast this osg::FrontFace to an osg::Object.");
        // Read FrontFace's properties

        // Read mode
        setMode((osg::FrontFace::Mode)in->readInt());

    }
    else{
        throw Exception("FrontFace::read(): Expected FrontFace identification.");
    }
}

