/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathMapItem {
    private IPath local;
    private IPath remote;
    static final String DELIMITER_REGEX = "\\+\\*\\+";
    static final String DELIMITER = "+*+";

    private static String MakeStringData(IPath local, IPath remote) {
        if (local.getDevice() == "file://") {
            local = local.setDevice("");
        }
        String data = String.valueOf(local.toString()) + DELIMITER + remote.toString();
        return data;
    }

    public PathMapItem(String newLocal, String newRemote) {
        IPath localPath = this.sanitizePath(newLocal);
        IPath remotePath = this.sanitizePath(newRemote);
        this.local = localPath;
        this.remote = remotePath;
    }

    private IPath sanitizePath(String newPath) {
        Path computePath;
        Path sanitizePath = null;
        sanitizePath = computePath = new Path(newPath);
        return sanitizePath;
    }

    public PathMapItem(String data) {
        String[] strData = data.split(DELIMITER_REGEX);
        IPath localPath = this.sanitizePath(strData[0]);
        IPath remotePath = this.sanitizePath(strData[1]);
        this.local = localPath;
        this.remote = remotePath;
    }

    public String getStringData() {
        return PathMapItem.MakeStringData(this.local, this.remote);
    }

    public IPath getLocalPath() {
        return new Path(this.local.toString());
    }

    public IPath getRemotePath() {
        return new Path(this.remote.toString());
    }

    public void setLocalPath(String path) {
        this.local = this.sanitizePath(path);
    }

    public void setLocalPath(IPath path) {
        this.local = path;
    }

    public void setRemotePath(IPath path) {
        this.remote = path;
    }

    public void setRemotePath(String path) {
        this.remote = this.sanitizePath(path);
    }

    public String toString() {
        return String.valueOf(this.local.toString()) + "->" + this.remote.toString();
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof PathMapItem) {
            PathMapItem var = (PathMapItem)obj;
            equal = var.getLocalPath().equals((Object)this.local);
        }
        return equal;
    }
}

