/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import net.sourceforge.phpeclipse.xdebug.php.model.XDebugAbstractValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugStackFrame;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.w3c.dom.Node;

public class XDebugBooleanValue
extends XDebugAbstractValue {
    public XDebugBooleanValue(XDebugStackFrame variable, Node value) throws DebugException {
        super(variable, value);
        this.renderValueString(this.rowValue);
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean setValue(String expression) throws DebugException {
        if (this.isValid(expression)) {
            this.renderValueString(expression);
            this.fireEvent(new DebugEvent((Object)this, 16, 512));
            return true;
        }
        return false;
    }

    private void renderValueString(String data) {
        if (data.equals("0") || data.toLowerCase().equals("false")) {
            this.setValueString("false");
        } else if (data.equals("1") || data.toLowerCase().equals("true")) {
            this.setValueString("true");
        }
    }

    private boolean isValid(String expression) {
        int value = -1;
        try {
            value = Integer.parseInt(expression);
        }
        catch (NumberFormatException numberFormatException) {
            expression = expression.toLowerCase();
            return expression.equals("true") || expression.equals("false");
        }
        return value >= 0 && value <= 1;
    }

    public boolean verifyValue(String expression) {
        return this.isValid(expression);
    }
}

