/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugElement;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugThread;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugVariable;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDebugStackFrame
extends XDebugElement
implements IStackFrame {
    private XDebugThread fThread;
    private URL fName;
    private int fLineNumber;
    private int fLevel;
    private String fType;
    private String fWhere;
    private IVariable[] fVariables;
    private int fStepCount = 0;

    public XDebugStackFrame(XDebugThread thread, int id, String type, int lineNumber, String where, String filename) {
        super((XDebugTarget)thread.getDebugTarget());
        this.fLevel = id;
        this.fThread = thread;
        this.fType = type;
        this.fLineNumber = lineNumber;
        this.fWhere = where;
        try {
            this.fName = new URL(filename);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void incrementStepCounter() {
        ++this.fStepCount;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        Node dfl = ((XDebugTarget)this.getDebugTarget()).getLocalVariables(this.fLevel);
        Node dfg = ((XDebugTarget)this.getDebugTarget()).getGlobalVariables(this.fLevel);
        this.parseVariable(dfl, dfg);
        return this.fVariables;
    }

    private void parseVariable(Node localVariables, Node globalVariables) throws DebugException {
        NodeList property = localVariables.getChildNodes();
        NodeList propertyGlobal = globalVariables.getChildNodes();
        this.fVariables = new IVariable[property.getLength() + propertyGlobal.getLength()];
        int length = property.getLength();
        int i = 0;
        while (i < length) {
            XDebugVariable var = new XDebugVariable(this, property.item(i));
            this.fVariables[i] = var;
            ++i;
        }
        int globalLength = propertyGlobal.getLength();
        int k = 0;
        while (k < globalLength) {
            XDebugVariable var = new XDebugVariable(this, propertyGlobal.item(k));
            this.fVariables[k + length] = var;
            ++k;
        }
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public int getLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return String.valueOf(this.fName.toString()) + "::" + this.fWhere + " line: " + this.fLineNumber;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.fThread.canStepInto();
    }

    public boolean canStepOver() {
        return this.fThread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.fThread.canStepReturn();
    }

    public boolean isStepping() {
        return this.fThread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.fThread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.fThread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.fThread.stepReturn();
    }

    public boolean canResume() {
        return this.fThread.canResume();
    }

    public boolean canSuspend() {
        return this.fThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.fThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.fThread.resume();
    }

    public void suspend() throws DebugException {
        this.fThread.suspend();
    }

    public boolean canTerminate() {
        return this.fThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.fThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.fThread.terminate();
    }

    public String getSourceName() {
        if (this.fName == null) {
            return null;
        }
        Path a = new Path(this.fName.getFile());
        return a.lastSegment();
    }

    public boolean isSameStackFrame(Object obj) {
        boolean isSameStackFrame = false;
        if (obj instanceof XDebugStackFrame) {
            XDebugStackFrame sf = (XDebugStackFrame)((Object)obj);
            isSameStackFrame = sf.getSourceName().equals(this.getSourceName()) && sf.getType().equals(this.getType()) && sf.getWhere().equals(this.getWhere());
        }
        return isSameStackFrame;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XDebugStackFrame) {
            XDebugStackFrame sf = (XDebugStackFrame)((Object)obj);
            try {
                return sf.getSourceName().equals(new Path(this.fName.getFile()).lastSegment()) && sf.getLineNumber() == this.fLineNumber && sf.getLevel() == this.fLevel && sf.getType().equals(this.fType) && sf.getWhere().equals(this.fWhere);
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + this.fLevel;
    }

    public URL getFullName() {
        return this.fName;
    }

    public int getLevel() {
        return this.fLevel;
    }

    public String getType() {
        return this.fType;
    }

    public String getWhere() {
        return this.fWhere;
    }

    public boolean setVariableValue(XDebugVariable variable, String expression) throws DebugException {
        return ((XDebugTarget)this.getDebugTarget()).setVarValue("$" + variable.getName(), expression);
    }

    public Node eval(String expression) throws DebugException {
        return ((XDebugTarget)this.getDebugTarget()).eval(expression);
    }
}

