/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.httpquery;

import net.sourceforge.phpdt.httpquery.config.Configuration;
import net.sourceforge.phpeclipse.webbrowser.views.BrowserView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public abstract class AbstractHTTPQueryAction
implements IEditorActionDelegate {
    private AbstractTextEditor editor;

    protected abstract Configuration getConfiguration(String var1);

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null && targetEditor instanceof AbstractTextEditor) {
            this.editor = (AbstractTextEditor)targetEditor;
        }
    }

    public void run(IAction action) {
        IEditorPart targetEditor;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.editor == null && (targetEditor = window.getActivePage().getActiveEditor()) != null && targetEditor instanceof AbstractTextEditor) {
            this.editor = (AbstractTextEditor)targetEditor;
        }
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            try {
                IViewPart part = page.findView("net.sourceforge.phpeclipse.webbrowser.views");
                if (part == null) {
                    part = page.showView("net.sourceforge.phpeclipse.webbrowser.views");
                } else {
                    page.bringToTop((IWorkbenchPart)part);
                }
                Configuration config = this.getConfiguration(null);
                String templateString = this.generateUrl(config, config.getURL());
                if (templateString != null && !templateString.equals("")) {
                    ((BrowserView)part).setUrl(templateString);
                } else {
                    ((BrowserView)part).setUrl(config.getURL());
                }
            }
            catch (Exception exception) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public IDocument getDocument() {
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        return doc;
    }

    public static String getSelectedText(AbstractTextEditor editor, IDocument document, int initialPos) {
        try {
            int pos = initialPos;
            int line = document.getLineOfOffset(pos);
            int start = document.getLineOffset(line);
            int end = start + document.getLineInformation(line).getLength();
            if (pos > end) {
                pos = end;
            }
            int offsetInLine = pos - start;
            String word = document.get(start, end - start);
            int wordlen = word.length();
            int textStart = -1;
            int textEnd = -1;
            int i = offsetInLine;
            while (i < wordlen) {
                if (!Character.isJavaIdentifierPart(word.charAt(i))) {
                    textEnd = i;
                    break;
                }
                ++i;
            }
            i = offsetInLine;
            while (i >= 0) {
                if (!Character.isJavaIdentifierPart(word.charAt(i))) {
                    textStart = i + 1;
                    break;
                }
                --i;
            }
            if (textStart != -1 && textEnd != -1 && textStart < textEnd) {
                return new String(word.toCharArray(), textStart, textEnd - textStart);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public String generateUrl(Configuration config, String template) {
        String wikiTitle;
        IDocument doc = this.getDocument();
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        int pos = selection.getOffset();
        int len = selection.getLength();
        if (len > 0) {
            try {
                wikiTitle = doc.get(pos, len);
            }
            catch (BadLocationException badLocationException) {
                wikiTitle = null;
            }
        } else {
            wikiTitle = AbstractHTTPQueryAction.getSelectedText(this.editor, doc, pos);
        }
        if (wikiTitle != null && !wikiTitle.equals("")) {
            template = template.replaceAll("\\$text.selection", wikiTitle);
            wikiTitle = wikiTitle.replaceAll("_", "-");
            template = template.replaceAll("\\$php.selection", wikiTitle);
            return template;
        }
        return null;
    }
}

