/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.ExternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.ExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.IWebBrowserListener;
import net.sourceforge.phpeclipse.webbrowser.internal.InternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserPreference;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class BrowserManager {
    private static final int ADD = 0;
    private static final int CHANGE = 1;
    private static final int REMOVE = 2;
    protected List browsers;
    protected IWebBrowser currentBrowser;
    protected List browserListeners = new ArrayList();
    private Preferences.IPropertyChangeListener pcl = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (BrowserManager.this.ignorePreferenceChanges) {
                return;
            }
            String property = event.getProperty();
            if (property.equals("browsers")) {
                BrowserManager.this.loadBrowsers();
            }
        }
    };
    protected boolean ignorePreferenceChanges = false;
    protected static BrowserManager instance;

    public static BrowserManager getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
        }
        return instance;
    }

    private BrowserManager() {
        WebBrowserUIPlugin.getInstance().getPluginPreferences().addPropertyChangeListener(this.pcl);
    }

    protected void dispose() {
        WebBrowserUIPlugin.getInstance().getPluginPreferences().removePropertyChangeListener(this.pcl);
        if (this.browsers != null) {
            Iterator iterator = this.browsers.iterator();
            while (iterator.hasNext()) {
                IInternalWebBrowser wb;
                Object obj = iterator.next();
                if (!(obj instanceof IInternalWebBrowser) || !(wb = (IInternalWebBrowser)obj).getClearHistoryOnExit()) continue;
                WebBrowserPreference.setInternalWebBrowserHistory(null);
            }
        }
    }

    public IExternalWebBrowserWorkingCopy createExternalWebBrowser() {
        return new ExternalWebBrowserWorkingCopy();
    }

    public List getWebBrowsers() {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        return new ArrayList(this.browsers);
    }

    protected void loadBrowsers() {
        Trace.trace(Trace.FINEST, "Loading web browsers");
        Preferences prefs = WebBrowserUIPlugin.getInstance().getPluginPreferences();
        String xmlString = prefs.getString("browsers");
        if (xmlString != null && xmlString.length() > 0) {
            this.browsers = new ArrayList();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
                InputStreamReader reader = new InputStreamReader(in);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento child = memento.getChild("internal");
                if (child != null) {
                    InternalWebBrowser browser = new InternalWebBrowser();
                    browser.load(child);
                    this.browsers.add(browser);
                }
                IMemento[] children = memento.getChildren("external");
                int size = children.length;
                int i = 0;
                while (i < size) {
                    ExternalWebBrowser browser = new ExternalWebBrowser();
                    browser.load(children[i]);
                    this.browsers.add(browser);
                    ++i;
                }
                Integer current = memento.getInteger("current");
                if (current != null) {
                    this.currentBrowser = (IWebBrowser)this.browsers.get(current);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Could not load browsers: " + e.getMessage());
            }
            this.addInternalBrowser(this.browsers);
            if (this.currentBrowser == null && this.browsers.size() > 0) {
                this.currentBrowser = (IWebBrowser)this.browsers.get(0);
            }
        } else {
            this.setupDefaultBrowsers();
            this.saveBrowsers();
            return;
        }
    }

    protected void saveBrowsers() {
        try {
            this.ignorePreferenceChanges = true;
            XMLMemento memento = XMLMemento.createWriteRoot((String)"web-browsers");
            Iterator iterator = this.browsers.iterator();
            while (iterator.hasNext()) {
                IMemento child;
                IWebBrowser browser;
                Object obj = iterator.next();
                if (obj instanceof InternalWebBrowser) {
                    browser = (InternalWebBrowser)obj;
                    child = memento.createChild("internal");
                    ((InternalWebBrowser)browser).save(child);
                    continue;
                }
                if (!(obj instanceof ExternalWebBrowser)) continue;
                browser = (ExternalWebBrowser)obj;
                child = memento.createChild("external");
                ((ExternalWebBrowser)browser).save(child);
            }
            memento.putInteger("current", this.browsers.indexOf(this.currentBrowser));
            StringWriter writer = new StringWriter();
            memento.save((Writer)writer);
            String xmlString = writer.getBuffer().toString();
            Preferences prefs = WebBrowserUIPlugin.getInstance().getPluginPreferences();
            prefs.setValue("browsers", xmlString);
            WebBrowserUIPlugin.getInstance().savePluginPreferences();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save browsers", e);
        }
        this.ignorePreferenceChanges = false;
    }

    protected void addInternalBrowser(List browserList) {
        if (browserList == null) {
            return;
        }
        Iterator iterator = browserList.iterator();
        while (iterator.hasNext()) {
            IWebBrowser browser = (IWebBrowser)iterator.next();
            if (!(browser instanceof IInternalWebBrowser)) continue;
            return;
        }
        WebBrowserUIPlugin.getInstance().getLog().log((IStatus)new Status(1, "net.sourceforge.phpeclipse.webbrowser", 0, "-" + WebBrowserUtil.isInternalBrowserOperational(), null));
        if (!WebBrowserUtil.isInternalBrowserOperational()) {
            return;
        }
        browserList.add(0, new InternalWebBrowser());
    }

    private void setupDefaultBrowsers() {
        this.browsers = new ArrayList();
        this.addInternalBrowser(this.browsers);
        WebBrowserUtil.addFoundBrowsers(this.browsers);
        if (!this.browsers.isEmpty()) {
            this.currentBrowser = (IWebBrowser)this.browsers.get(0);
        }
    }

    protected void addBrowser(IExternalWebBrowser browser) {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        if (!this.browsers.contains(browser)) {
            this.browsers.add(browser);
        }
        this.fireWebBrowserEvent(browser, 0);
        this.saveBrowsers();
    }

    protected void removeWebBrowser(IExternalWebBrowser browser) {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        this.browsers.remove(browser);
        this.fireWebBrowserEvent(browser, 2);
    }

    protected void browserChanged(IWebBrowser browser) {
        this.fireWebBrowserEvent(browser, 1);
        this.saveBrowsers();
    }

    public void addWebBrowserListener(IWebBrowserListener listener) {
        this.browserListeners.add(listener);
    }

    public void removeWebBrowserListener(IWebBrowserListener listener) {
        this.browserListeners.remove(listener);
    }

    protected void fireWebBrowserEvent(IWebBrowser browser, int type) {
        Object[] obj = this.browserListeners.toArray();
        int size = obj.length;
        int i = 0;
        while (i < size) {
            IWebBrowserListener listener = (IWebBrowserListener)obj[i];
            if (type == 0) {
                listener.browserAdded(browser);
            } else if (type == 1) {
                listener.browserChanged(browser);
            } else if (type == 2) {
                listener.browserRemoved(browser);
            }
            ++i;
        }
    }

    public IWebBrowser getCurrentWebBrowser() {
        if (this.browsers == null) {
            this.loadBrowsers();
        }
        return this.currentBrowser;
    }

    public void setCurrentWebBrowser(IWebBrowser wb) {
        if (this.browsers.contains(wb)) {
            this.currentBrowser = wb;
        }
        this.saveBrowsers();
    }
}

