/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class BrowserSearcher {
    private static boolean cancelled;

    private BrowserSearcher() {
    }

    protected static List search(Shell shell) {
        final ArrayList foundBrowsers = new ArrayList();
        final List existingPaths = WebBrowserUtil.getExternalBrowserPaths();
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setMessage(WebBrowserUIPlugin.getResource("%selectDirectory"));
        dialog.setText(WebBrowserUIPlugin.getResource("%directoryDialogTitle"));
        String path = dialog.open();
        if (path == null) {
            return null;
        }
        cancelled = false;
        final File rootDir = new File(path);
        ProgressMonitorDialog pm = new ProgressMonitorDialog(shell);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(WebBrowserUIPlugin.getResource("%searchingTaskName"), -1);
                BrowserSearcher.search(rootDir, existingPaths, foundBrowsers, monitor);
                monitor.done();
                if (monitor.isCanceled()) {
                    BrowserSearcher.setCancelled(true);
                }
            }
        };
        try {
            pm.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            Trace.trace(Trace.SEVERE, "Invocation Exception occured running monitor: " + e);
        }
        catch (InterruptedException e) {
            Trace.trace(Trace.SEVERE, "Interrupted exception occured running monitor: " + e);
            return null;
        }
        if (cancelled) {
            return null;
        }
        return foundBrowsers;
    }

    protected static void setCancelled(boolean b) {
        cancelled = b;
    }

    protected static void search(File directory, List existingPaths, List foundBrowsers, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String[] names = directory.list();
        ArrayList<File> subDirs = new ArrayList<File>();
        int i = 0;
        while (i < names.length) {
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, names[i]);
            if (!existingPaths.contains(file.getAbsolutePath().toLowerCase())) {
                IExternalWebBrowserWorkingCopy wc = WebBrowserUtil.createExternalBrowser(file);
                if (wc != null) {
                    foundBrowsers.add(wc);
                }
                try {
                    monitor.subTask(MessageFormat.format(WebBrowserUIPlugin.getResource("%searching"), Integer.toString(foundBrowsers.size()), file.getCanonicalPath()));
                }
                catch (IOException iOException) {}
                if (file.isDirectory()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    subDirs.add(file);
                }
            }
            ++i;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            BrowserSearcher.search(subDir, existingPaths, foundBrowsers, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }
}

