/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.io.File;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserManager;
import net.sourceforge.phpeclipse.webbrowser.internal.SWTUtil;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExternalBrowserDialog
extends Dialog {
    protected IExternalWebBrowserWorkingCopy browser;
    protected boolean isEdit;
    protected Button newPageCheckbox;
    protected Button clearHistoryCheckbox;
    protected Button browseButton;
    protected Text browserNameTextfield;
    protected Text browserLocationTextfield;
    protected Text browserParametersTextfield;
    private Button okButton;

    public ExternalBrowserDialog(Shell parentShell, IExternalWebBrowserWorkingCopy browser) {
        super(parentShell);
        this.browser = browser;
        this.isEdit = true;
    }

    public ExternalBrowserDialog(Shell parentShell) {
        super(parentShell);
        this.browser = BrowserManager.getInstance().createExternalWebBrowser();
        this.isEdit = false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isEdit) {
            shell.setText(WebBrowserUIPlugin.getResource("%editExternalBrowser"));
        } else {
            shell.setText(WebBrowserUIPlugin.getResource("%createBrowser"));
        }
    }

    protected Text createText(Composite comp, String txt, final StringModifyListener listener) {
        final Text text = new Text(comp, 2048);
        if (txt != null) {
            text.setText(txt);
        }
        GridData data = new GridData(258);
        data.widthHint = 250;
        text.setLayoutData((Object)data);
        if (listener != null) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    listener.valueChanged(text.getText());
                }
            });
        }
        return text;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        if (this.isEdit) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "net.sourceforge.phpeclipse.webbrowser.wbpr0005");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "net.sourceforge.phpeclipse.webbrowser.wbpr0004");
        }
        SWTUtil.createLabel(composite, WebBrowserUIPlugin.getResource("%name"));
        this.browserNameTextfield = this.createText(composite, this.browser.getName(), new StringModifyListener(){

            public void valueChanged(String s) {
                ExternalBrowserDialog.this.browser.setName(s);
                ExternalBrowserDialog.this.validateFields();
            }
        });
        new Label(composite, 0);
        SWTUtil.createLabel(composite, WebBrowserUIPlugin.getResource("%location"));
        this.browserLocationTextfield = this.createText(composite, this.browser.getLocation(), new StringModifyListener(){

            public void valueChanged(String s) {
                ExternalBrowserDialog.this.browser.setLocation(s);
                ExternalBrowserDialog.this.validateFields();
            }
        });
        this.browseButton = SWTUtil.createButton(composite, WebBrowserUIPlugin.getResource("%browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExternalBrowserDialog.this.getShell(), 4096);
                dialog.setText(WebBrowserUIPlugin.getResource("%browseMessage"));
                String fname = ExternalBrowserDialog.this.browserLocationTextfield.getText();
                dialog.setFileName(fname);
                fname = dialog.open();
                if (fname != null) {
                    ExternalBrowserDialog.this.browserLocationTextfield.setText(fname);
                }
            }
        });
        SWTUtil.createLabel(composite, WebBrowserUIPlugin.getResource("%parameters"));
        this.browserParametersTextfield = this.createText(composite, this.browser.getParameters(), new StringModifyListener(){

            public void valueChanged(String s) {
                ExternalBrowserDialog.this.browser.setParameters(s);
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(WebBrowserUIPlugin.getResource("%parametersMessage", "%URL%"));
        return composite;
    }

    protected void okPressed() {
        try {
            File file = new File(this.browser.getLocation());
            if (!file.isFile()) {
                WebBrowserUtil.openError(WebBrowserUIPlugin.getResource("%locationInvalid"));
                return;
            }
        }
        catch (Exception exception) {
            WebBrowserUtil.openError(WebBrowserUIPlugin.getResource("%locationInvalid"));
            return;
        }
        this.browser.save();
        super.okPressed();
    }

    private void setOKButtonEnabled(boolean curIsEnabled) {
        if (this.okButton == null) {
            this.okButton = this.getButton(0);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(curIsEnabled);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonControl = super.createButtonBar(parent);
        this.validateFields();
        return buttonControl;
    }

    protected void validateFields() {
        String location;
        boolean valid = true;
        String name = this.browserNameTextfield.getText();
        if (name == null || name.trim().length() < 1) {
            valid = false;
        }
        if ((location = this.browserLocationTextfield.getText()) == null || location.trim().length() < 1) {
            valid = false;
        }
        this.setOKButtonEnabled(valid);
    }

    static interface StringModifyListener {
        public void valueChanged(String var1);
    }
}

