/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.net.URL;
import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.WebBrowserEditorInput;
import net.sourceforge.phpeclipse.webbrowser.internal.InternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserEditor;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import org.eclipse.ui.IMemento;

public class InternalWebBrowser
implements IInternalWebBrowser {
    private static final String MEMENTO_NEW_PAGE = "new_page";
    private static final String MEMENTO_CLEAR_HISTORY_ON_EXIT = "clear_history";
    protected boolean useNewPage;
    protected boolean clearHistory;

    public String getName() {
        return WebBrowserUIPlugin.getResource("%internalWebBrowserName");
    }

    public boolean getUseNewPage() {
        return this.useNewPage;
    }

    public boolean getClearHistoryOnExit() {
        return this.clearHistory;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public IInternalWebBrowserWorkingCopy getWorkingCopy() {
        return new InternalWebBrowserWorkingCopy(this);
    }

    protected void setInternal(IInternalWebBrowser browser) {
        this.useNewPage = browser.getUseNewPage();
        this.clearHistory = browser.getClearHistoryOnExit();
    }

    public void openURL(URL url) {
        WebBrowserEditor.open(new WebBrowserEditorInput(url));
    }

    protected void save(IMemento memento) {
        memento.putString(MEMENTO_NEW_PAGE, this.useNewPage ? "true" : "false");
        memento.putString(MEMENTO_CLEAR_HISTORY_ON_EXIT, this.clearHistory ? "true" : "false");
    }

    protected void load(IMemento memento) {
        String s = memento.getString(MEMENTO_NEW_PAGE);
        this.useNewPage = "true".equals(s);
        s = memento.getString(MEMENTO_CLEAR_HISTORY_ON_EXIT);
        this.clearHistory = "true".equals(s);
    }

    public String toString() {
        return "Internal Web browser";
    }
}

