/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.breakpoints;

import net.sourceforge.phpdt.internal.debug.core.PHPDebugCorePlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class PHPBreakpoint
extends Breakpoint
implements IBreakpoint {
    protected static final String HIT_COUNT = "net.sourceforge.phpeclipse.debug.hitCount";
    protected static final String CHANGE_ID = "net.sourceforge.phpeclipse.debug.changeID";
    protected static final String CONDITION = "net.sourceforge.phpeclipse.debug.condition";
    protected static final String CONDITION_ENABLED = "net.sourceforge.phpeclipse.debug.conditionEnabled";
    protected static final String TYPE_NAME = "net.sourceforge.phpeclipse.debug.typeName";
    public static final String BREAKPOINT_MARKER = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".breakpointMarker";
    public static final String LINE_BREAKPOINT_MARKER = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".lineBreakpointMarker";
    public static final String ENABLED = "org.eclipse.debug.core.enabled";
    public static final String ID = "org.eclipse.debug.core.id";
    public static final String REGISTERED = "org.eclipse.debug.core.registered";
    public static final String PERSISTED = "org.eclipse.debug.core.persisted";
    private int DBGBpNo = 0;

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
    }

    protected void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected void run(IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public String getModelIdentifier() {
        return PHPDebugCorePlugin.getUniqueIdentifier();
    }

    public void setDBGBpNo(int bpNo) {
        this.DBGBpNo = bpNo;
    }

    public int getDBGBpNo() {
        return this.DBGBpNo;
    }

    public int getHitCount() throws CoreException {
        return this.getMarker().getAttribute(HIT_COUNT, -1);
    }

    public void setHitCount(int hitCount) throws CoreException {
        if (hitCount > 0 && !this.isEnabled()) {
            this.getMarker().setAttribute(ENABLED, true);
        }
        this.getMarker().setAttribute(HIT_COUNT, hitCount);
    }
}

