/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.model;

import java.util.Collections;
import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGProxy;
import net.sourceforge.phpdt.internal.debug.core.PHPDebugCorePlugin;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugElement;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugTarget;
import net.sourceforge.phpdt.internal.debug.core.model.PHPThread;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariable;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariableComparator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class PHPStackFrame
extends PHPDebugElement
implements IStackFrame,
Comparable {
    private PHPThread thread;
    private String file;
    private int lineNumber;
    private int index;
    private int modno;
    private int scope_id;
    private Vector varList;
    private String description;
    private boolean fUpToDate;
    private boolean fAvailable;
    static /* synthetic */ Class class$0;

    public PHPStackFrame(PHPThread thread, String file, int line, int index, String desc, int modno, int scope_id) {
        super(null);
        this.lineNumber = line;
        this.index = index;
        this.file = file;
        this.thread = thread;
        this.description = desc;
        this.modno = modno;
        this.scope_id = scope_id;
        this.varList = new Vector();
        this.fUpToDate = false;
    }

    public int getScopeID() {
        return this.scope_id;
    }

    public void setScopeID(int scope_id) {
        this.scope_id = scope_id;
        this.fUpToDate = false;
    }

    public IThread getThread() {
        return this.thread;
    }

    public void setThread(PHPThread thread) {
        this.thread = thread;
    }

    public void setAvailable(boolean available) {
        this.fAvailable = available;
    }

    public boolean isAvailable() {
        return this.fAvailable;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private void resetHasChangedInfo(Vector varList) {
        int n = 0;
        while (n < varList.size()) {
            PHPVariable var = (PHPVariable)varList.get(n);
            PHPValue val = (PHPValue)var.getValue();
            try {
                if (val.hasVariables() && !this.hasRecursion(var)) {
                    this.resetHasChangedInfo(val.getChildVariables());
                }
            }
            catch (DebugException debugException) {}
            var.setValueChanged(false);
            ++n;
        }
    }

    private boolean hasRecursion(PHPVariable var) {
        PHPValue val = (PHPValue)var.getValue();
        while (var != null) {
            PHPVariable parentVar = var.getParent();
            if (parentVar != null && parentVar.getValue().equals(val)) {
                return true;
            }
            var = parentVar;
        }
        return false;
    }

    private void updateVariableList(Vector varListOld, Vector varListNew) {
        PHPVariable varOld;
        int o;
        PHPVariable varNew;
        int n = 0;
        while (n < varListNew.size()) {
            varNew = (PHPVariable)varListNew.get(n);
            o = 0;
            while (o < varListOld.size()) {
                varOld = (PHPVariable)varListOld.get(o);
                if (varNew.getName().equals(varOld.getName())) {
                    PHPValue valOld = (PHPValue)varOld.getValue();
                    PHPValue valNew = (PHPValue)varNew.getValue();
                    try {
                        if ((valOld.hasVariables() || valNew.hasVariables()) && !this.hasRecursion(varOld) && !this.hasRecursion(varNew)) {
                            this.updateVariableList(valOld.getChildVariables(), valNew.getChildVariables());
                        }
                        if (valOld.getValueString().equals(valNew.getValueString())) break;
                        valOld.setValueString(valNew.getValueString());
                        varOld.setValueChanged(true);
                    }
                    catch (DebugException debugException) {}
                    break;
                }
                ++o;
            }
            if (o == varListOld.size()) {
                varListOld.add(varNew);
            }
            ++n;
        }
        o = 0;
        while (o < varListOld.size()) {
            varOld = (PHPVariable)varListOld.get(o);
            n = 0;
            while (n < varListNew.size()) {
                varNew = (PHPVariable)varListNew.get(n);
                if (varNew.getName().equals(varOld.getName())) break;
                ++n;
            }
            if (n == varListNew.size()) {
                varListOld.remove(o--);
            }
            ++o;
        }
    }

    public IVariable[] getVariables() throws DebugException {
        if (!this.fUpToDate) {
            this.resetHasChangedInfo(this.varList);
            this.updateVariableList(this.varList, this.getPHPDBGProxy().readVariables(this));
            this.fUpToDate = true;
            Collections.sort(this.varList, new PHPVariableComparator());
        }
        return this.varList.toArray(new PHPVariable[this.varList.size()]);
    }

    private PHPVariable findVariable(Vector varList, String varname) {
        int i = 0;
        while (i < varList.size()) {
            PHPVariable variable = (PHPVariable)varList.get(i);
            PHPValue value = (PHPValue)variable.getValue();
            try {
                PHPVariable var;
                if (value.hasVariables() && !this.hasRecursion(variable) && (var = this.findVariable(value.getChildVariables(), varname)) != null) {
                    return var;
                }
                if (variable.getName().equals(varname)) {
                    return variable;
                }
            }
            catch (DebugException debugException) {}
            ++i;
        }
        return null;
    }

    public IVariable findVariable(String s) throws DebugException {
        if (!this.fUpToDate) {
            this.getVariables();
        }
        return this.findVariable(this.varList, s);
    }

    public boolean hasVariables() throws DebugException {
        if (!this.fUpToDate) {
            this.getVariables();
        }
        return this.varList.size() > 0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() {
        StringBuffer name = new StringBuffer();
        if (!this.getDescription().equals("")) {
            name.append(this.getDescription());
        } else {
            name.append(this.getFileName());
        }
        name.append(" [line ");
        name.append(this.getLineNumber());
        name.append("]");
        return name.toString();
    }

    public String getFileName() {
        return this.file;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public String getModelIdentifier() {
        return this.getThread().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.getThread().getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public boolean canStepInto() {
        return this.canResume();
    }

    public boolean canStepOver() {
        return this.canResume();
    }

    public boolean canStepReturn() {
        return this.canResume();
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        this.fUpToDate = false;
        this.thread.prepareForResume(1);
        this.getPHPDBGProxy().readStepIntoEnd(this);
    }

    public void stepOver() throws DebugException {
        this.fUpToDate = false;
        this.thread.prepareForResume(2);
        this.getPHPDBGProxy().readStepOverEnd(this);
    }

    public void stepReturn() throws DebugException {
        this.fUpToDate = false;
        this.thread.prepareForResume(4);
        this.getPHPDBGProxy().readStepReturnEnd(this);
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.fUpToDate = false;
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getPHPDBGProxy().stop();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public PHPDBGProxy getPHPDBGProxy() {
        PHPDebugTarget DebugTarget = (PHPDebugTarget)this.thread.getDebugTarget();
        return DebugTarget.getPHPDBGProxy();
    }

    public void setFile(String file) {
        this.file = file;
        int i = 0;
        if (file.endsWith("eval()'d code")) {
            i = file.length() - "eval()'d code".length();
        } else if (file.endsWith("runtime-created function")) {
            i = file.length() - "runtime-created function".length();
        }
        if (i > 0) {
            int j = i;
            while (--i > 0) {
                switch (file.charAt(i)) {
                    case ')': {
                        j = i;
                        break;
                    }
                    case '(': {
                        this.file = file.substring(0, i);
                        try {
                            this.lineNumber = Integer.parseInt(file.substring(i + 1, j));
                        }
                        catch (NumberFormatException e) {
                            PHPDebugCorePlugin.log(e);
                        }
                        return;
                    }
                }
            }
        }
    }

    public int getModNo() {
        return this.modno;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof PHPStackFrame)) {
            throw new IllegalArgumentException("A PHPStackFrame can only be compared with another PHPStackFrame");
        }
        int frameIndex = ((PHPStackFrame)obj).getIndex();
        if (this.index < frameIndex) {
            return -1;
        }
        if (this.index > frameIndex) {
            return 1;
        }
        return 0;
    }
}

