/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariable;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariableComparator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class PHPValue
implements IValue {
    static final String[] PEV_NAMES = new String[]{"undefined", "long", "double", "string", "array", "object", "boolean", "resource", "reference", "soft reference"};
    public static final int PEVT_UNKNOWN = 0;
    public static final int PEVT_LONG = 1;
    public static final int PEVT_DOUBLE = 2;
    public static final int PEVT_STRING = 3;
    public static final int PEVT_ARRAY = 4;
    public static final int PEVT_OBJECT = 5;
    public static final int PEVT_BOOLEAN = 6;
    public static final int PEVT_RESOURCE = 7;
    public static final int PEVT_REF = 8;
    public static final int PEVT_SOFTREF = 9;
    private int fValueType;
    private String fValueString;
    private Vector fVariables;
    private PHPStackFrame fStackFrame;
    private boolean fHasChanged;
    private boolean fSorted;

    PHPValue() {
        this(null, "", 0, null);
    }

    public PHPValue(PHPStackFrame frame, String value, int fValueType, Vector subitems) {
        this.fValueType = fValueType;
        this.fValueString = value;
        this.fStackFrame = frame;
        this.fHasChanged = false;
        this.fSorted = false;
        this.fVariables = subitems != null ? new Vector(subitems) : new Vector();
    }

    public Vector addVariable(Vector item) {
        if (item != null) {
            this.fVariables.addAll(item);
            this.fSorted = false;
        }
        return this.fVariables;
    }

    public void setParent(PHPVariable parent) {
        if (!this.fVariables.isEmpty()) {
            Iterator iter = this.fVariables.iterator();
            while (iter.hasNext()) {
                ((PHPVariable)iter.next()).setParent(parent);
            }
        }
    }

    public String getReferenceTypeName() {
        return PEV_NAMES[this.fValueType];
    }

    public int getReferenceType() {
        return this.fValueType;
    }

    public int setReferenceType(int type) {
        this.fValueType = type;
        return this.fValueType;
    }

    public void setValueString(String value) {
        this.fValueString = value;
    }

    public String getValueString() {
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() {
        return this.getChildVariables().toArray(new PHPVariable[this.fVariables.size()]);
    }

    public Vector getChildVariables() {
        if (!this.fSorted) {
            Collections.sort(this.fVariables, new PHPVariableComparator());
            this.fSorted = true;
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        return this.fVariables.size() != 0;
    }

    public String getModelIdentifier() {
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return this.fStackFrame.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fHasChanged;
    }

    public void setValueChanged(boolean changed) {
        this.fHasChanged = changed;
    }

    protected void setVariables(Vector variables) {
        this.fVariables = variables;
    }

    protected Object clone() throws CloneNotSupportedException {
        PHPValue val = new PHPValue();
        val.fValueType = this.fValueType;
        val.fValueString = this.fValueString;
        val.fVariables = this.fVariables;
        val.fStackFrame = this.fStackFrame;
        val.fHasChanged = this.fHasChanged;
        val.fSorted = this.fSorted;
        return val;
    }
}

