/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.model;

import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDebugCorePlugin;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class PHPVariable
implements IVariable {
    private PHPValue fValue;
    private String fName;
    private PHPStackFrame fStackFrame;
    private PHPVariable fParent;
    private String fLongName;
    private boolean fModifiable = true;

    PHPVariable() {
        this(null, "", null, "", 0, null);
    }

    public PHPVariable(PHPStackFrame frame, String name, PHPVariable parent, String value, int valueType, Vector subitems) {
        this.fStackFrame = frame;
        this.fValue = new PHPValue(frame, value, valueType, subitems);
        this.fParent = parent;
        this.setName(name);
    }

    public void setName(String name) {
        if (this.fParent == null || this.fParent.getName() == "") {
            this.fLongName = name;
            this.fName = name;
            return;
        }
        switch (this.fParent.getReferenceType()) {
            case 4: {
                this.fName = "['" + name + "']";
                this.fLongName = String.valueOf(this.fParent.getLongName()) + this.fName;
                break;
            }
            case 5: {
                this.fName = name;
                this.fLongName = String.valueOf(this.fParent.getLongName()) + "->" + this.fName;
                break;
            }
            default: {
                this.fName = name;
                this.fLongName = name;
            }
        }
    }

    public IValue getValue() {
        return this.fValue;
    }

    public String getName() {
        return this.fName;
    }

    public PHPVariable getParent() {
        return this.fParent;
    }

    public void setParent(PHPVariable parent) {
        this.fParent = parent;
        switch (this.fParent.getReferenceType()) {
            case 4: {
                this.fLongName = String.valueOf(this.fParent.getLongName()) + this.fName;
                break;
            }
            case 5: {
                this.fLongName = String.valueOf(this.fParent.getLongName()) + "->" + this.fName;
                break;
            }
            default: {
                this.fLongName = this.fName;
            }
        }
    }

    public String getLongName() {
        return this.fLongName;
    }

    public String getReferenceTypeName() {
        return this.fValue.getReferenceTypeName();
    }

    public int getReferenceType() {
        return this.fValue.getReferenceType();
    }

    public int setReferenceType(int type) {
        return ((PHPValue)this.getValue()).setReferenceType(type);
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fValue.hasValueChanged();
    }

    public void setValueChanged(boolean changed) {
        this.fValue.setValueChanged(changed);
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fStackFrame.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public void setValue(String expression) throws DebugException {
        String evalString = this.fValue.getReferenceType() == 3 ? String.valueOf(this.fLongName) + "=\"" + expression + "\"" : String.valueOf(this.fLongName) + "=" + expression;
        PHPVariable[] vars = this.fStackFrame.getPHPDBGProxy().eval(this.fStackFrame, evalString);
        if (!(vars != null && vars.length != 0 || (vars = this.fStackFrame.getPHPDBGProxy().eval(this.fStackFrame, this.fLongName)) != null && vars.length != 0)) {
            int code = 0;
            String msg = "Could not set " + expression + " to " + this.fLongName;
            Status status = new Status(4, "net.sourceforge.phpeclipse.debug.core", code, msg, null);
            PHPDebugCorePlugin.log((IStatus)status);
            throw new DebugException((IStatus)status);
        }
        this.fValue = vars[0].fValue;
        if (this.fValue.hasVariables()) {
            Vector variables = this.fValue.getChildVariables();
            int i = 0;
            while (i < variables.size()) {
                PHPVariable var = (PHPVariable)variables.get(i);
                var.setParent(this);
                if (this.fValue.getReferenceType() == 4) {
                    var.setName(var.getName());
                }
                ++i;
            }
        }
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
    }

    public void setValue(IValue value) throws DebugException {
        this.fValue = (PHPValue)value;
    }

    public boolean supportsValueModification() {
        return this.fModifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.fModifiable = modifiable;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String toString() {
        String str = "";
        block0 : switch (this.getReferenceType()) {
            case 4: {
                int elements = this.fValue.getVariables().length;
                switch (elements) {
                    case 0: {
                        str = String.valueOf(this.getName()) + " [no elements]";
                        break block0;
                    }
                    case 1: {
                        str = String.valueOf(this.getName()) + " [1 element]";
                        break block0;
                    }
                }
                str = String.valueOf(this.getName()) + " [" + elements + " elements]";
                break;
            }
            case 5: {
                str = String.valueOf(this.getName()) + " [class: " + this.fValue.getValueString() + "]";
                break;
            }
            case 3: {
                str = String.valueOf(this.getName()) + " = \"" + this.fValue.getValueString() + "\"";
                break;
            }
            default: {
                str = String.valueOf(this.getName()) + " = " + this.fValue.getValueString();
            }
        }
        return str;
    }

    protected Object clone() throws CloneNotSupportedException {
        PHPVariable var = new PHPVariable();
        var.fValue = this.fValue;
        var.fName = this.fName;
        var.fStackFrame = this.fStackFrame;
        var.fParent = this.fParent;
        var.fLongName = this.fLongName;
        var.fModifiable = this.fModifiable;
        return var;
    }
}

